/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.cnd.editor.fortran.FortranBracketCompletion;
import org.netbeans.modules.cnd.editor.fortran.indent.FortranHotCharIndent;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.openide.util.Exceptions;

public class FKit
extends NbEditorKit {
    private InputAttributes lexerAttrs = null;
    private static ArrayList<Class<?>> actionClasses = null;

    public String getContentType() {
        return "text/x-fortran";
    }

    public void install(JEditorPane c) {
        super.install(c);
    }

    public Document createDefaultDocument() {
        NbEditorDocument doc = new NbEditorDocument("text/x-fortran");
        doc.putProperty((Object)"write-line-separator", (Object)"\n");
        return doc;
    }

    protected void initDocument(BaseDocument doc) {
        super.initDocument(doc);
        doc.putProperty(InputAttributes.class, (Object)this.getLexerAttributes(doc));
        doc.putProperty(Language.class, this.getLanguage());
    }

    private Language<FortranTokenId> getLanguage() {
        return FortranTokenId.languageFortran();
    }

    private synchronized InputAttributes getLexerAttributes(BaseDocument doc) {
        if (this.lexerAttrs == null) {
            this.lexerAttrs = new InputAttributes();
        }
        FortranCodeStyle codeStyle = FortranCodeStyle.get((Document)doc);
        this.lexerAttrs.setValue(this.getLanguage(), (Object)"lexer-filter", this.getFilter(), true);
        this.lexerAttrs.setValue(this.getLanguage(), (Object)"fortran-maximum-text-width", (Object)codeStyle.getRrightMargin(), true);
        this.lexerAttrs.setValue(this.getLanguage(), (Object)"fortran-free-format", (Object)codeStyle.isFreeFormatFortran(), true);
        return this.lexerAttrs;
    }

    private Filter<FortranTokenId> getFilter() {
        return CndLexerUtilities.getFortranFilter();
    }

    protected Action[] createActions() {
        int arraySize = 5;
        int numAddClasses = 0;
        if (actionClasses != null) {
            numAddClasses = actionClasses.size();
            arraySize += numAddClasses;
        }
        Action[] fortranActions = new Action[arraySize];
        int index = 0;
        if (actionClasses != null) {
            for (int i = 0; i < numAddClasses; ++i) {
                Class<?> c = actionClasses.get(i);
                try {
                    fortranActions[index] = (Action)c.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                ++index;
            }
        }
        fortranActions[index++] = new FFormatAction();
        fortranActions[index++] = new CCDefaultKeyTypedAction();
        fortranActions[index++] = new ExtKit.CommentAction("!");
        fortranActions[index++] = new ExtKit.UncommentAction("!");
        fortranActions[index++] = new ExtKit.ToggleCommentAction("!");
        return TextAction.augmentList(super.createActions(), fortranActions);
    }

    public static void addActionClass(Class<?> action) {
        if (actionClasses == null) {
            actionClasses = new ArrayList(2);
        }
        actionClasses.add(action);
    }

    protected void updateActions() {
        super.updateActions();
        this.addSystemActionMapping("format", FFormatAction.class);
    }

    private static class CCDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        private CCDefaultKeyTypedAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkIndentHotChars(JTextComponent target, String typedText) {
            int offset;
            BaseDocument doc = Utilities.getDocument((JTextComponent)target);
            if (FortranHotCharIndent.INSTANCE.getKeywordBasedReformatBlock(doc, offset = target.getCaretPosition(), typedText)) {
                Indent indent = Indent.get((Document)doc);
                indent.lock();
                try {
                    doc.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.TRUE);
                    indent.reindent(offset);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    doc.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.FALSE);
                    indent.unlock();
                }
            }
        }

        protected void insertString(BaseDocument doc, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            super.insertString(doc, dotPos, caret, str, overwrite);
            FortranBracketCompletion.charInserted(doc, dotPos, caret, str.charAt(0));
        }
    }

    public static class FFormatAction
    extends BaseAction {
        public FFormatAction() {
            super("format", 10);
            this.putValue("helpID", FFormatAction.class.getName());
        }

        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                Cursor origCursor = target.getCursor();
                target.setCursor(Cursor.getPredefinedCursor(3));
                doc.runAtomic(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Position endPosition;
                            int startPos;
                            Caret caret = target.getCaret();
                            int caretLine = Utilities.getLineOffset((BaseDocument)doc, (int)caret.getDot());
                            if (Utilities.isSelectionShowing((Caret)caret)) {
                                startPos = target.getSelectionStart();
                                endPosition = doc.createPosition(target.getSelectionEnd());
                            } else {
                                startPos = 0;
                                endPosition = doc.createPosition(doc.getLength());
                            }
                            int pos = startPos;
                            Reformat reformat = Reformat.get((Document)doc);
                            reformat.lock();
                            try {
                                reformat.reformat(pos, endPosition.getOffset());
                            }
                            finally {
                                reformat.unlock();
                            }
                            pos = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)caretLine);
                            if (pos >= 0) {
                                caret.setDot(pos);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
                target.setCursor(origCursor);
            }
        }
    }
}

