/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.cnd.api.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppStringTokenId;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.lexer.FortranLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum FortranTokenId implements TokenId
{
    IDENTIFIER(null, "identifier"),
    KW_ALLOCATABLE("allocatable", "keyword"),
    KW_ALLOCATE("allocate", "keyword"),
    KW_APOSTROPHE("apostrophe", "keyword"),
    KW_ASSIGNMENT("assignment", "keyword"),
    KW_ASSOCIATE("associate", "keyword"),
    KW_ASYNCHRONOUS("asynchronous", "keyword"),
    KW_BACKSPACE("backspace", "keyword"),
    KW_BIND("bind", "keyword"),
    KW_BLOCK("block", "keyword"),
    KW_BLOCKDATA("blockdata", "keyword"),
    KW_CALL("call", "keyword"),
    KW_CASE("case", "keyword"),
    KW_CHARACTER("character", "keyword"),
    KW_CLASS("class", "keyword"),
    KW_CLOSE("close", "keyword"),
    KW_COMMON("common", "keyword"),
    KW_COMPLEX("complex", "keyword"),
    KW_CONTAINS("contains", "keyword"),
    KW_CONTINUE("continue", "keyword"),
    KW_CYCLE("cycle", "keyword"),
    KW_DATA("data", "keyword"),
    KW_DEALLOCATE("deallocate", "keyword"),
    KW_DEFAULT("default", "keyword"),
    KW_DIMENSION("dimension", "keyword"),
    KW_DO("do", "keyword"),
    KW_DOUBLE("double", "keyword"),
    KW_DOUBLEPRECISION("doubleprecision", "keyword"),
    KW_ELEMENTAL("elemental", "keyword"),
    KW_ELSE("else", "keyword"),
    KW_ELSEIF("elseif", "keyword"),
    KW_ELSEWHERE("elsewhere", "keyword"),
    KW_END("end", "keyword"),
    KW_ENDASSOCIATE("endassociate", "keyword"),
    KW_ENDBLOCK("endblock", "keyword"),
    KW_ENDBLOCKDATA("endblockdata", "keyword"),
    KW_ENDDO("enddo", "keyword"),
    KW_ENDENUM("endenum", "keyword"),
    KW_ENDFILE("endfile", "keyword"),
    KW_ENDFORALL("endforall", "keyword"),
    KW_ENDFUNCTION("endfunction", "keyword"),
    KW_ENDIF("endif", "keyword"),
    KW_ENDINTERFACE("endinterface", "keyword"),
    KW_ENDMAP("endmap", "keyword"),
    KW_ENDMODULE("endmodule", "keyword"),
    KW_ENDPROGRAM("endprogram", "keyword"),
    KW_ENDSELECT("endselect", "keyword"),
    KW_ENDSTRUCTURE("endstructure", "keyword"),
    KW_ENDSUBROUTINE("endsubroutine", "keyword"),
    KW_ENDTYPE("endtype", "keyword"),
    KW_ENDUNION("endunion", "keyword"),
    KW_ENDWHERE("endwhere", "keyword"),
    KW_ENDWHILE("endwhile", "keyword"),
    KW_ENTRY("entry", "keyword"),
    KW_ENUM("enum", "keyword"),
    KW_ENUMERATOR("enumerator", "keyword"),
    KW_EQUIVALENCE("equivalance", "keyword"),
    KW_EXIT("exit", "keyword"),
    KW_EXTERNAL("external", "keyword"),
    KW_FLUSH("flush", "keyword"),
    KW_FORALL("forall", "keyword"),
    KW_FORMAT("format", "keyword"),
    KW_FUNCTION("function", "keyword"),
    KW_GO("go", "keyword"),
    KW_GOTO("goto", "keyword"),
    KW_IF("if", "keyword"),
    KW_IMPLICIT("implicit", "keyword"),
    KW_IN("in", "keyword"),
    KW_INCLUDE("include", "keyword"),
    KW_INOUT("inout", "keyword"),
    KW_INQUIRE("inquire", "keyword"),
    KW_INTEGER("integer", "keyword"),
    KW_INTENT("intent", "keyword"),
    KW_INTERFACE("interface", "keyword"),
    KW_INTRINSIC("intrinsic", "keyword"),
    KW_KIND("kind", "keyword"),
    KW_LEN("len", "keyword"),
    KW_LOGICAL("logical", "keyword"),
    KW_MAP("map", "keyword"),
    KW_MODULE("module", "keyword"),
    KW_NAMELIST("namelist", "keyword"),
    KW_NONE("none", "keyword"),
    KW_NULLIFY("nullify", "keyword"),
    KW_ONLY("only", "keyword"),
    KW_OPEN("open", "keyword"),
    KW_OPERATOR("operator", "keyword"),
    KW_OPTIONAL("optional", "keyword"),
    KW_OUT("out", "keyword"),
    KW_PARAMETER("parameter", "keyword"),
    KW_POINTER("pointer", "keyword"),
    KW_PRECISION("precision", "keyword"),
    KW_PRINT("print", "keyword"),
    KW_PRIVATE("private", "keyword"),
    KW_PROCEDURE("procedure", "keyword"),
    KW_PROGRAM("program", "keyword"),
    KW_PROTECTED("protected", "keyword"),
    KW_PUBLIC("public", "keyword"),
    KW_PURE("pure", "keyword"),
    KW_QUOTE("quote", "keyword"),
    KW_READ("read", "keyword"),
    KW_REAL("real", "keyword"),
    KW_RECURSIVE("recursive", "keyword"),
    KW_RESULT("result", "keyword"),
    KW_RETURN("return", "keyword"),
    KW_REWIND("rewind", "keyword"),
    KW_SAVE("save", "keyword"),
    KW_SELECT("select", "keyword"),
    KW_SELECTCASE("selectcase", "keyword"),
    KW_SELECTTYPE("selecttype", "keyword"),
    KW_SEQUENCE("sequence", "keyword"),
    KW_STAT("stat", "keyword"),
    KW_STOP("stop", "keyword"),
    KW_STRUCTURE("structure", "keyword"),
    KW_SUBROUTINE("subroutine", "keyword"),
    KW_TARGET("target", "keyword"),
    KW_THEN("then", "keyword"),
    KW_TO("to", "keyword"),
    KW_TYPE("type", "keyword"),
    KW_UNION("union", "keyword"),
    KW_USE("use", "keyword"),
    KW_VALUE("value", "keyword"),
    KW_VOLATILE("volatile", "keyword"),
    KW_WAIT("wait", "keyword"),
    KW_WHERE("where", "keyword"),
    KW_WHILE("while", "keyword"),
    KW_WRITE("write", "keyword"),
    KW_INT("int", "keyword"),
    KW_SHORT("short", "keyword"),
    KW_LONG("long", "keyword"),
    KW_SIGNED("signed", "keyword"),
    KW_UNSIGNED("unsigned", "keyword"),
    KW_SIZE_T("size_t", "keyword"),
    KW_INT8_T("int8_t", "keyword"),
    KW_INT16_T("int16_t", "keyword"),
    KW_INT32_T("int32_t", "keyword"),
    KW_INT64_T("int64_t", "keyword"),
    KW_INT_LEAST8_T("int_least8_t", "keyword"),
    KW_INT_LEAST16_T("int_least16_t", "keyword"),
    KW_INT_LEAST32_T("int_least32_t", "keyword"),
    KW_INT_LEAST64_T("int_least64_t", "keyword"),
    KW_INT_FAST8_T("int_fast8_t", "keyword"),
    KW_INT_FAST16_T("int_fast16_t", "keyword"),
    KW_INT_FAST32_T("int_fast32_t", "keyword"),
    KW_INT_FAST64_T("int_fast64_t", "keyword"),
    KW_INTMAX_T("intmax_t", "keyword"),
    KW_INTPTR_T("intptr_t", "keyword"),
    KW_FLOAT("float", "keyword"),
    KW__COMPLEX("_Complex", "keyword"),
    KW__BOOL("_Bool", "keyword"),
    KW_CHAR("char", "keyword"),
    KW_BOOL("bool", "keyword"),
    KWOP_EQ(".eq.", "keyword-operator"),
    KWOP_NE(".ne.", "keyword-operator"),
    KWOP_LT(".lt.", "keyword-operator"),
    KWOP_LE(".le.", "keyword-operator"),
    KWOP_GT(".gt.", "keyword-operator"),
    KWOP_GE(".ge.", "keyword-operator"),
    KWOP_AND(".and.", "keyword-operator"),
    KWOP_OR(".or.", "keyword-operator"),
    KWOP_NOT(".not.", "keyword-operator"),
    KWOP_EQV(".eqv.", "keyword-operator"),
    KWOP_NEQV(".neqv.", "keyword-operator"),
    KWOP_TRUE(".true.", "keyword-operator"),
    KWOP_FALSE(".false.", "keyword-operator"),
    OP_POWER("**", "operator"),
    OP_MUL("*", "operator"),
    OP_DIV("/", "operator"),
    OP_PLUS("+", "operator"),
    OP_MINUS("-", "operator"),
    OP_CONCAT("//", "operator"),
    OP_LOG_EQ("==", "operator"),
    OP_NOT_EQ("/=", "operator"),
    OP_LT("<", "operator"),
    OP_LT_EQ("<=", "operator"),
    OP_GT(">", "operator"),
    OP_GT_EQ(">=", "operator"),
    OP_LT_GT("<>", "operator"),
    EQ("=", "special"),
    DOT(".", "special"),
    COMMA(",", "special"),
    COLON(":", "special"),
    DOUBLECOLON("::", "special"),
    LPAREN("(", "special"),
    RPAREN(")", "special"),
    APOSTROPHE_CHAR("'", "special"),
    EXCLAMATION("!", "special"),
    QUOTATION("\"", "special"),
    PERCENT("%", "special"),
    AMPERSAND("&", "special"),
    SEMICOLON(";", "special"),
    QUESTION_MARK("?", "special"),
    CURRENCY("$", "special"),
    NUM_LITERAL_INT(null, "number"),
    NUM_LITERAL_REAL(null, "number"),
    NUM_LITERAL_COMPLEX(null, "number"),
    NUM_LITERAL_BINARY(null, "number"),
    NUM_LITERAL_HEX(null, "number"),
    NUM_LITERAL_OCTAL(null, "number"),
    STRING_LITERAL(null, "string"),
    WHITESPACE(null, "whitespace"),
    NEW_LINE(null, "whitespace"),
    LINE_COMMENT_FIXED(null, "comment"),
    LINE_COMMENT_FREE(null, "comment"),
    LINE_CONTINUATION_FIXED(null, "continuation"),
    ERROR(null, "error"),
    ERR_INVALID_HEX_LITERAL(null, "error"),
    ERR_INVALID_OCTAL_LITERAL(null, "error"),
    ERR_INVALID_BINARY_LITERAL(null, "error"),
    ERR_INVALID_CHAR(null, "error"),
    ERR_INVALID_INTEGER(null, "error"),
    ERR_INCOMPLETE_STRING_LITERAL(null, "error"),
    PREPROCESSOR_DIRECTIVE(null, "preprocessor");

    public static final String WHITESPACE_CATEGORY = "whitespace";
    public static final String COMMENT_CATEGORY = "comment";
    public static final String KEYWORD_CATEGORY = "keyword";
    public static final String KEYWORD_OPERATOR_CATEGORY = "keyword-operator";
    public static final String ERROR_CATEGORY = "error";
    public static final String NUMBER_CATEGORY = "number";
    public static final String LITERAL_CATEGORY = "literal";
    public static final String STRING_CATEGORY = "string";
    public static final String OPERATOR_CATEGORY = "operator";
    public static final String SPECIAL_CATEGORY = "special";
    public static final String PREPROCESSOR_CATEGORY = "preprocessor";
    private final String fixedText;
    private final String primaryCategory;
    private static final Language<FortranTokenId> languageFortran;

    private FortranTokenId(String fixedText, String primaryCategory) {
        this.fixedText = fixedText;
        this.primaryCategory = primaryCategory;
    }

    public String fixedText() {
        return this.fixedText;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<FortranTokenId> languageFortran() {
        return languageFortran;
    }

    static {
        languageFortran = FortranHierarchy.createFortranLanguage();
    }

    private static final class FortranHierarchy
    extends LanguageHierarchy<FortranTokenId> {
        private FortranHierarchy() {
        }

        private static Language<FortranTokenId> createFortranLanguage() {
            return new FortranHierarchy().language();
        }

        protected String mimeType() {
            return "text/x-fortran";
        }

        protected Collection<FortranTokenId> createTokenIds() {
            return EnumSet.allOf(FortranTokenId.class);
        }

        protected Map<String, Collection<FortranTokenId>> createTokenCategories() {
            HashMap<String, Collection<FortranTokenId>> cats = new HashMap<String, Collection<FortranTokenId>>();
            cats.put(FortranTokenId.ERROR_CATEGORY, EnumSet.of(ERR_INCOMPLETE_STRING_LITERAL, new FortranTokenId[]{ERR_INVALID_BINARY_LITERAL, ERR_INVALID_CHAR, ERR_INVALID_HEX_LITERAL, ERR_INVALID_INTEGER, ERR_INVALID_OCTAL_LITERAL}));
            EnumSet<FortranTokenId[]> l = EnumSet.of(NUM_LITERAL_INT, new FortranTokenId[]{NUM_LITERAL_BINARY, NUM_LITERAL_COMPLEX, NUM_LITERAL_HEX, NUM_LITERAL_OCTAL, NUM_LITERAL_REAL, STRING_LITERAL});
            cats.put(FortranTokenId.LITERAL_CATEGORY, l);
            return cats;
        }

        protected Lexer<FortranTokenId> createLexer(LexerRestartInfo<FortranTokenId> info) {
            return new FortranLexer(CndLexerUtilities.getFortranFilter(), info);
        }

        protected LanguageEmbedding<?> embedding(Token<FortranTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
            switch ((FortranTokenId)token.id()) {
                case STRING_LITERAL: {
                    return LanguageEmbedding.create(CppStringTokenId.languageDouble(), (int)0, (int)0);
                }
                case PREPROCESSOR_DIRECTIVE: {
                    return LanguageEmbedding.create(CppTokenId.languagePreproc(), (int)0, (int)0);
                }
            }
            return null;
        }
    }
}

