/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;

public class DatasourceHelper {
    private DatasourceHelper() {
    }

    public static List<DatabaseConnection> findDatabaseConnections(Datasource datasource) {
        if (datasource == null) {
            throw new NullPointerException("The datasource parameter cannot be null.");
        }
        String string = datasource.getUrl();
        String string2 = datasource.getUsername();
        if (string == null || string2 == null) {
            return Collections.emptyList();
        }
        ArrayList<DatabaseConnection> arrayList = new ArrayList<DatabaseConnection>();
        for (DatabaseConnection databaseConnection : ConnectionManager.getDefault().getConnections()) {
            if (!string.equals(databaseConnection.getDatabaseURL()) || !string2.equals(databaseConnection.getUser())) continue;
            arrayList.add(databaseConnection);
        }
        if (arrayList.size() > 0) {
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    public static Datasource findDatasource(J2eeModuleProvider j2eeModuleProvider, String string) throws ConfigurationException {
        if (j2eeModuleProvider == null) {
            throw new NullPointerException("The provider parameter cannot be null.");
        }
        if (string == null) {
            throw new NullPointerException("The jndiName parameter cannot be null.");
        }
        for (Datasource datasource : j2eeModuleProvider.getServerDatasources()) {
            if (!string.equals(datasource.getJndiName())) continue;
            return datasource;
        }
        for (Datasource datasource : j2eeModuleProvider.getModuleDatasources()) {
            if (!string.equals(datasource.getJndiName())) continue;
            return datasource;
        }
        return null;
    }
}

