/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;

public final class J2eeProjectCapabilities {
    private final J2eeModuleProvider provider;
    private final Profile ejbJarProfile;

    private J2eeProjectCapabilities(J2eeModuleProvider j2eeModuleProvider, Profile profile) {
        this.provider = j2eeModuleProvider;
        this.ejbJarProfile = profile;
    }

    @CheckForNull
    public static J2eeProjectCapabilities forProject(Project project) {
        EjbJar[] ejbJarArray;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return null;
        }
        Profile profile = null;
        if ((j2eeModuleProvider.getJ2eeModule().getType() == J2eeModule.Type.EJB || j2eeModuleProvider.getJ2eeModule().getType() == J2eeModule.Type.WAR) && (ejbJarArray = EjbJar.getEjbJars((Project)project)).length > 0) {
            profile = ejbJarArray[0].getJ2eeProfile();
        }
        return new J2eeProjectCapabilities(j2eeModuleProvider, profile);
    }

    public boolean isEjb30Supported() {
        J2eeModule.Type type = this.provider.getJ2eeModule().getType();
        boolean bl = this.ejbJarProfile != null && (this.ejbJarProfile.equals(Profile.JAVA_EE_5) || this.ejbJarProfile.equals(Profile.JAVA_EE_6_FULL));
        return J2eeModule.Type.EJB.equals(type) && bl;
    }

    public boolean isEjb31Supported() {
        J2eeModule.Type type = this.provider.getJ2eeModule().getType();
        boolean bl = this.ejbJarProfile != null && this.ejbJarProfile.equals(Profile.JAVA_EE_6_FULL);
        return bl && (J2eeModule.Type.EJB.equals(type) || J2eeModule.Type.WAR.equals(type));
    }

    public boolean isEjb31LiteSupported() {
        J2eeModule.Type type = this.provider.getJ2eeModule().getType();
        boolean bl = this.ejbJarProfile != null && this.ejbJarProfile.equals(Profile.JAVA_EE_6_WEB);
        return this.isEjb31Supported() || J2eeModule.Type.WAR.equals(type) && bl;
    }

    public boolean hasDefaultPersistenceProvider() {
        J2eePlatform j2eePlatform = this.getPlatform();
        if (j2eePlatform == null) {
            return false;
        }
        Set set = j2eePlatform.getSupportedProfiles(this.provider.getJ2eeModule().getType());
        return (set.contains(Profile.JAVA_EE_5) || set.contains(Profile.JAVA_EE_6_FULL)) && j2eePlatform.isToolSupported("defaultPersistenceProviderJavaEE5");
    }

    private J2eePlatform getPlatform() {
        try {
            String string = this.provider.getServerInstanceID();
            if (string != null) {
                return Deployment.getDefault().getServerInstance(this.provider.getServerInstanceID()).getJ2eePlatform();
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            // empty catch block
        }
        return null;
    }
}

