/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.modelutil.AntiLoop;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.CharSequences;
import org.openide.util.Lookup;

public abstract class CsmVirtualInfoQuery {
    private static final CsmVirtualInfoQuery EMPTY = new Empty();
    private static CsmVirtualInfoQuery defaultQuery;

    public abstract boolean isVirtual(CsmMethod var1);

    public abstract Collection<CsmMethod> getTopmostBaseDeclarations(CsmMethod var1);

    public abstract Collection<CsmMethod> getFirstBaseDeclarations(CsmMethod var1);

    public abstract Collection<CsmMethod> getAllBaseDeclarations(CsmMethod var1);

    public abstract Collection<CsmMethod> getOverriddenMethods(CsmMethod var1, boolean var2);

    protected CsmVirtualInfoQuery() {
    }

    public static CsmVirtualInfoQuery getDefault() {
        if (defaultQuery != null) {
            return defaultQuery;
        }
        defaultQuery = (CsmVirtualInfoQuery)Lookup.getDefault().lookup(CsmVirtualInfoQuery.class);
        return defaultQuery == null ? EMPTY : defaultQuery;
    }

    private static boolean methodEquals(CsmMethod toSearch, CsmMethod method) {
        if (!toSearch.getName().equals(method.getName())) {
            return false;
        }
        Collection list1 = toSearch.getParameters();
        Collection list2 = method.getParameters();
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator it2 = list2.iterator();
        for (CsmParameter p1 : list1) {
            CsmParameter p2 = (CsmParameter)it2.next();
            if (p1 != null && p2 != null) {
                if (p1.isVarArgs() && p2.isVarArgs()) continue;
                CsmType type1 = p1.getType();
                CsmType type2 = p2.getType();
                if (type1 != null && type2 != null) {
                    CsmClassifier classifier1 = type1.getClassifier();
                    CsmClassifier classifier2 = type1.getClassifier();
                    if (!(classifier1 != null && classifier2 != null ? !classifier1.equals(classifier2) : CharSequences.comparator().compare(type1.getText(), type2.getText()) != 0)) continue;
                    return false;
                }
                if (type1 == null && type2 == null) {
                    continue;
                }
            } else if (p1 == null && p2 == null) continue;
            return false;
        }
        return true;
    }

    private static final class Empty
    extends CsmVirtualInfoQuery {
        private Empty() {
        }

        @Override
        public boolean isVirtual(CsmMethod method) {
            if (method.isVirtual()) {
                return true;
            }
            return this.processClass(method, method.getContainingClass(), new AntiLoop());
        }

        private boolean processClass(CsmMethod toSearch, CsmClass cls, AntiLoop antilLoop) {
            if (cls == null || antilLoop.contains((CsmClassifier)cls)) {
                return false;
            }
            antilLoop.add((CsmClassifier)cls);
            for (CsmMember m : cls.getMembers()) {
                CsmMethod met;
                if (!CsmKindUtilities.isMethod((CsmObject)m) || !CsmVirtualInfoQuery.methodEquals(toSearch, met = (CsmMethod)m)) continue;
                if (!met.isVirtual()) break;
                return true;
            }
            for (CsmInheritance inh : cls.getBaseClasses()) {
                if (!this.processClass(toSearch, CsmInheritanceUtilities.getCsmClass(inh), antilLoop)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<CsmMethod> getTopmostBaseDeclarations(CsmMethod method) {
            return this.getBaseDeclaration(method, Overridden.TOP);
        }

        @Override
        public Collection<CsmMethod> getFirstBaseDeclarations(CsmMethod method) {
            return this.getBaseDeclaration(method, Overridden.FIRST);
        }

        @Override
        public Collection<CsmMethod> getAllBaseDeclarations(CsmMethod method) {
            return this.getBaseDeclaration(method, Overridden.ALL);
        }

        private Collection<CsmMethod> getBaseDeclaration(CsmMethod method, Overridden overridden) {
            HashSet<CharSequence> antilLoop = new HashSet<CharSequence>();
            HashSet<CsmMethod> result = new HashSet<CsmMethod>();
            CsmClass cls = method.getContainingClass();
            if (cls != null) {
                for (CsmInheritance inh : cls.getBaseClasses()) {
                    this.processMethod(method, CsmInheritanceUtilities.getCsmClass(inh), antilLoop, null, null, result, overridden);
                }
            }
            return result;
        }

        private void processMethod(CsmMethod toSearch, CsmClass cls, Set<CharSequence> antilLoop, CsmMethod firstFound, CsmMethod lastFound, Set<CsmMethod> result, Overridden overridden) {
            CsmMethod m;
            boolean theLastInHierarchy;
            if (cls == null || antilLoop.contains(cls.getQualifiedName())) {
                theLastInHierarchy = true;
            } else {
                antilLoop.add(cls.getQualifiedName());
                for (CsmMember member : cls.getMembers()) {
                    CsmMethod method;
                    if (!CsmKindUtilities.isMethod((CsmObject)member) || !CsmVirtualInfoQuery.methodEquals(toSearch, method = (CsmMethod)member)) continue;
                    if (firstFound == null) {
                        firstFound = method;
                    }
                    lastFound = method;
                    if (!method.isVirtual()) continue;
                    switch (overridden) {
                        case FIRST: {
                            result.add(firstFound);
                            return;
                        }
                        case ALL: {
                            result.add(method);
                        }
                    }
                }
                theLastInHierarchy = cls.getBaseClasses().isEmpty();
                for (CsmInheritance inh : cls.getBaseClasses()) {
                    this.processMethod(toSearch, CsmInheritanceUtilities.getCsmClass(inh), antilLoop, firstFound, lastFound, result, overridden);
                }
            }
            if (theLastInHierarchy && (m = lastFound) != null && m.isVirtual()) {
                CndUtils.assertNotNull((Object)firstFound, (String)"last found != null && first found == null ?!");
                switch (overridden) {
                    case FIRST: {
                        result.add(firstFound);
                        break;
                    }
                    case TOP: {
                        result.add(m);
                    }
                }
            }
        }

        @Override
        public Collection<CsmMethod> getOverriddenMethods(CsmMethod method, boolean searchFromBase) {
            CsmClass cls;
            HashSet<CsmMethod> res = new HashSet<CsmMethod>();
            if (searchFromBase) {
                Iterator<CsmMethod> it = this.getTopmostBaseDeclarations(method).iterator();
                if (it.hasNext()) {
                    method = it.next();
                }
                res.add(method);
            }
            if ((cls = method.getContainingClass()) != null) {
                block0: for (CsmReference ref : CsmTypeHierarchyResolver.getDefault().getSubTypes(cls, false)) {
                    CsmClass c = (CsmClass)ref.getOwner();
                    if (c == null) continue;
                    for (CsmMember m : c.getMembers()) {
                        CsmMethod met;
                        if (!CsmKindUtilities.isMethod((CsmObject)m) || !CsmVirtualInfoQuery.methodEquals(met = (CsmMethod)m, method)) continue;
                        res.add(met);
                        continue block0;
                    }
                }
            }
            return res;
        }

        private static enum Overridden {
            FIRST,
            TOP,
            ALL;

        }
    }
}

