/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.progress;

import java.util.ArrayList;
import java.util.Arrays;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.tomcat5.progress.ProgressEventSupport;
import org.netbeans.modules.tomcat5.progress.Status;
import org.openide.util.Parameters;

public class MultiProgressObjectWrapper
implements ProgressObject,
ProgressListener {
    private final ProgressEventSupport pes = new ProgressEventSupport(this);
    private final ProgressObject[] progressObjects;
    private String message = "";
    private StateType state = StateType.RUNNING;

    public MultiProgressObjectWrapper(ProgressObject[] progressObjectArray) {
        Parameters.notNull((CharSequence)"progObjs", (Object)this.state);
        if (progressObjectArray.length == 0) {
            throw new IllegalArgumentException("At least one progress object must be passed.");
        }
        this.progressObjects = new ProgressObject[progressObjectArray.length];
        System.arraycopy(progressObjectArray, 0, this.progressObjects, 0, progressObjectArray.length);
        for (int i = 0; i < progressObjectArray.length; ++i) {
            ProgressObject progressObject = progressObjectArray[i];
            progressObject.addProgressListener((ProgressListener)this);
        }
        this.updateState(null);
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public synchronized DeploymentStatus getDeploymentStatus() {
        DeploymentStatus deploymentStatus = this.progressObjects[0].getDeploymentStatus();
        return new Status(deploymentStatus.getAction(), deploymentStatus.getCommand(), this.message, this.state);
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        ArrayList<TargetModuleID> arrayList = new ArrayList<TargetModuleID>();
        for (int i = 0; i < this.progressObjects.length; ++i) {
            ProgressObject progressObject = this.progressObjects[i];
            if (!progressObject.getDeploymentStatus().isCompleted()) continue;
            arrayList.addAll(Arrays.asList(progressObject.getResultTargetModuleIDs()));
        }
        return arrayList.toArray(new TargetModuleID[arrayList.size()]);
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("cancel not supported in Tomcat deployment");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("stop not supported in Tomcat deployment");
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.pes.addProgressListener(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.pes.removeProgressListener(progressListener);
    }

    public synchronized void handleProgressEvent(ProgressEvent progressEvent) {
        this.updateState(progressEvent.getDeploymentStatus().getMessage());
        this.pes.fireHandleProgressEvent(progressEvent.getTargetModuleID(), progressEvent.getDeploymentStatus());
    }

    private synchronized void updateState(String string) {
        if (this.state == StateType.COMPLETED || this.state == StateType.FAILED) {
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        for (ProgressObject progressObject : this.progressObjects) {
            DeploymentStatus deploymentStatus = progressObject.getDeploymentStatus();
            if (deploymentStatus == null || !deploymentStatus.isCompleted() && !deploymentStatus.isFailed()) {
                bl = false;
                break;
            }
            if (!deploymentStatus.isFailed()) continue;
            bl2 = true;
        }
        if (bl) {
            this.state = bl2 ? StateType.FAILED : StateType.COMPLETED;
            this.message = string == null ? "" : string;
        }
    }
}

