/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.modules.junit.JUnitPluginTrampoline;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.junit.wizards.EmptyTestStepLocation;
import org.netbeans.modules.junit.wizards.StepProblemMessage;
import org.netbeans.modules.junit.wizards.Utils;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class EmptyTestCaseWizardIterator
implements TemplateWizard.Iterator {
    private static EmptyTestCaseWizardIterator instance;
    private TemplateWizard wizard;
    private static final int INDEX_TARGET = 2;
    private final String nameTarget = NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"LBL_panel_Target");
    private int current;
    private List<ChangeListener> changeListeners;
    private WizardDescriptor.Panel<WizardDescriptor> targetPanel;
    private Project lastSelectedProject = null;
    private WizardDescriptor.Panel optionsPanel;

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>(2);
        }
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    private void fireChange() {
        if (this.changeListeners != null) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    public boolean hasPrevious() {
        return this.current > 2;
    }

    public boolean hasNext() {
        return this.current < 2;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.current;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.current;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        switch (this.current) {
            case 2: {
                return this.getTargetPanel();
            }
        }
        throw new IllegalStateException();
    }

    private WizardDescriptor.Panel<WizardDescriptor> getTargetPanel() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        if (this.targetPanel == null || project != this.lastSelectedProject) {
            Collection collection = Utils.getTestTargets(project, true);
            if (collection.isEmpty() && SourceGroupModifier.createSourceGroup((Project)project, (String)"java", (String)"test") != null) {
                collection = Utils.getTestTargets(project, true);
            }
            if (collection.isEmpty()) {
                this.targetPanel = new StepProblemMessage(project, NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"MSG_NoTestSourceGroup"));
            } else {
                SourceGroup[] sourceGroupArray = new SourceGroup[collection.size()];
                collection.toArray(sourceGroupArray);
                if (this.optionsPanel == null) {
                    this.optionsPanel = new EmptyTestStepLocation();
                }
                this.targetPanel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)this.optionsPanel);
            }
            this.lastSelectedProject = project;
        }
        return this.targetPanel;
    }

    public String name() {
        switch (this.current) {
            case 2: {
                return this.nameTarget;
            }
        }
        throw new AssertionError(this.current);
    }

    private void loadSettings(TemplateWizard templateWizard) {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        templateWizard.putProperty("SetUp", (Object)jUnitSettings.isGenerateSetUp());
        templateWizard.putProperty("TearDown", (Object)jUnitSettings.isGenerateTearDown());
        templateWizard.putProperty("Comments", (Object)jUnitSettings.isBodyComments());
    }

    private void saveSettings(TemplateWizard templateWizard) {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        jUnitSettings.setGenerateSetUp(Boolean.TRUE.equals(templateWizard.getProperty("SetUp")));
        jUnitSettings.setGenerateTearDown(Boolean.TRUE.equals(templateWizard.getProperty("TearDown")));
        jUnitSettings.setBodyComments(Boolean.TRUE.equals(templateWizard.getProperty("Comments")));
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wizard = templateWizard;
        this.current = 2;
        this.loadSettings(templateWizard);
        String[] stringArray = new String[]{NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"LBL_panel_chooseFileType"), NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"LBL_panel_Target")};
        ((JComponent)this.getTargetPanel().getComponent()).putClientProperty("WizardPanel_contentData", stringArray);
        ((JComponent)this.getTargetPanel().getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.wizard = null;
        this.targetPanel = null;
        this.lastSelectedProject = null;
        this.optionsPanel = null;
        this.changeListeners = null;
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        DataObject dataObject;
        this.saveSettings(templateWizard);
        String string = Templates.getTargetName((WizardDescriptor)templateWizard);
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        Map<JUnitPlugin.CreateTestParam, Object> map = TestUtil.getSettingsMap(false);
        map.put(JUnitPlugin.CreateTestParam.CLASS_NAME, Templates.getTargetName((WizardDescriptor)templateWizard));
        JUnitPlugin jUnitPlugin = TestUtil.getPluginForProject(Templates.getProject((WizardDescriptor)templateWizard));
        if (!JUnitPluginTrampoline.DEFAULT.createTestActionCalled(jUnitPlugin, new FileObject[]{fileObject})) {
            return null;
        }
        FileObject[] fileObjectArray = JUnitPluginTrampoline.DEFAULT.createTests(jUnitPlugin, null, fileObject, map);
        if (fileObjectArray == null) {
            throw new IOException();
        }
        try {
            dataObject = DataObject.find((FileObject)fileObjectArray[0]);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw new IOException();
        }
        return Collections.singleton(dataObject);
    }

    public static EmptyTestCaseWizardIterator singleton() {
        if (instance == null) {
            instance = new EmptyTestCaseWizardIterator();
        }
        return instance;
    }
}

