/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gsf.testrunner.ResultBar;
import org.netbeans.modules.gsf.testrunner.api.CallstackFrameNode;
import org.netbeans.modules.gsf.testrunner.api.Locator;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.ResultDisplayHandler;
import org.netbeans.modules.gsf.testrunner.api.ResultTreeView;
import org.netbeans.modules.gsf.testrunner.api.RootNode;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

final class ResultPanelTree
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private static ResourceBundle bundle = NbBundle.getBundle(ResultPanelTree.class);
    private final ExplorerManager explorerManager;
    private final RootNode rootNode;
    private final ResultTreeView treeView;
    private boolean filtered = false;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent;
    private final ResultDisplayHandler displayHandler;
    private final ResultBar resultBar = new ResultBar();

    ResultPanelTree(ResultDisplayHandler displayHandler) {
        super(new BorderLayout());
        this.treeView = new ResultTreeView();
        this.treeView.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_TestResults"));
        this.treeView.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TestResults"));
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.addSeparator(new Dimension(1, 0));
        toolBar.add(this.resultBar);
        this.add((Component)toolBar, "North");
        this.add((Component)((Object)this.treeView), "Center");
        this.explorerManager = new ExplorerManager();
        this.rootNode = new RootNode(displayHandler.getSession(), this.filtered);
        this.explorerManager.setRootContext((Node)this.rootNode);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.initAccessibility();
        this.displayHandler = displayHandler;
        displayHandler.setLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)new ActionMap()));
    }

    private void initAccessibility() {
        AccessibleContext accessCtx = this.getAccessibleContext();
        accessCtx.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_ResultPanelTree"));
        accessCtx.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_ResultPanelTree"));
        accessCtx = this.treeView.getHorizontalScrollBar().getAccessibleContext();
        accessCtx.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_HorizontalScrollbar"));
        accessCtx = this.treeView.getVerticalScrollBar().getAccessibleContext();
        accessCtx.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_HorizontalScrollbar"));
    }

    void displayMsg(String msg) {
        assert (EventQueue.isDispatchThread());
        this.rootNode.displayMessage(msg);
    }

    void displayMsgSessionFinished(String msg) {
        assert (EventQueue.isDispatchThread());
        this.rootNode.displayMessageSessionFinished(msg);
        this.resultBar.stop();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.displayHandler.setTreePanel(this);
    }

    void displaySuiteRunning(String suiteName) {
        assert (EventQueue.isDispatchThread());
        this.rootNode.displaySuiteRunning(suiteName);
    }

    void displaySuiteRunning(TestSuite suite) {
        assert (EventQueue.isDispatchThread());
        this.rootNode.displaySuiteRunning(suite);
    }

    void displayReport(Report report) {
        assert (EventQueue.isDispatchThread());
        TestsuiteNode node = this.rootNode.displayReport(report);
        if (node != null && report.completed && (report.containsFailed() || Status.PENDING == report.getStatus()) && node.getChildren().getNodesCount() != 0) {
            this.treeView.expandReportNode(node);
        }
        this.resultBar.setPassedPercentage(this.rootNode.getPassedPercentage());
    }

    public void displayReports(List<Report> reports) {
        assert (EventQueue.isDispatchThread());
        if (reports.size() == 1) {
            this.displayReport(reports.get(0));
        } else {
            this.rootNode.displayReports(reports);
        }
        this.resultBar.setPassedPercentage(this.rootNode.getPassedPercentage());
    }

    int getSuccessDisplayedLevel() {
        return this.rootNode.getSuccessDisplayedLevel();
    }

    void viewOpened() {
        assert (EventQueue.isDispatchThread());
    }

    void setFiltered(boolean filtered) {
        if (filtered == this.filtered) {
            return;
        }
        this.filtered = filtered;
        this.rootNode.setFiltered(filtered);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("selectedNodes".equals(e.getPropertyName())) {
            this.nodeSelectionChanged();
        }
    }

    private void nodeSelectionChanged() {
        assert (EventQueue.isDispatchThread());
        this.fireChange();
    }

    void setChangeListener(ChangeListener l) {
        assert (EventQueue.isDispatchThread());
        this.changeListener = l;
        if (this.changeListener == null) {
            this.changeEvent = null;
        } else if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
    }

    private void fireNodeSelectionChange() {
        this.fireChange();
    }

    private void fireChange() {
        assert (EventQueue.isDispatchThread());
        if (this.changeListener != null) {
            this.changeListener.stateChanged(this.changeEvent);
        }
    }

    Node[] getSelectedNodes() {
        return this.explorerManager.getSelectedNodes();
    }

    private void selectAndActivateNode(Node node) {
        Node[] nodeArray = new Node[]{node};
        try {
            this.explorerManager.setSelectedNodes(nodeArray);
            this.fireNodeSelectionChange();
        }
        catch (PropertyVetoException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
            nodeArray = new Node[]{};
            try {
                this.explorerManager.setSelectedNodes(nodeArray);
                this.fireNodeSelectionChange();
            }
            catch (PropertyVetoException ex2) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex2);
            }
        }
        Locator locator = (Locator)node.getLookup().lookup(Locator.class);
        if (locator != null) {
            locator.jumpToSource(node);
        }
    }

    private List<TestMethodNode> getFailedTestMethodNodes() {
        ArrayList<TestMethodNode> result = new ArrayList<TestMethodNode>();
        for (Node each : this.explorerManager.getRootContext().getChildren().getNodes()) {
            if (!(each instanceof TestsuiteNode)) continue;
            TestsuiteNode suite = (TestsuiteNode)each;
            for (Node node : suite.getChildren().getNodes()) {
                TestMethodNode testMethod;
                if (!(node instanceof TestMethodNode) || !(testMethod = (TestMethodNode)node).failed()) continue;
                result.add(testMethod);
            }
        }
        return result;
    }

    private TestMethodNode getFirstFailedTestMethodNode() {
        List<TestMethodNode> failed = this.getFailedTestMethodNodes();
        return failed.isEmpty() ? null : failed.get(0);
    }

    private List<TestsuiteNode> getFailedSuiteNodes(TestsuiteNode selected) {
        ArrayList<TestsuiteNode> before = new ArrayList<TestsuiteNode>();
        ArrayList<TestsuiteNode> after = new ArrayList<TestsuiteNode>();
        boolean selectedEncountered = false;
        block0: for (Node each : this.explorerManager.getRootContext().getChildren().getNodes()) {
            if (!(each instanceof TestsuiteNode)) continue;
            TestsuiteNode suite = (TestsuiteNode)each;
            if (suite.equals((Object)selected)) {
                selectedEncountered = true;
            }
            for (Node node : suite.getChildren().getNodes()) {
                TestMethodNode testMethod;
                if (!(node instanceof TestMethodNode) || !(testMethod = (TestMethodNode)node).failed()) continue;
                if (selectedEncountered) {
                    after.add(suite);
                    continue block0;
                }
                before.add(suite);
                continue block0;
            }
        }
        after.addAll(before);
        return after;
    }

    void selectPreviousFailure() {
        Node[] selectedNodes = this.getSelectedNodes();
        if (selectedNodes.length == 0) {
            List<TestMethodNode> failedNodes = this.getFailedTestMethodNodes();
            if (!failedNodes.isEmpty()) {
                this.selectAndActivateNode((Node)failedNodes.get(failedNodes.size() - 1));
            }
            return;
        }
        Node selected = selectedNodes[0];
        TestsuiteNode suite = this.getSelectedSuite(selected);
        if (suite == null) {
            return;
        }
        Node[] children = suite.getChildren().getNodes();
        boolean selectedEncountered = false;
        for (int i = children.length; i > 0; --i) {
            TestMethodNode testMethod = (TestMethodNode)children[i - 1];
            if (this.isSelected(testMethod, selected)) {
                selectedEncountered = true;
                continue;
            }
            if (!selectedEncountered || !testMethod.failed()) continue;
            this.selectAndActivateNode((Node)testMethod);
            return;
        }
        List<TestsuiteNode> failedSuites = this.getFailedSuiteNodes(suite);
        failedSuites.remove((Object)suite);
        Collections.reverse(failedSuites);
        for (TestsuiteNode suiteNode : failedSuites) {
            children = suiteNode.getChildren().getNodes();
            for (int i = children.length; i > 0; --i) {
                TestMethodNode testMethod = (TestMethodNode)children[i - 1];
                if (!testMethod.failed()) continue;
                this.selectAndActivateNode((Node)testMethod);
                return;
            }
        }
    }

    void selectNextFailure() {
        Node[] selectedNodes = this.getSelectedNodes();
        if (selectedNodes.length == 0) {
            TestMethodNode firstFailed = this.getFirstFailedTestMethodNode();
            if (firstFailed != null) {
                this.selectAndActivateNode((Node)firstFailed);
            }
            return;
        }
        Node selected = selectedNodes[0];
        TestsuiteNode suite = this.getSelectedSuite(selected);
        if (suite == null) {
            return;
        }
        boolean selectedEncountered = selected.equals((Object)suite);
        for (Node child : suite.getChildren().getNodes()) {
            TestMethodNode testMethod = (TestMethodNode)child;
            if (!selectedEncountered && this.isSelected(testMethod, selected)) {
                selectedEncountered = true;
                continue;
            }
            if (!selectedEncountered || !testMethod.failed()) continue;
            this.selectAndActivateNode((Node)testMethod);
            return;
        }
        List<TestsuiteNode> failedSuites = this.getFailedSuiteNodes(suite);
        if (selectedEncountered) {
            failedSuites.remove((Object)suite);
        }
        for (TestsuiteNode suiteNode : failedSuites) {
            for (Node child : suiteNode.getChildren().getNodes()) {
                TestMethodNode testMethod = (TestMethodNode)child;
                if (!testMethod.failed()) continue;
                this.selectAndActivateNode((Node)testMethod);
                return;
            }
        }
    }

    private boolean isSelected(TestMethodNode testMethod, Node selected) {
        if (testMethod.equals(selected)) {
            return true;
        }
        for (Node node : testMethod.getChildren().getNodes()) {
            if (!node.equals((Object)selected)) continue;
            return true;
        }
        return false;
    }

    private TestsuiteNode getSelectedSuite(Node selected) {
        if (selected instanceof TestMethodNode) {
            return (TestsuiteNode)selected.getParentNode();
        }
        if (selected instanceof TestsuiteNode) {
            return (TestsuiteNode)selected;
        }
        if (selected instanceof CallstackFrameNode) {
            return (TestsuiteNode)selected.getParentNode().getParentNode();
        }
        return this.getFirstFailedSuite();
    }

    private TestsuiteNode getFirstFailedSuite() {
        List<TestsuiteNode> suites = this.getFailedSuiteNodes(null);
        return suites.isEmpty() ? null : suites.get(0);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }
}

