/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.FileHeader;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.LoadFile;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.SourceInfo;

class FileWindow
extends JInternalFrame
implements ActionListener,
DocumentListener {
    Main db;
    SourceInfo sourceInfo;
    FileTextArea textArea;
    FileHeader fileHeader;
    JScrollPane p;
    int currentPos;
    JLabel statusBar;
    boolean isModified = false;

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Cut")) {
            this.textArea.cut();
        } else if (cmd.equals("Copy")) {
            this.textArea.copy();
        } else if (cmd.equals("Paste")) {
            this.textArea.paste();
        }
    }

    void runToCursor(ActionEvent e) {
        try {
            this.db.runToCursor(this.getUrl(), this.textArea.getLineOfOffset(this.textArea.getCaretPosition()) + 1, e);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void load() {
        Scriptable scope = this.db.officeScripts.getScriptScope(this.getUrl());
        if (scope == null) {
            scope = this.db.getScope();
        }
        if (scope == null) {
            MessageDialogWrapper.showMessageDialog(this.db, "Can't load scripts: no scope available", "Run", 0);
        } else {
            String url = this.getUrl();
            if (url != null) {
                new Thread(new LoadFile(this.db, scope, url, new StringReader(this.textArea.getText()))).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        if (this.getUrl() != null) {
            OutputStream os = null;
            try {
                if (this.getUrl().startsWith("vnd.sun.star")) {
                    URL scriptUrl = this.db.officeScripts.getScriptUrl(this.getUrl());
                    if (scriptUrl == null) {
                        throw new IOException("Can't optain stream for " + this.getUrl());
                    }
                    os = scriptUrl.openConnection().getOutputStream();
                } else {
                    os = new FileOutputStream(this.getUrl());
                }
                String s = this.textArea.getText();
                os.write(s.getBytes(), 0, s.length());
                this.isModified = false;
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Error saving file: " + ioe.getMessage(), "Error", 0);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                        os = null;
                    }
                    catch (IOException ioe) {
                        System.err.println("Error closing stream: " + ioe.getMessage());
                        ioe.printStackTrace();
                    }
                }
            }
        }
    }

    public boolean isEditable() {
        return this.db.isSourceEditingEnabled();
    }

    public int getPosition(int line) {
        int result = -1;
        try {
            result = this.textArea.getLineStartOffset(line);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return result;
    }

    boolean isBreakPoint(int line) {
        return this.sourceInfo.hasBreakpoint(line);
    }

    void toggleBreakPoint(int line) {
        if (!this.isBreakPoint(line)) {
            this.setBreakPoint(line);
        } else {
            this.clearBreakPoint(line);
        }
    }

    void setBreakPoint(int line) {
        if (this.sourceInfo.placeBreakpoint(line)) {
            this.fileHeader.repaint();
        }
    }

    void clearBreakPoint(int line) {
        if (this.sourceInfo.removeBreakpoint(line)) {
            this.fileHeader.repaint();
        }
    }

    public Main getDB() {
        return this.db;
    }

    FileWindow(Main db, SourceInfo sourceInfo) {
        super(SourceInfo.getShortName(sourceInfo.getUrl()), true, true, true, true);
        this.db = db;
        this.sourceInfo = sourceInfo;
        this.updateToolTip();
        this.currentPos = -1;
        this.textArea = new FileTextArea(this);
        this.textArea.setRows(24);
        this.textArea.setColumns(80);
        this.p = new JScrollPane();
        this.fileHeader = new FileHeader(this);
        this.p.setViewportView(this.textArea);
        this.p.setRowHeaderView(this.fileHeader);
        this.setContentPane(this.p);
        this.pack();
        this.updateText();
        this.textArea.select(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent e) {
                FileWindow.this.getDB().removeScript(FileWindow.this.getUrl());
                FileWindow.this.getDB().officeScripts.deleteScript(FileWindow.this.getUrl());
            }
        });
    }

    private void updateToolTip() {
        Component c = this.getComponent(1);
        if (c != null && c instanceof JComponent) {
            ((JComponent)c).setToolTipText(this.getUrl());
        }
    }

    public String getUrl() {
        return this.sourceInfo.getUrl();
    }

    void updateText() {
        String newText = this.sourceInfo.getSource();
        if (!this.textArea.getText().equals(newText)) {
            this.textArea.getDocument().removeDocumentListener(this);
            this.textArea.setText(newText);
            this.isModified = false;
            this.textArea.getDocument().addDocumentListener(this);
            int pos = 0;
            if (this.currentPos != -1) {
                pos = this.currentPos;
            }
            this.textArea.select(pos);
        }
        this.fileHeader.update();
        this.fileHeader.repaint();
    }

    public void insertUpdate(DocumentEvent e) {
        this.doChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.doChanged(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.doChanged(e);
    }

    public void doChanged(DocumentEvent e) {
        this.isModified = true;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public String getText() {
        return this.textArea.getText();
    }

    void setPosition(int pos) {
        this.textArea.select(pos);
        this.currentPos = pos;
        this.fileHeader.repaint();
    }

    void select(int start, int end) {
        int docEnd = this.textArea.getDocument().getLength();
        this.textArea.select(docEnd, docEnd);
        this.textArea.select(start, end);
    }

    public void dispose() {
        this.db.removeWindow(this);
        super.dispose();
    }
}

