/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.generateproperties.request;

import java.util.List;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.refactoring.ast.adapters.IASTNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.INodeAdapter;
import org.python.pydev.refactoring.ast.adapters.PropertyTextAdapter;
import org.python.pydev.refactoring.codegenerator.generateproperties.request.SelectionState;
import org.python.pydev.refactoring.core.request.IRefactoringRequest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratePropertiesRequest
implements IRefactoringRequest {
    private IClassDefAdapter classAdapter;
    private INodeAdapter attributeAdapter;
    private SelectionState state = new SelectionState();
    private int offsetMethodStrategy;
    private int offsetPropertyStrategy;
    private int accessModifier;
    private String endLineDelim;

    public GeneratePropertiesRequest(IClassDefAdapter classAdapter, INodeAdapter attributeAdapter, List<PropertyTextAdapter> properties, int offsetMethodStrategy, int offsetPropertyStrategy, int accessModifier, String endLineDelim) {
        this.classAdapter = classAdapter;
        this.attributeAdapter = attributeAdapter;
        this.offsetMethodStrategy = offsetMethodStrategy;
        this.offsetPropertyStrategy = offsetPropertyStrategy;
        this.accessModifier = accessModifier;
        this.endLineDelim = endLineDelim;
        this.initialize(properties);
    }

    public IClassDefAdapter getClassAdapter() {
        return this.classAdapter;
    }

    private void initialize(List<PropertyTextAdapter> properties) {
        for (PropertyTextAdapter propertyAdapter : properties) {
            switch (propertyAdapter.getType()) {
                case 0: {
                    this.state.addSelection(1);
                    break;
                }
                case 1: {
                    this.state.addSelection(2);
                    break;
                }
                case 2: {
                    this.state.addSelection(4);
                    break;
                }
                case 3: {
                    this.state.addSelection(8);
                    break;
                }
            }
        }
    }

    public INodeAdapter getAttributeAdapter() {
        return this.attributeAdapter;
    }

    public String getAttributeName() {
        return this.getAttributeAdapter().getName();
    }

    public SelectionState getSelectionState() {
        return this.state;
    }

    @Override
    public IASTNodeAdapter<? extends SimpleNode> getOffsetNode() {
        return this.classAdapter;
    }

    public int getMethodOffsetStrategy() {
        return this.offsetMethodStrategy;
    }

    public int getPropertyOffsetStrategy() {
        return this.offsetPropertyStrategy;
    }

    public int getAccessModifier() {
        return this.accessModifier;
    }

    @Override
    public String getNewLineDelim() {
        return this.endLineDelim;
    }
}

