/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyoteOutputStream;
import org.apache.catalina.connector.CoyoteWriter;
import org.apache.catalina.connector.OutputBuffer;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.UEncoder;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.net.URL;

public class Response
implements HttpServletResponse {
    protected static final String info = "org.apache.coyote.tomcat5.CoyoteResponse/1.0";
    protected static StringManager sm;
    protected SimpleDateFormat format = null;
    protected Connector connector;
    protected org.apache.coyote.Response coyoteResponse;
    protected OutputBuffer outputBuffer;
    protected CoyoteOutputStream outputStream;
    protected CoyoteWriter writer;
    protected boolean appCommitted = false;
    protected boolean included = false;
    private boolean isCharacterEncodingSet = false;
    protected boolean error = false;
    protected ArrayList cookies = new ArrayList();
    protected boolean usingOutputStream = false;
    protected boolean usingWriter = false;
    protected UEncoder urlEncoder = new UEncoder();
    protected CharChunk redirectURLCC = new CharChunk();
    protected Request request = null;
    protected ResponseFacade facade = null;

    public Response() {
        this.urlEncoder.addSafeCharacter('/');
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
        this.outputBuffer = "AJP/1.3".equals(connector.getProtocol()) ? new OutputBuffer(8184) : new OutputBuffer();
        this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        this.writer = new CoyoteWriter(this.outputBuffer);
    }

    public void setCoyoteResponse(org.apache.coyote.Response coyoteResponse) {
        this.coyoteResponse = coyoteResponse;
        this.outputBuffer.setResponse(coyoteResponse);
    }

    public org.apache.coyote.Response getCoyoteResponse() {
        return this.coyoteResponse;
    }

    public Context getContext() {
        return this.request.getContext();
    }

    public void setContext(Context context) {
        this.request.setContext(context);
    }

    public void recycle() {
        this.outputBuffer.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.appCommitted = false;
        this.included = false;
        this.error = false;
        this.isCharacterEncodingSet = false;
        this.cookies.clear();
        if (Globals.IS_SECURITY_ENABLED || Connector.RECYCLE_FACADES) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.outputStream != null) {
                this.outputStream.clear();
                this.outputStream = null;
            }
            if (this.writer != null) {
                this.writer.clear();
                this.writer = null;
            }
        } else {
            this.writer.recycle();
        }
    }

    public void clearEncoders() {
        this.outputBuffer.clearEncoders();
    }

    public int getContentCount() {
        return this.outputBuffer.getContentWritten();
    }

    public long getContentCountLong() {
        return this.outputBuffer.getContentWrittenLong();
    }

    public void setAppCommitted(boolean appCommitted) {
        this.appCommitted = appCommitted;
    }

    public boolean isAppCommitted() {
        return this.appCommitted || this.isCommitted() || this.isSuspended() || this.getContentLength() > 0 && this.getContentCount() >= this.getContentLength();
    }

    public boolean getIncluded() {
        return this.included;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public String getInfo() {
        return info;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        if (this.facade == null) {
            this.facade = new ResponseFacade(this);
        }
        return this.facade;
    }

    public OutputStream getStream() {
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public void setStream(OutputStream stream) {
    }

    public void setSuspended(boolean suspended) {
        this.outputBuffer.setSuspended(suspended);
    }

    public boolean isSuspended() {
        return this.outputBuffer.isSuspended();
    }

    public boolean isClosed() {
        return this.outputBuffer.isClosed();
    }

    public void setError() {
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public void finishResponse() throws IOException {
        this.outputBuffer.close();
    }

    public int getContentLength() {
        return this.coyoteResponse.getContentLength();
    }

    public String getContentType() {
        return this.coyoteResponse.getContentType();
    }

    public PrintWriter getReporter() throws IOException {
        if (this.outputBuffer.isNew()) {
            this.outputBuffer.checkConverter();
            if (this.writer == null) {
                this.writer = new CoyoteWriter(this.outputBuffer);
            }
            return this.writer;
        }
        return null;
    }

    public void flushBuffer() throws IOException {
        this.outputBuffer.flush();
    }

    public int getBufferSize() {
        return this.outputBuffer.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.coyoteResponse.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException(sm.getString("coyoteResponse.getOutputStream.ise"));
        }
        this.usingOutputStream = true;
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public Locale getLocale() {
        return this.coyoteResponse.getLocale();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException(sm.getString("coyoteResponse.getWriter.ise"));
        }
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            this.setCharacterEncoding(this.getCharacterEncoding());
        }
        this.usingWriter = true;
        this.outputBuffer.checkConverter();
        if (this.writer == null) {
            this.writer = new CoyoteWriter(this.outputBuffer);
        }
        return this.writer;
    }

    public boolean isCommitted() {
        return this.coyoteResponse.isCommitted();
    }

    public void reset() {
        if (this.included) {
            return;
        }
        this.coyoteResponse.reset();
        this.outputBuffer.reset();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.isCharacterEncodingSet = false;
    }

    public void resetBuffer() {
        this.resetBuffer(false);
    }

    public void resetBuffer(boolean resetWriterStreamFlags) {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.resetBuffer.ise"));
        }
        this.outputBuffer.reset();
        if (resetWriterStreamFlags) {
            this.usingOutputStream = false;
            this.usingWriter = false;
            this.isCharacterEncodingSet = false;
        }
    }

    public void setBufferSize(int size) {
        if (this.isCommitted() || !this.outputBuffer.isNew()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.setBufferSize.ise"));
        }
        this.outputBuffer.setBufferSize(size);
    }

    public void setContentLength(int length) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.coyoteResponse.setContentLength(length);
    }

    public void setContentType(String type) {
        int index;
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter && type != null && (index = type.indexOf(";")) != -1) {
            type = type.substring(0, index);
        }
        this.coyoteResponse.setContentType(type);
        if (type != null && (index = type.indexOf(";")) != -1) {
            int len = type.length();
            ++index;
            while (index < len && Character.isSpace(type.charAt(index))) {
                ++index;
            }
            if (index + 7 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                this.isCharacterEncodingSet = true;
            }
        }
    }

    public void setCharacterEncoding(String charset) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.coyoteResponse.setCharacterEncoding(charset);
        this.isCharacterEncodingSet = true;
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setLocale(locale);
        if (this.usingWriter) {
            return;
        }
        if (this.isCharacterEncodingSet) {
            return;
        }
        CharsetMapper cm = this.getContext().getCharsetMapper();
        String charset = cm.getCharset(locale);
        if (charset != null) {
            this.coyoteResponse.setCharacterEncoding(charset);
        }
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public String getHeader(String name) {
        return this.coyoteResponse.getMimeHeaders().getHeader(name);
    }

    public String[] getHeaderNames() {
        MimeHeaders headers = this.coyoteResponse.getMimeHeaders();
        int n = headers.size();
        String[] result = new String[n];
        for (int i = 0; i < n; ++i) {
            result[i] = headers.getName(i).toString();
        }
        return result;
    }

    public String[] getHeaderValues(String name) {
        Enumeration enumeration = this.coyoteResponse.getMimeHeaders().values(name);
        Vector result = new Vector();
        while (enumeration.hasMoreElements()) {
            result.addElement(enumeration.nextElement());
        }
        Object[] resultArray = new String[result.size()];
        result.copyInto(resultArray);
        return resultArray;
    }

    public String getMessage() {
        return this.coyoteResponse.getMessage();
    }

    public int getStatus() {
        return this.coyoteResponse.getStatus();
    }

    public void reset(int status, String message) {
        this.reset();
        this.setStatus(status, message);
    }

    public void addCookie(Cookie cookie) {
        if (this.included) {
            return;
        }
        this.addCookieInternal(cookie);
    }

    public void addCookieInternal(Cookie cookie) {
        this.addCookieInternal(cookie, false);
    }

    public void addCookieInternal(final Cookie cookie, final boolean httpOnly) {
        if (this.isCommitted()) {
            return;
        }
        final StringBuffer sb = new StringBuffer();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServerCookie.appendCookieValue((StringBuffer)sb, (int)cookie.getVersion(), (String)cookie.getName(), (String)cookie.getValue(), (String)cookie.getPath(), (String)cookie.getDomain(), (String)cookie.getComment(), (int)cookie.getMaxAge(), (boolean)cookie.getSecure(), (boolean)httpOnly);
                    return null;
                }
            });
        } else {
            ServerCookie.appendCookieValue((StringBuffer)sb, (int)cookie.getVersion(), (String)cookie.getName(), (String)cookie.getValue(), (String)cookie.getPath(), (String)cookie.getDomain(), (String)cookie.getComment(), (int)cookie.getMaxAge(), (boolean)cookie.getSecure(), (boolean)httpOnly);
        }
        this.addHeader("Set-Cookie", sb.toString());
        this.cookies.add(cookie);
    }

    public void addDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.addHeader(name, FastHttpDateFormat.formatDate((long)value, (DateFormat)this.format));
    }

    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    public boolean containsHeader(String name) {
        char cc = name.charAt(0);
        if (cc == 'C' || cc == 'c') {
            if (name.equalsIgnoreCase("Content-Type")) {
                return this.coyoteResponse.getContentType() != null;
            }
            if (name.equalsIgnoreCase("Content-Length")) {
                return this.coyoteResponse.getContentLengthLong() != -1L;
            }
        }
        return this.coyoteResponse.containsHeader(name);
    }

    public String encodeRedirectURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            return this.toEncoded(url, this.request.getSessionInternal().getIdInternal());
        }
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        String absolute = this.toAbsolute(url);
        if (this.isEncodeable(absolute)) {
            if (url.equalsIgnoreCase("")) {
                url = absolute;
            }
            return this.toEncoded(url, this.request.getSessionInternal().getIdInternal());
        }
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void sendAcknowledgement() throws IOException {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.acknowledge();
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendError.ise"));
        }
        if (this.included) {
            return;
        }
        Wrapper wrapper = this.getRequest().getWrapper();
        if (wrapper != null) {
            wrapper.incrementErrorCount();
        }
        this.setError();
        this.coyoteResponse.setStatus(status);
        this.coyoteResponse.setMessage(message);
        this.resetBuffer();
        this.setSuspended(true);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendRedirect.ise"));
        }
        if (this.included) {
            return;
        }
        this.resetBuffer();
        try {
            String absolute = this.toAbsolute(location);
            this.setStatus(302);
            this.setHeader("Location", absolute);
        }
        catch (IllegalArgumentException e) {
            this.setStatus(404);
        }
        this.setSuspended(true);
    }

    public void setDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.setHeader(name, FastHttpDateFormat.formatDate((long)value, (DateFormat)this.format));
    }

    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    public void setStatus(int status) {
        this.setStatus(status, null);
    }

    public void setStatus(int status, String message) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setStatus(status);
        this.coyoteResponse.setMessage(message);
    }

    protected boolean isEncodeable(final String location) {
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        final Request hreq = this.request;
        final Session session = hreq.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        if (hreq.isRequestedSessionIdFromCookie()) {
            return false;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(Response.this.doIsEncodeable(hreq, session, location));
                }
            });
        }
        return this.doIsEncodeable(hreq, session, location);
    }

    private boolean doIsEncodeable(Request hreq, Session session, String location) {
        int urlPort;
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!hreq.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!hreq.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = hreq.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(hreq.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String contextPath = this.getContext().getPath();
        if (contextPath != null) {
            String file = url.getFile();
            if (file == null || !file.startsWith(contextPath)) {
                return false;
            }
            String tok = ";" + Globals.SESSION_PARAMETER_NAME + "=" + session.getIdInternal();
            if (file.indexOf(tok, contextPath.length()) >= 0) {
                return false;
            }
        }
        return true;
    }

    private String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (leadingSlash || !this.hasScheme(location)) {
            this.redirectURLCC.recycle();
            String scheme = this.request.getScheme();
            String name = this.request.getServerName();
            int port = this.request.getServerPort();
            try {
                this.redirectURLCC.append(scheme, 0, scheme.length());
                this.redirectURLCC.append("://", 0, 3);
                this.redirectURLCC.append(name, 0, name.length());
                if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                    this.redirectURLCC.append(':');
                    String portS = port + "";
                    this.redirectURLCC.append(portS, 0, portS.length());
                }
                if (!leadingSlash) {
                    String relativePath = this.request.getDecodedRequestURI();
                    int pos = relativePath.lastIndexOf(47);
                    relativePath = relativePath.substring(0, pos);
                    String encodedURI = null;
                    final String frelativePath = relativePath;
                    if (SecurityUtil.isPackageProtectionEnabled()) {
                        try {
                            encodedURI = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    return Response.this.urlEncoder.encodeURL(frelativePath);
                                }
                            });
                        }
                        catch (PrivilegedActionException pae) {
                            IllegalArgumentException iae = new IllegalArgumentException(location);
                            iae.initCause(pae.getException());
                            throw iae;
                        }
                    } else {
                        encodedURI = this.urlEncoder.encodeURL(relativePath);
                    }
                    this.redirectURLCC.append(encodedURI, 0, encodedURI.length());
                    this.redirectURLCC.append('/');
                }
                this.redirectURLCC.append(location, 0, location.length());
            }
            catch (IOException e) {
                IllegalArgumentException iae = new IllegalArgumentException(location);
                iae.initCause(e);
                throw iae;
            }
            return this.redirectURLCC.toString();
        }
        return location;
    }

    private boolean hasScheme(String uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return i > 0;
            }
            if (URL.isSchemeChar((char)c)) continue;
            return false;
        }
        return false;
    }

    protected String toEncoded(String url, String sessionId) {
        StringBuffer sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuffer(path)).length() > 0) {
            sb.append(";");
            sb.append(Globals.SESSION_PARAMETER_NAME);
            sb.append("=");
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    static {
        URL.isSchemeChar((char)'c');
        sm = StringManager.getManager("org.apache.catalina.connector");
    }
}

