/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.host;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.Lists;
import org.apache.webapp.admin.host.HostsForm;

public class DeleteHostAction
extends Action {
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        HostsForm hostsForm = new HostsForm();
        String select = request.getParameter("select");
        String domain = null;
        if (select != null) {
            String[] hosts = new String[]{select};
            hostsForm.setHosts(hosts);
            try {
                domain = new ObjectName(select).getDomain();
            }
            catch (Exception e) {
                throw new ServletException("Error extracting service name from the host to be deleted", (Throwable)e);
            }
        }
        String adminHost = null;
        try {
            adminHost = Lists.getAdminAppHost(this.mBServer, domain, request);
        }
        catch (Exception e) {
            String message = resources.getMessage(locale, "error.hostName.bad", (Object)adminHost);
            this.getServlet().log(message);
            response.sendError(400, message);
            return null;
        }
        request.setAttribute("adminAppHost", (Object)adminHost);
        request.setAttribute("hostsForm", (Object)hostsForm);
        ArrayList<String> list = new ArrayList<String>();
        try {
            String pattern = domain + ":type=Host" + ",*";
            Iterator<ObjectName> items = this.mBServer.queryNames(new ObjectName(pattern), null).iterator();
            while (items.hasNext()) {
                list.add(((Object)items.next()).toString());
            }
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.select"));
            response.sendError(500, resources.getMessage(locale, "users.error.select"));
            return null;
        }
        Collections.sort(list);
        request.setAttribute("hostsList", list);
        return mapping.findForward("Hosts");
    }
}

