#if !defined(__MSP430_HEADERS_USCI_H__)
#define __MSP430_HEADERS_USCI_H__

/* usci.h
 *
 * mspgcc project: MSP430 device headers
 * USCI module header
 *
 * (c) 2006 by Steve Underwood <steveu@coppice.org>
 * Originally based in part on work by Texas Instruments Inc.
 *
 * $Id: usci.h,v 1.7 2009/06/04 21:55:18 cliechti Exp $
 *
 * 2008-02-05 - modifications by G.Lemm <msp430@daqtix.com>
 * - added UC1IE and UC1IFG registers
 * - added UC*1*IE and UC*1*IFG bit definitions
 * 2009-05-19 - modifications by S. Balling <praktikum@innoventis.de>
 * - added switch for USCI0
 * 2009-11-17 - modifications by J.M.Gross <mspgcc@grossibaer.de>
 * - added complete support for USCI5_0..3 (MSP430F54xx family)
 * - removed old USI bit defines (belong to USI.H, not USCI.H)
 */

/* Switches:
__MSP430_HAS_USCI0__ - if device has USCI0 (NOT part of family 5)
__MSP430_HAS_USCI1__ - if device has USCI1 (NOT part of family 5)
__MSP430_HAS_USCI_A0__ - definition to show module is available
__MSP430_HAS_USCI_B0__ - definition to show module is available
__MSP430_USCI5_BASE_0__ - USCI module base address for A0/B0
__MSP430_HAS_USCI_A1__ - definition to show module is available
__MSP430_HAS_USCI_B1__ - definition to show module is available
__MSP430_USCI5_BASE_1__ - USCI module base address for A1/B1
__MSP430_HAS_USCI_A2__ - definition to show module is available
__MSP430_HAS_USCI_B2__ - definition to show module is available
__MSP430_USCI5_BASE_2__ - USCI module base address for A2/B2
__MSP430_HAS_USCI_A3__ - definition to show module is available
__MSP430_HAS_USCI_B3__ - definition to show module is available
__MSP430_USCI5_BASE_3__ - USCI module base address for A3/B3
*/

/* Common bits for USCI and USCI5 */

// Control register 0 bits (UCAxCTL0/UCBxCTL0)
#define UCPEN               (0x80)      /* Async. Mode: Parity enable */
#define UCCKPH              (0x80)      /* Sync. Mode: Clock Phase */
#define UCA10               (0x80)      /* I2C Mode: 10-bit Address Mode */
#define UCPAR               (0x40)      /* Async. Mode: Parity     0:odd / 1:even */
#define UCCKPL              (0x40)      /* Sync. Mode: Clock Polarity */
#define UCSLA10             (0x40)      /* I2C-Mode:10-bit Slave Address Mode */
#define UCMSB               (0x20)      /* Async./Sync. Mode: MSB first  0:LSB / 1:MSB */
#define UCMM                (0x20)      /* I2C Mode: Multi-Master Environment */
#define UC7BIT              (0x10)      /* Async. Mode: Data Bits  0:8-bits / 1:7-bits */
#define UCSPB               (0x08)      /* Async. Mode: Stop Bits  0:one / 1: two */
#define UCMST               (0x08)      /* Sync. Mode/ SPI Mode: Master Select */
#define UCMODE1             (0x04)      /* Async. Mode: USCI Mode 1 */
#define UCMODE0             (0x02)      /* Async. Mode: USCI Mode 0 */
#define UCSYNC              (0x01)      /* Sync-Mode  0:UART-Mode / 1:SPI-Mode */

#define UCMODE_0            (0<<1)      /* Sync. Mode: USCI Mode: 0 */
#define UCMODE_1            (1<<1)      /* Sync. Mode: USCI Mode: 1 */
#define UCMODE_2            (2<<1)      /* Sync. Mode: USCI Mode: 2 */
#define UCMODE_3            (3<<1)      /* Sync. Mode: USCI Mode: 3 */

// aliases by MSPGCC (ASYNC mode, UCSYNC=0)
#define UCMODE_UART         (0<<1)      /* normal Async mode */
#define UCMODE_IDLE         (1<<1)      /* Idle line multiprocessor mode  */
#define UCMODE_ADDRESS      (2<<1)      /* Address bit multiprocessor mode */
#define UCMODE_AUTOBAUD     (3<<1)      /* autobaud Async mode */
// aliases by MSPGCC (SYNC mode, UCSYNC=1)
#define UCMODE_SPI3         (0<<1)      /* 3-Pin SPI mode */
#define UCMODE_SPI4H        (1<<1)      /* 4-Pin SPI mode (STE active high)*/
#define UCMODE_SPI4L        (2<<1)      /* 4-Pin SPI mode (STE active low) */
#define UCMODE_I2C          (3<<1)      /* I2C mode */


// Control register 1 bits (UCAxCTL1/UCBxCTL1)
#define UCSSEL1             (0x80)      /* USCI 0 Clock Source Select 1 */
#define UCSSEL0             (0x40)      /* USCI 0 Clock Source Select 0 */
#define UCRXEIE             (0x20)      /* Async. Mode: RX Error interrupt enable */
#define UCBRKIE             (0x10)      /* Async. Mode: Break interrupt enable */
#define UCTR                (0x10)      /* I2C Mode: Transmit/Receive Select/Flag */
#define UCDORM              (0x08)      /* Async. Mode: Dormant (Sleep) Mode */
#define UCTXNACK            (0x08)      /* I2C Mode: Transmit NACK */
#define UCTXADDR            (0x04)      /* Async. Mode: Send next Data as Address */
#define UCTXSTP             (0x04)      /* I2C Mode: Transmit STOP */
#define UCTXBRK             (0x02)      /* Async. Mode: Send next Data as Break */
#define UCTXSTT             (0x02)      /* I2C Mode: Transmit START */
#define UCSWRST             (0x01)      /* USCI Software Reset */
// aliases by MSPGCC
#define UCSSEL_0            (0<<6)      /* USCI Clock Source: 0 */
#define UCSSEL_1            (1<<6)      /* USCI Clock Source: 1 */
#define UCSSEL_2            (2<<6)      /* USCI Clock Source: 2 */
#define UCSSEL_3            (3<<6)      /* USCI Clock Source: 3 */
#define UCSSEL_UCLKI        UCSSEL_0    /* not in SPI Mode */
#define UCSSEL_ACLK         UCSSEL_1
#define UCSSEL_SMCLK        UCSSEL_2


// UART modulation bits (UCAxMCTL)
#define UCBRF3              (0x80)      /* USCI First Stage Modulation Select 3 */
#define UCBRF2              (0x40)      /* USCI First Stage Modulation Select 2 */
#define UCBRF1              (0x20)      /* USCI First Stage Modulation Select 1 */
#define UCBRF0              (0x10)      /* USCI First Stage Modulation Select 0 */
#define UCBRS2              (0x08)      /* USCI Second Stage Modulation Select 2 */
#define UCBRS1              (0x04)      /* USCI Second Stage Modulation Select 1 */
#define UCBRS0              (0x02)      /* USCI Second Stage Modulation Select 0 */
#define UCOS16              (0x01)      /* USCI 16-times Oversampling enable */
// aliases by MSPGCC
#define UCBRF_0             (0x0<<4)    /* USCI First Stage Modulation: 0 */
#define UCBRF_1             (0x1<<4)    /* USCI First Stage Modulation: 1 */
#define UCBRF_2             (0x2<<4)    /* USCI First Stage Modulation: 2 */
#define UCBRF_3             (0x3<<4)    /* USCI First Stage Modulation: 3 */
#define UCBRF_4             (0x4<<4)    /* USCI First Stage Modulation: 4 */
#define UCBRF_5             (0x5<<4)    /* USCI First Stage Modulation: 5 */
#define UCBRF_6             (0x6<<4)    /* USCI First Stage Modulation: 6 */
#define UCBRF_7             (0x7<<4)    /* USCI First Stage Modulation: 7 */
#define UCBRF_8             (0x8<<4)    /* USCI First Stage Modulation: 8 */
#define UCBRF_9             (0x9<<4)    /* USCI First Stage Modulation: 9 */
#define UCBRF_10            (0xA<<4)    /* USCI First Stage Modulation: A */
#define UCBRF_11            (0xB<<4)    /* USCI First Stage Modulation: B */
#define UCBRF_12            (0xC<<4)    /* USCI First Stage Modulation: C */
#define UCBRF_13            (0xD<<4)    /* USCI First Stage Modulation: D */
#define UCBRF_14            (0xE<<4)    /* USCI First Stage Modulation: E */
#define UCBRF_15            (0xF<<4)    /* USCI First Stage Modulation: F */
#define UCBRS_0             (0<<1)      /* USCI Second Stage Modulation: 0 */
#define UCBRS_1             (1<<1)      /* USCI Second Stage Modulation: 1 */
#define UCBRS_2             (2<<1)      /* USCI Second Stage Modulation: 2 */
#define UCBRS_3             (3<<1)      /* USCI Second Stage Modulation: 3 */
#define UCBRS_4             (4<<1)      /* USCI Second Stage Modulation: 4 */
#define UCBRS_5             (5<<1)      /* USCI Second Stage Modulation: 5 */
#define UCBRS_6             (6<<1)      /* USCI Second Stage Modulation: 6 */
#define UCBRS_7             (7<<1)      /* USCI Second Stage Modulation: 7 */

// UART status register bits (UCAxSTAT/UCBxSTAT)
#define UCLISTEN            (0x80)      /* Async./SPI Mode: Listen (loopback) */
#define UCFE                (0x40)      /* Async./SPI Mode: Frame Error Flag */
#define UCSCLLOW            (0x40)      /* I2C Mode: SCL low */
#define UCOE                (0x20)      /* Async./SPI Mode: USCI Overrun Error Flag */
#define UCGC                (0x20)      /* I2C Mode: general call address received */
#define UCPE                (0x10)      /* Async. Mode: Parity Error Flag */
#define UCBBUSY             (0x10)      /* I2C Mode: Bus busy */
#define UCBRK               (0x08)      /* Async. Mode: Break received */
#define UCRXERR             (0x04)      /* Async. Mode: RX Error Flag */
#define UCADDR              (0x02)      /* Async. Mode: Address received Flag (address bit multiprocessor mode)*/
#define UCIDLE              (0x02)      /* Async. Mode: Idle line detected Flag (idle line multiprocessor mode)*/
#define UCBUSY              (0x01)      /* USCI Busy Flag */

// IrDA transmit control register bits (UCAxIRTCTL)
#define UCIRTXPL5           (0x80)      /* IRDA Transmit Pulse Length 5 */
#define UCIRTXPL4           (0x40)      /* IRDA Transmit Pulse Length 4 */
#define UCIRTXPL3           (0x20)      /* IRDA Transmit Pulse Length 3 */
#define UCIRTXPL2           (0x10)      /* IRDA Transmit Pulse Length 2 */
#define UCIRTXPL1           (0x08)      /* IRDA Transmit Pulse Length 1 */
#define UCIRTXPL0           (0x04)      /* IRDA Transmit Pulse Length 0 */
#define UCIRTXCLK           (0x02)      /* IRDA Transmit Pulse Clock Select */
#define UCIREN              (0x01)      /* IRDA Encoder/Decoder enable */

// IrDA receive control register bits (UCAxIRRCTL)
#define UCIRRXFL5           (0x80)      /* IRDA Receive Filter Length 5 */
#define UCIRRXFL4           (0x40)      /* IRDA Receive Filter Length 4 */
#define UCIRRXFL3           (0x20)      /* IRDA Receive Filter Length 3 */
#define UCIRRXFL2           (0x10)      /* IRDA Receive Filter Length 2 */
#define UCIRRXFL1           (0x08)      /* IRDA Receive Filter Length 1 */
#define UCIRRXFL0           (0x04)      /* IRDA Receive Filter Length 0 */
#define UCIRRXPL            (0x02)      /* IRDA Receive Input Polarity */
#define UCIRRXFE            (0x01)      /* IRDA Receive Filter enable */

// Auto baud rate register bits (UCAxABCTL)
#define UCDELIM1            (0x20)      /* Break Sync Delimiter 1 */
#define UCDELIM0            (0x10)      /* Break Sync Delimiter 0 */
#define UCSTOE              (0x08)      /* Sync-Field Timeout error */
#define UCBTOE              (0x04)      /* Break Timeout error */
#define UCABDEN             (0x01)      /* Auto Baud Rate detect enable */
// aliases by MSPGCC
#define UCDELIM_1           (0<<4)      /* Break/synch delimiter = 1 bit time */
#define UCDELIM_2           (1<<4)      /* Break/synch delimiter = 2 bit times */
#define UCDELIM_3           (2<<4)      /* Break/synch delimiter = 3 bit times */
#define UCDELIM_4           (3<<4)      /* Break/synch delimiter = 4 bit times */

// I2C own address register (UCBxI2COA)
#define UCGCEN              (0x8000)    /* I2C General Call Response enable */


// Interrupt enable register bits (UCyxIE)
#if defined(__MSP430_HAS_USCI0__) || defined(__MSP430_HAS_USCI1__)              // bits different for USCI and USCI5 (USCI not checked!)
#define UCNACKIE            (0x08)      /* NACK Condition interrupt enable */
#define UCSTPIE             (0x04)      /* STOP Condition interrupt enable */
#define UCSTTIE             (0x02)      /* START Condition interrupt enable */
#define UCALIE              (0x01)      /* Arbitration Lost interrupt enable */
#else
#define UCNACKIE            (0x20)      /* NACK Condition interrupt enable */
#define UCALIE              (0x10)      /* Arbitration Lost interrupt enable */
#define UCSTPIE             (0x08)      /* STOP Condition interrupt enable */
#define UCSTTIE             (0x04)      /* START Condition interrupt enable */
#define UCTXIE              (0x02)      /* transmit interrupt enable */
#define UCRXIE              (0x01)      /* receive  interrupt enable */
#endif

// Interrupt flag register bits (UCyxIFG)
#if defined(__MSP430_HAS_USCI0__) || defined(__MSP430_HAS_USCI1__)              // bits different for USCI and USCI5 (USCI not checked!)
#define UCNACKIFG           (0x08)      /* NAK Condition interrupt Flag */
#define UCSTPIFG            (0x04)      /* STOP Condition interrupt Flag */
#define UCSTTIFG            (0x02)      /* START Condition interrupt Flag */
#define UCALIFG             (0x01)      /* Arbitration Lost interrupt Flag */
#else
#define UCNACKIFG           (0x20)      /* NAK Condition interrupt Flag */
#define UCALIFG             (0x10)      /* Arbitration Lost interrupt Flag */
#define UCSTPIFG            (0x08)      /* STOP Condition interrupt Flag */
#define UCSTTIFG            (0x04)      /* START Condition interrupt Flag */
#define UCTXIFG             (0x02)      /* transmit interrupt flag (set when UCxxTXBUF empty) */
#define UCRXIFG             (0x01)      /* receive  interrupt flag (set when UCxxRXBUF has received a char) */
#endif


#if defined(__MSP430_HAS_USCI0__)

/* -------- USCI0 */

#define UCA0CTL0_           0x0060      /* USCI A0 Control Register 0 */
sfrb(UCA0CTL0, UCA0CTL0_);
#define UCA0CTL1_           0x0061      /* USCI A0 Control Register 1 */
sfrb(UCA0CTL1, UCA0CTL1_);
#define UCA0BR0_            0x0062      /* USCI A0 Baud Rate 0 */
sfrb(UCA0BR0, UCA0BR0_);
#define UCA0BR1_            0x0063      /* USCI A0 Baud Rate 1 */
sfrb(UCA0BR1, UCA0BR1_);
#define UCA0MCTL_           0x0064      /* USCI A0 Modulation Control */
sfrb(UCA0MCTL, UCA0MCTL_);
#define UCA0STAT_           0x0065      /* USCI A0 Status Register */
sfrb(UCA0STAT, UCA0STAT_);
#define UCA0RXBUF_          0x0066      /* USCI A0 Receive Buffer */
/*READ_ONLY*/ sfrb(UCA0RXBUF, UCA0RXBUF_);
#define UCA0TXBUF_          0x0067      /* USCI A0 Transmit Buffer */
sfrb(UCA0TXBUF, UCA0TXBUF_);
#define UCA0ABCTL_          0x005D      /* USCI A0 Auto baud/LIN Control */
sfrb(UCA0ABCTL, UCA0ABCTL_);
#define UCA0IRTCTL_         0x005E      /* USCI A0 IrDA Transmit Control */
sfrb(UCA0IRTCTL, UCA0IRTCTL_);
#define UCA0IRRCTL_         0x005F      /* USCI A0 IrDA Receive Control */
sfrb(UCA0IRRCTL, UCA0IRRCTL_);

#define UCB0CTL0_           0x0068      /* USCI B0 Control Register 0 */
sfrb(UCB0CTL0, UCB0CTL0_);
#define UCB0CTL1_           0x0069      /* USCI B0 Control Register 1 */
sfrb(UCB0CTL1, UCB0CTL1_);
#define UCB0BR0_            0x006A      /* USCI B0 Baud Rate 0 */
sfrb(UCB0BR0, UCB0BR0_);
#define UCB0BR1_            0x006B      /* USCI B0 Baud Rate 1 */
sfrb(UCB0BR1, UCB0BR1_);
#define UCB0I2CIE_          0x006C      /* USCI B0 I2C Interrupt Enable Register */
sfrb(UCB0I2CIE, UCB0I2CIE_);
#define UCB0STAT_           0x006D      /* USCI B0 Status Register */
sfrb(UCB0STAT, UCB0STAT_);
#define UCB0RXBUF_          0x006E      /* USCI B0 Receive Buffer */
/*READ_ONLY*/ sfrb(UCB0RXBUF, UCB0RXBUF_);
#define UCB0TXBUF_          0x006F      /* USCI B0 Transmit Buffer */
sfrb(UCB0TXBUF, UCB0TXBUF_);
#define UCB0I2COA_          0x0118      /* USCI B0 I2C Own Address */
sfrw(UCB0I2COA, UCB0I2COA_);
#define UCB0I2CSA_          0x011A      /* USCI B0 I2C Slave Address */
sfrw(UCB0I2CSA, UCB0I2CSA_);

#define UCA0RXIE            (1<<0)
#define UCA0TXIE            (1<<1)
#define UCB0RXIE            (1<<2)
#define UCB0TXIE            (1<<3)

#define UCA0RXIFG           (1<<0)
#define UCA0TXIFG           (1<<1)
#define UCB0RXIFG           (1<<2)
#define UCB0TXIFG           (1<<3)
#endif /* __MSP430_HAS_USCI0__ */

#if defined(__MSP430_HAS_USCI1__)

/* -------- USCI1 */

#define UCA1CTL0_           0x00D0      /* USCI A1 Control Register 0 */
sfrb(UCA1CTL0, UCA1CTL0_);
#define UCA1CTL1_           0x00D1      /* USCI A1 Control Register 1 */
sfrb(UCA1CTL1, UCA1CTL1_);
#define UCA1BR0_            0x00D2      /* USCI A1 Baud Rate 0 */
sfrb(UCA1BR0, UCA1BR0_);
#define UCA1BR1_            0x00D3      /* USCI A1 Baud Rate 1 */
sfrb(UCA1BR1, UCA1BR1_);
#define UCA1MCTL_           0x00D4      /* USCI A1 Modulation Control */
sfrb(UCA1MCTL, UCA1MCTL_);
#define UCA1STAT_           0x00D5      /* USCI A1 Status Register */
sfrb(UCA1STAT, UCA1STAT_);
#define UCA1RXBUF_          0x00D6      /* USCI A1 Receive Buffer */
/*READ_ONLY*/ sfrb(UCA1RXBUF, UCA1RXBUF_);
#define UCA1TXBUF_          0x00D7      /* USCI A1 Transmit Buffer */
sfrb(UCA1TXBUF, UCA1TXBUF_);
#define UCA1ABCTL_          0x00CD      /* USCI A1 Auto baud/LIN Control */
sfrb(UCA1ABCTL, UCA1ABCTL_);
#define UCA1IRTCTL_         0x00CE      /* USCI A1 IrDA Transmit Control */
sfrb(UCA1IRTCTL, UCA1IRTCTL_);
#define UCA1IRRCTL_         0x00CF      /* USCI A1 IrDA Receive Control */
sfrb(UCA1IRRCTL, UCA1IRRCTL_);

#define UCB1CTL0_           0x00D8      /* USCI B1 Control Register 0 */
sfrb(UCB1CTL0, UCB1CTL0_);
#define UCB1CTL1_           0x00D9      /* USCI B1 Control Register 1 */
sfrb(UCB1CTL1, UCB1CTL1_);
#define UCB1BR0_            0x00DA      /* USCI B1 Baud Rate 0 */
sfrb(UCB1BR0, UCB1BR0_);
#define UCB1BR1_            0x00DB      /* USCI B1 Baud Rate 1 */
sfrb(UCB1BR1, UCB1BR1_);
#define UCB1I2CIE_          0x00DC      /* USCI B1 I2C Interrupt Enable Register */
sfrb(UCB1I2CIE, UCB1I2CIE_);
#define UCB1STAT_           0x00DD      /* USCI B1 Status Register */
sfrb(UCB1STAT, UCB1STAT_);
#define UCB1RXBUF_          0x00DE      /* USCI B1 Receive Buffer */
/*READ_ONLY*/ sfrb(UCB1RXBUF, UCB1RXBUF_);
#define UCB1TXBUF_          0x00DF      /* USCI B1 Transmit Buffer */
sfrb(UCB1TXBUF, UCB1TXBUF_);
#define UCB1I2COA_          0x017C      /* USCI B1 I2C Own Address */
sfrw(UCB1I2COA, UCB1I2COA_);
#define UCB1I2CSA_          0x017E      /* USCI B1 I2C Slave Address */
sfrw(UCB1I2CSA, UCB1I2CSA_);

#define UC1IE_              0x0006      /* USCI A1/B1 Interrupt enable register */
sfrb(UC1IE, UC1IE_);
#define UC1IFG_             0x0007      /* USCI A1/B1 Interrupt flag register */
sfrb(UC1IFG, UC1IFG_);

#define UCA1RXIE            (1<<0)
#define UCA1TXIE            (1<<1)
#define UCB1RXIE            (1<<2)
#define UCB1TXIE            (1<<3)

#define UCA1RXIFG           (1<<0)
#define UCA1TXIFG           (1<<1)
#define UCB1RXIFG           (1<<2)
#define UCB1TXIFG           (1<<3)
#endif /* __MSP430_HAS_USCI1__ */

/******************************************************************************
      USCI0 on MSP430F54xx
 ******************************************************************************/

#if defined(__MSP430_USCI5_BASE_0__)

#define UCA0CTL0_           __MSP430_USCI5_BASE_0__ + 0x01                       // USCI control 0 (sic)
sfrb(UCA0CTL0, UCA0CTL0_);
#define UCA0CTL1_           __MSP430_USCI5_BASE_0__ + 0x00                       // USCI control 1 (sic)
sfrb(UCA0CTL1, UCA0CTL1_);
#define UCA0BRW_            __MSP430_USCI5_BASE_0__ + 0x06                       // USCI baud rate word
sfrw(UCA0BRW, UCA0BRW_);
#define UCA0BR0_            __MSP430_USCI5_BASE_0__ + 0x06                       // USCI baud rate 0
sfrb(UCA0BR0, UCA0BR0_);
#define UCA0BR1_            __MSP430_USCI5_BASE_0__ + 0x07                       // USCI baud rate 1
sfrb(UCA0BR1, UCA0BR1_);
#define UCA0MCTL_           __MSP430_USCI5_BASE_0__ + 0x08                       // USCI modulation control
sfrb(UCA0MCTL, UCA0MCTL_);
#define UCA0STAT_           __MSP430_USCI5_BASE_0__ + 0x0A                       // USCI status
sfrb(UCA0STAT, UCA0STAT_);
#define UCA0RXBUF_          __MSP430_USCI5_BASE_0__ + 0x0C                       // USCI receive buffer
sfrb(UCA0RXBUF, UCA0RXBUF_);
#define UCA0TXBUF_          __MSP430_USCI5_BASE_0__ + 0x0E                       // USCI transmit buffer
sfrb(UCA0TXBUF, UCA0TXBUF_);
#define UCA0ABCTL_          __MSP430_USCI5_BASE_0__ + 0x10                       // USCI LIN control
sfrb(UCA0ABCTL, UCA0ABCTL_);
#define UCA0IRTCTL_         __MSP430_USCI5_BASE_0__ + 0x12                       // USCI IrDA transmit control
sfrb(UCA0IRTCTL, UCA0IRTCTL_);
#define UCA0IRRCTL_         __MSP430_USCI5_BASE_0__ + 0x13                       // USCI IrDA receive control
sfrb(UCA0IRRCTL, UCA0IRRCTL_);
#define UCA0IE_             __MSP430_USCI5_BASE_0__ + 0x1C                       // USCI interrupt enable
sfrb(UCA0IE, UCA0IE_);
#define UCA0IFG_            __MSP430_USCI5_BASE_0__ + 0x1D                       // USCI interrupt flags
sfrb(UCA0IFG, UCA0IFG_);
#define UCA0IV_             __MSP430_USCI5_BASE_0__ + 0x1E                       // USCI interrupt vector word
sfrw(UCA0IV, UCA0IV_);
#define UCA0IV_L_           __MSP430_USCI5_BASE_0__ + 0x1E
sfrb(UCA0IV_L, UCA0IV_L_);
#define UCA0IV_H_           __MSP430_USCI5_BASE_0__ + 0x1F
sfrb(UCA0IV_H, UCA0IV_H_);

#define UCB0CTL0_           __MSP430_USCI5_BASE_0__ + 0x21                       // USCI synchronous control 0
sfrb(UCB0CTL0, UCB0CTL0_);
#define UCB0CTL1_           __MSP430_USCI5_BASE_0__ + 0x20                       // USCI synchronous control 1
sfrb(UCB0CTL1, UCB0CTL1_);
#define UCB0BR0_            __MSP430_USCI5_BASE_0__ + 0x26                       // USCI synchronous bit rate 0
sfrb(UCB0BR0, UCB0BR0_);
#define UCB0BR1_            __MSP430_USCI5_BASE_0__ + 0x27                       // USCI synchronous bit rate 1
sfrb(UCB0BR1, UCB0BR1_);
#define UCB0MCTL_           __MSP430_USCI5_BASE_0__ + 0x28                       // USCI I2C interrupt enable
sfrb(UCB0MCTL, UCB0MCTL_);
#define UCB0STAT_           __MSP430_USCI5_BASE_0__ + 0x2A                       // USCI synchronous status
sfrb(UCB0STAT, UCB0STAT_);
#define UCB0RXBUF_          __MSP430_USCI5_BASE_0__ + 0x2C                       // USCI synchronous receive buffer
sfrb(UCB0RXBUF, UCB0RXBUF_);
#define UCB0TXBUF_          __MSP430_USCI5_BASE_0__ + 0x2E                       // USCI synchronous transmit buffer
sfrb(UCB0TXBUF, UCB0TXBUF_);
#define UCB0I2COA_          __MSP430_USCI5_BASE_0__ + 0x30                       // USCI I2C own address
sfrb(UCB0I2COA, UCB0I2COA_);
#define UCB0I2CSA_          __MSP430_USCI5_BASE_0__ + 0x32                       // USCI I2C slave address
sfrb(UCB0I2CSA, UCB0I2CSA_);
#define UCB0IE_             __MSP430_USCI5_BASE_0__ + 0x3C                       // USCI interrupt enable
sfrb(UCB0IE, UCB0IE_);
#define UCB0IFG_            __MSP430_USCI5_BASE_0__ + 0x3D                       // USCI interrupt flags
sfrb(UCB0IFG, UCB0IFG_);
#define UCB0IV_             __MSP430_USCI5_BASE_0__ + 0x3E                       // USCI interrupt vector word
sfrw(UCB0IV, UCB0IV_);
#define UCB0IV_L_           __MSP430_USCI5_BASE_0__ + 0x3E
sfrb(UCB0IV_L, UCB0IV_L_);
#define UCB0IV_H_           __MSP430_USCI5_BASE_0__ + 0x3F
sfrb(UCB0IV_H, UCB0IV_H_);

#endif /* __MSP430_USCI5_BASE_0__ */

/******************************************************************************
      USCI1 on MSP430F54xx
 ******************************************************************************/

#if defined(__MSP430_USCI5_BASE_1__)

#define UCA1CTL0_           __MSP430_USCI5_BASE_1__ + 0x01                       // USCI control 0 (sic)
sfrb(UCA1CTL0, UCA1CTL0_);
#define UCA1CTL1_           __MSP430_USCI5_BASE_1__ + 0x00                       // USCI control 1 (sic)
sfrb(UCA1CTL1, UCA1CTL1_);
#define UCA1BRW_            __MSP430_USCI5_BASE_1__ + 0x06                       // USCI baud rate word
sfrw(UCA1BRW, UCA1BRW_);
#define UCA1BR0_            __MSP430_USCI5_BASE_1__ + 0x06                       // USCI baud rate 0
sfrb(UCA1BR0, UCA1BR0_);
#define UCA1BR1_            __MSP430_USCI5_BASE_1__ + 0x07                       // USCI baud rate 1
sfrb(UCA1BR1, UCA1BR1_);
#define UCA1MCTL_           __MSP430_USCI5_BASE_1__ + 0x08                       // USCI modulation control
sfrb(UCA1MCTL, UCA1MCTL_);
#define UCA1STAT_           __MSP430_USCI5_BASE_1__ + 0x0A                       // USCI status
sfrb(UCA1STAT, UCA1STAT_);
#define UCA1RXBUF_          __MSP430_USCI5_BASE_1__ + 0x0C                       // USCI receive buffer
sfrb(UCA1RXBUF, UCA1RXBUF_);
#define UCA1TXBUF_          __MSP430_USCI5_BASE_1__ + 0x0E                       // USCI transmit buffer
sfrb(UCA1TXBUF, UCA1TXBUF_);
#define UCA1ABCTL_          __MSP430_USCI5_BASE_1__ + 0x10                       // USCI LIN control
sfrb(UCA1ABCTL, UCA1ABCTL_);
#define UCA1IRTCTL_         __MSP430_USCI5_BASE_1__ + 0x12                       // USCI IrDA transmit control
sfrb(UCA1IRTCTL, UCA1IRTCTL_);
#define UCA1IRRCTL_         __MSP430_USCI5_BASE_1__ + 0x13                       // USCI IrDA receive control
sfrb(UCA1IRRCTL, UCA1IRRCTL_);
#define UCA1IE_             __MSP430_USCI5_BASE_1__ + 0x1C                       // USCI interrupt enable
sfrb(UCA1IE, UCA1IE_);
#define UCA1IFG_            __MSP430_USCI5_BASE_1__ + 0x1D                       // USCI interrupt flags
sfrb(UCA1IFG, UCA1IFG_);
#define UCA1IV_             __MSP430_USCI5_BASE_1__ + 0x1E                       // USCI interrupt vector word
sfrw(UCA1IV, UCA1IV_);
#define UCA1IV_L_           __MSP430_USCI5_BASE_1__ + 0x1E
sfrb(UCA1IV_L, UCA1IV_L_);
#define UCA1IV_H_           __MSP430_USCI5_BASE_1__ + 0x1F
sfrb(UCA1IV_H, UCA1IV_H_);

#define UCB1CTL0_           __MSP430_USCI5_BASE_1__ + 0x21                       // USCI synchronous control 0
sfrb(UCB1CTL0, UCB1CTL0_);
#define UCB1CTL1_           __MSP430_USCI5_BASE_1__ + 0x20                       // USCI synchronous control 1
sfrb(UCB1CTL1, UCB1CTL1_);
#define UCB1BR0_            __MSP430_USCI5_BASE_1__ + 0x26                       // USCI synchronous bit rate 0
sfrb(UCB1BR0, UCB1BR0_);
#define UCB1BR1_            __MSP430_USCI5_BASE_1__ + 0x27                       // USCI synchronous bit rate 1
sfrb(UCB1BR1, UCB1BR1_);
#define UCB1MCTL_           __MSP430_USCI5_BASE_1__ + 0x28                       // USCI I2C interrupt enable
sfrb(UCB1MCTL, UCB1MCTL_);
#define UCB1STAT_           __MSP430_USCI5_BASE_1__ + 0x2A                       // USCI synchronous status
sfrb(UCB1STAT, UCB1STAT_);
#define UCB1RXBUF_          __MSP430_USCI5_BASE_1__ + 0x2C                       // USCI synchronous receive buffer
sfrb(UCB1RXBUF, UCB1RXBUF_);
#define UCB1TXBUF_          __MSP430_USCI5_BASE_1__ + 0x2E                       // USCI synchronous transmit buffer
sfrb(UCB1TXBUF, UCB1TXBUF_);
#define UCB1I2COA_          __MSP430_USCI5_BASE_1__ + 0x30                       // USCI I2C own address
sfrb(UCB1I2COA, UCB1I2COA_);
#define UCB1I2CSA_          __MSP430_USCI5_BASE_1__ + 0x32                       // USCI I2C slave address
sfrb(UCB1I2CSA, UCB1I2CSA_);
#define UCB1IE_             __MSP430_USCI5_BASE_1__ + 0x3C                       // USCI interrupt enable
sfrb(UCB1IE, UCB1IE_);
#define UCB1IFG_            __MSP430_USCI5_BASE_1__ + 0x3D                       // USCI interrupt flags
sfrb(UCB1IFG, UCB1IFG_);
#define UCB1IV_             __MSP430_USCI5_BASE_1__ + 0x3E                       // USCI interrupt vector word
sfrw(UCB1IV, UCB1IV_);
#define UCB1IV_L_           __MSP430_USCI5_BASE_1__ + 0x3E
sfrb(UCB1IV_L, UCB1IV_L_);
#define UCB1IV_H_           __MSP430_USCI5_BASE_1__ + 0x3F
sfrb(UCB1IV_H, UCB1IV_H_);

#endif /* __MSP430_USCI5_BASE_1__ */

/******************************************************************************
      USCI2 on MSP430F54xx
 ******************************************************************************/

#if defined(__MSP430_USCI5_BASE_2__)

#define UCA2CTL0_           __MSP430_USCI5_BASE_2__ + 0x01                       // USCI control 0 (sic)
sfrb(UCA2CTL0, UCA2CTL0_);
#define UCA2CTL1_           __MSP430_USCI5_BASE_2__ + 0x00                       // USCI control 1 (sic)
sfrb(UCA2CTL1, UCA2CTL1_);
#define UCA2BRW_            __MSP430_USCI5_BASE_2__ + 0x06                       // USCI baud rate word
sfrw(UCA2BRW, UCA2BRW_);
#define UCA2BR0_            __MSP430_USCI5_BASE_2__ + 0x06                       // USCI baud rate 0
sfrb(UCA2BR0, UCA2BR0_);
#define UCA2BR1_            __MSP430_USCI5_BASE_2__ + 0x07                       // USCI baud rate 1
sfrb(UCA2BR1, UCA2BR1_);
#define UCA2MCTL_           __MSP430_USCI5_BASE_2__ + 0x08                       // USCI modulation control
sfrb(UCA2MCTL, UCA2MCTL_);
#define UCA2STAT_           __MSP430_USCI5_BASE_2__ + 0x0A                       // USCI status
sfrb(UCA2STAT, UCA2STAT_);
#define UCA2RXBUF_          __MSP430_USCI5_BASE_2__ + 0x0C                       // USCI receive buffer
sfrb(UCA2RXBUF, UCA2RXBUF_);
#define UCA2TXBUF_          __MSP430_USCI5_BASE_2__ + 0x0E                       // USCI transmit buffer
sfrb(UCA2TXBUF, UCA2TXBUF_);
#define UCA2ABCTL_          __MSP430_USCI5_BASE_2__ + 0x10                       // USCI LIN control
sfrb(UCA2ABCTL, UCA2ABCTL_);
#define UCA2IRTCTL_         __MSP430_USCI5_BASE_2__ + 0x12                       // USCI IrDA transmit control
sfrb(UCA2IRTCTL, UCA2IRTCTL_);
#define UCA2IRRCTL_         __MSP430_USCI5_BASE_2__ + 0x13                       // USCI IrDA receive control
sfrb(UCA2IRRCTL, UCA2IRRCTL_);
#define UCA2IE_             __MSP430_USCI5_BASE_2__ + 0x1C                       // USCI interrupt enable
sfrb(UCA2IE, UCA2IE_);
#define UCA2IFG_            __MSP430_USCI5_BASE_2__ + 0x1D                       // USCI interrupt flags
sfrb(UCA2IFG, UCA2IFG_);
#define UCA2IV_             __MSP430_USCI5_BASE_2__ + 0x1E                       // USCI interrupt vector word
sfrw(UCA2IV, UCA2IV_);
#define UCA2IV_L_           __MSP430_USCI5_BASE_2__ + 0x1E
sfrb(UCA2IV_L, UCA2IV_L_);
#define UCA2IV_H_           __MSP430_USCI5_BASE_2__ + 0x1F
sfrb(UCA2IV_H, UCA2IV_H_);

#define UCB2CTL0_           __MSP430_USCI5_BASE_2__ + 0x21                       // USCI synchronous control 0
sfrb(UCB2CTL0, UCB2CTL0_);
#define UCB2CTL1_           __MSP430_USCI5_BASE_2__ + 0x20                       // USCI synchronous control 1
sfrb(UCB2CTL1, UCB2CTL1_);
#define UCB2BR0_            __MSP430_USCI5_BASE_2__ + 0x26                       // USCI synchronous bit rate 0
sfrb(UCB2BR0, UCB2BR0_);
#define UCB2BR1_            __MSP430_USCI5_BASE_2__ + 0x27                       // USCI synchronous bit rate 1
sfrb(UCB2BR1, UCB2BR1_);
#define UCB2MCTL_           __MSP430_USCI5_BASE_2__ + 0x28                       // USCI I2C interrupt enable
sfrb(UCB2MCTL, UCB2MCTL_);
#define UCB2STAT_           __MSP430_USCI5_BASE_2__ + 0x2A                       // USCI synchronous status
sfrb(UCB2STAT, UCB2STAT_);
#define UCB2RXBUF_          __MSP430_USCI5_BASE_2__ + 0x2C                       // USCI synchronous receive buffer
sfrb(UCB2RXBUF, UCB2RXBUF_);
#define UCB2TXBUF_          __MSP430_USCI5_BASE_2__ + 0x2E                       // USCI synchronous transmit buffer
sfrb(UCB2TXBUF, UCB2TXBUF_);
#define UCB2I2COA_          __MSP430_USCI5_BASE_2__ + 0x30                       // USCI I2C own address
sfrb(UCB2I2COA, UCB2I2COA_);
#define UCB2I2CSA_          __MSP430_USCI5_BASE_2__ + 0x32                       // USCI I2C slave address
sfrb(UCB2I2CSA, UCB2I2CSA_);
#define UCB2IE_             __MSP430_USCI5_BASE_2__ + 0x3C                       // USCI interrupt enable
sfrb(UCB2IE, UCB2IE_);
#define UCB2IFG_            __MSP430_USCI5_BASE_2__ + 0x3D                       // USCI interrupt flags
sfrb(UCB2IFG, UCB2IFG_);
#define UCB2IV_             __MSP430_USCI5_BASE_2__ + 0x3E                       // USCI interrupt vector word
sfrw(UCB2IV, UCB2IV_);
#define UCB2IV_L_           __MSP430_USCI5_BASE_2__ + 0x3E
sfrb(UCB2IV_L, UCB2IV_L_);
#define UCB2IV_H_           __MSP430_USCI5_BASE_2__ + 0x3F
sfrb(UCB2IV_H, UCB2IV_H_);

#endif /* __MSP430_USCI5_BASE_2__ */

/******************************************************************************
      USCI3 on MSP430F54xx
 ******************************************************************************/

#if defined(__MSP430_USCI5_BASE_3__)

#define UCA3CTL0_           __MSP430_USCI5_BASE_3__ + 0x01                       // USCI control 0 (sic)
sfrb(UCA3CTL0, UCA3CTL0_);
#define UCA3CTL1_           __MSP430_USCI5_BASE_3__ + 0x00                       // USCI control 1 (sic)
sfrb(UCA3CTL1, UCA3CTL1_);
#define UCA3BRW_            __MSP430_USCI5_BASE_3__ + 0x06                       // USCI baud rate word
sfrw(UCA3BRW, UCA3BRW_);
#define UCA3BR0_            __MSP430_USCI5_BASE_3__ + 0x06                       // USCI baud rate 0
sfrb(UCA3BR0, UCA3BR0_);
#define UCA3BR1_            __MSP430_USCI5_BASE_3__ + 0x07                       // USCI baud rate 1
sfrb(UCA3BR1, UCA3BR1_);
#define UCA3MCTL_           __MSP430_USCI5_BASE_3__ + 0x08                       // USCI modulation control
sfrb(UCA3MCTL, UCA3MCTL_);
#define UCA3STAT_           __MSP430_USCI5_BASE_3__ + 0x0A                       // USCI status
sfrb(UCA3STAT, UCA3STAT_);
#define UCA3RXBUF_          __MSP430_USCI5_BASE_3__ + 0x0C                       // USCI receive buffer
sfrb(UCA3RXBUF, UCA3RXBUF_);
#define UCA3TXBUF_          __MSP430_USCI5_BASE_3__ + 0x0E                       // USCI transmit buffer
sfrb(UCA3TXBUF, UCA3TXBUF_);
#define UCA3ABCTL_          __MSP430_USCI5_BASE_3__ + 0x10                       // USCI LIN control
sfrb(UCA3ABCTL, UCA3ABCTL_);
#define UCA3IRTCTL_         __MSP430_USCI5_BASE_3__ + 0x12                       // USCI IrDA transmit control
sfrb(UCA3IRTCTL, UCA3IRTCTL_);
#define UCA3IRRCTL_         __MSP430_USCI5_BASE_3__ + 0x13                       // USCI IrDA receive control
sfrb(UCA3IRRCTL, UCA3IRRCTL_);
#define UCA3IE_             __MSP430_USCI5_BASE_3__ + 0x1C                       // USCI interrupt enable
sfrb(UCA3IE, UCA3IE_);
#define UCA3IFG_            __MSP430_USCI5_BASE_3__ + 0x1D                       // USCI interrupt flags
sfrb(UCA3IFG, UCA3IFG_);
#define UCA3IV_             __MSP430_USCI5_BASE_3__ + 0x1E                       // USCI interrupt vector word
sfrw(UCA3IV, UCA3IV_);
#define UCA3IV_L_           __MSP430_USCI5_BASE_3__ + 0x1E
sfrb(UCA3IV_L, UCA3IV_L_);
#define UCA3IV_H_           __MSP430_USCI5_BASE_3__ + 0x1F
sfrb(UCA3IV_H, UCA3IV_H_);

#define UCB3CTL0_           __MSP430_USCI5_BASE_3__ + 0x21                       // USCI synchronous control 0
sfrb(UCB3CTL0, UCB3CTL0_);
#define UCB3CTL1_           __MSP430_USCI5_BASE_3__ + 0x20                       // USCI synchronous control 1
sfrb(UCB3CTL1, UCB3CTL1_);
#define UCB3BR0_            __MSP430_USCI5_BASE_3__ + 0x26                       // USCI synchronous bit rate 0
sfrb(UCB3BR0, UCB3BR0_);
#define UCB3BR1_            __MSP430_USCI5_BASE_3__ + 0x27                       // USCI synchronous bit rate 1
sfrb(UCB3BR1, UCB3BR1_);
#define UCB3MCTL_           __MSP430_USCI5_BASE_3__ + 0x28                       // USCI I2C interrupt enable
sfrb(UCB3MCTL, UCB3MCTL_);
#define UCB3STAT_           __MSP430_USCI5_BASE_3__ + 0x2A                       // USCI synchronous status
sfrb(UCB3STAT, UCB3STAT_);
#define UCB3RXBUF_          __MSP430_USCI5_BASE_3__ + 0x2C                       // USCI synchronous receive buffer
sfrb(UCB3RXBUF, UCB3RXBUF_);
#define UCB3TXBUF_          __MSP430_USCI5_BASE_3__ + 0x2E                       // USCI synchronous transmit buffer
sfrb(UCB3TXBUF, UCB3TXBUF_);
#define UCB3I2COA_          __MSP430_USCI5_BASE_3__ + 0x30                       // USCI I2C own address
sfrb(UCB3I2COA, UCB3I2COA_);
#define UCB3I2CSA_          __MSP430_USCI5_BASE_3__ + 0x32                       // USCI I2C slave address
sfrb(UCB3I2CSA, UCB3I2CSA_);
#define UCB3IE_             __MSP430_USCI5_BASE_3__ + 0x3C                       // USCI interrupt enable
sfrb(UCB3IE, UCB3IE_);
#define UCB3IFG_            __MSP430_USCI5_BASE_3__ + 0x3D                       // USCI interrupt flags
sfrb(UCB3IFG, UCB3IFG_);
#define UCB3IV_             __MSP430_USCI5_BASE_3__ + 0x3E                       // USCI interrupt vector word
sfrw(UCB3IV, UCB3IV_);
#define UCB3IV_L_           __MSP430_USCI5_BASE_3__ + 0x3E
sfrb(UCB3IV_L, UCB3IV_L_);
#define UCB3IV_H_           __MSP430_USCI5_BASE_3__ + 0x3F
sfrb(UCB3IV_H, UCB3IV_H_);

#endif /* __MSP430_USCI5_BASE_3__ */

#endif /* __MSP430_HEADERS_USCI_H__ */
