#
# $Id: easy.pm,v 1.1 2004/04/20 13:28:43 crisb Exp $
#
# Backwards compatability package for WWW::Curl::Easy
#

package WWW::Curl::easy;

use strict;
use vars qw($VERSION @ISA @EXPORT);

$VERSION = '3.1';

require WWW::Curl::Easy;
@ISA=qw(WWW::Curl::Easy);
@EXPORT=@WWW::Curl::Easy::EXPORT;

sub init
{
    return WWW::Curl::Easy::init(@_);
}

sub version
{
    return WWW::Curl::Easy::version(@_);
}

sub setopt
{
    return WWW::Curl::Easy::setopt(@_);
}

sub perform
{
    return WWW::Curl::Easy::perform(@_);
}

sub getinfo
{
    return WWW::Curl::Easy::getinfo(@_);
}

sub cleanup
{
    return WWW::Curl::Easy::cleanup(@_);
}

sub global_cleanup
{
    return WWW::Curl::Easy::global_cleanup(@_);
}

1;

__END__

=cut 

=head1 NAME

WWW::Curl::easy - Compatability Perl extension interface for libcurl

=head1 SYNOPSIS

	use WWW::Curl::easy;


=head1 DESCRIPTION

This module exists only to provide backwards compatability for existing scripts
using the 'WWW::Curl::easy' module, which has now changed name to 'WWW::Curl::Easy'.

Don't use this module for new scripts - use 'WWW::Curl::Easy' instead.
 
=head1 AUTHOR

Version 3.00 of WWW::Curl::Easy is a renaming of the previous version, named WWW::Curl::easy.

=head1 Copyright

Copyright (C) 2003,2004 Cris Bailiff
 
You may opt to use, copy, modify, merge, publish, distribute and/or sell
copies of the Software, and permit persons to whom the Software is furnished
to do so, under the terms of the MPL or the MIT/X-derivate licenses. You may
pick one of these licenses.

=head1 SEE ALSO

http://curl.haxx.se/


