/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DBConnection;
import ca.sqlpower.sql.OracleSequenceGenerator;
import ca.sqlpower.sql.PostgreSQLSequenceGenerator;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class SequenceGenerator {
    public abstract long nextLong(String var1) throws SQLException;

    public static SequenceGenerator getInstance(Connection con) {
        if (DBConnection.isOracle(con)) {
            return new OracleSequenceGenerator(con);
        }
        if (DBConnection.isPostgres(con)) {
            return new PostgreSQLSequenceGenerator(con);
        }
        throw new IllegalArgumentException("The JDBC driver " + con.getClass().getName() + " is not recognised.");
    }

    public void close() throws SQLException {
    }
}

