/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui;

import com.darwinsys.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileChooserPanel
extends JPanel {
    private static final String DEFAULT_LABEL = "Location";
    private static final long serialVersionUID = -3104535593905377745L;
    private final JFrame parent;
    private final JFileChooser chooser;
    private final JTextField fileNameTextField;
    private List<PropertyChangeListener> listeners;

    public FileChooserPanel(JFrame par, String label) {
        this.parent = par;
        this.chooser = new JFileChooser();
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.add(new JLabel(label));
        ActionListener goListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal;
                String old = FileChooserPanel.this.fileNameTextField.getText();
                if (old != null) {
                    File f = new File(old);
                    if (f.isFile()) {
                        FileChooserPanel.this.chooser.setCurrentDirectory(f.getParentFile());
                    } else if (f.isDirectory()) {
                        FileChooserPanel.this.chooser.setCurrentDirectory(f);
                    }
                }
                if ((returnVal = FileChooserPanel.this.chooser.showOpenDialog(FileChooserPanel.this.parent)) == 0) {
                    File file = FileChooserPanel.this.chooser.getSelectedFile();
                    Debug.println("chooser", "You chose a " + (file.isFile() ? "file" : "directory") + " named: " + file.getPath());
                    FileChooserPanel.this.fileNameTextField.setText(file.getAbsolutePath());
                    FileChooserPanel.this.repaint();
                    FileChooserPanel.this.firePropertyChangeEvent(file);
                }
            }
        };
        this.fileNameTextField = new JTextField(30);
        this.fileNameTextField.addActionListener(goListener);
        this.add(this.fileNameTextField);
        JButton b = new JButton("...");
        b.addActionListener(goListener);
        this.add(b);
    }

    public FileChooserPanel(JFrame par) {
        this(par, DEFAULT_LABEL);
    }

    public JFileChooser getChooser() {
        return this.chooser;
    }

    public void setFileName(String text) {
        this.fileNameTextField.setText(text);
    }

    public void firePropertyChangeEvent(File chosenFile) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "chosen", null, chosenFile);
        for (PropertyChangeListener list : this.listeners) {
            list.propertyChange(evt);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }
}

