/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.IndexedSeq;
import clojure.lang.Reflector;
import clojure.lang.Util;
import java.lang.reflect.Array;

public class ArraySeq
extends ASeq
implements IndexedSeq,
IReduce {
    public final Object array;
    final int i;
    final Object[] oa;

    public static ArraySeq create() {
        return null;
    }

    public static ArraySeq create(Object ... array2) {
        if (array2 == null || array2.length == 0) {
            return null;
        }
        return new ArraySeq(array2, 0);
    }

    static ISeq createFromObject(Object array2) {
        if (array2 == null || Array.getLength(array2) == 0) {
            return null;
        }
        Class<?> aclass = array2.getClass();
        if (aclass == int[].class) {
            return new ArraySeq_int(null, (int[])array2, 0);
        }
        if (aclass == float[].class) {
            return new ArraySeq_float(null, (float[])array2, 0);
        }
        if (aclass == double[].class) {
            return new ArraySeq_double(null, (double[])array2, 0);
        }
        if (aclass == long[].class) {
            return new ArraySeq_long(null, (long[])array2, 0);
        }
        if (aclass == byte[].class) {
            return new ArraySeq_byte(null, (byte[])array2, 0);
        }
        if (aclass == char[].class) {
            return new ArraySeq_char(null, (char[])array2, 0);
        }
        if (aclass == boolean[].class) {
            return new ArraySeq_boolean(null, (boolean[])array2, 0);
        }
        return new ArraySeq(array2, 0);
    }

    ArraySeq(Object array2, int i) {
        this.array = array2;
        this.i = i;
        this.oa = (Object[])(array2 instanceof Object[] ? array2 : null);
    }

    ArraySeq(IPersistentMap meta2, Object array2, int i) {
        super(meta2);
        this.array = array2;
        this.i = i;
        this.oa = (Object[])(array2 instanceof Object[] ? array2 : null);
    }

    public Object first() {
        if (this.oa != null) {
            return this.oa[this.i];
        }
        return Reflector.prepRet(Array.get(this.array, this.i));
    }

    public ISeq next() {
        if (this.oa != null ? this.i + 1 < this.oa.length : this.i + 1 < Array.getLength(this.array)) {
            return new ArraySeq(this.array, this.i + 1);
        }
        return null;
    }

    public int count() {
        if (this.oa != null) {
            return this.oa.length - this.i;
        }
        return Array.getLength(this.array) - this.i;
    }

    public int index() {
        return this.i;
    }

    public ArraySeq withMeta(IPersistentMap meta2) {
        return new ArraySeq(meta2, this.array, this.i);
    }

    public Object reduce(IFn f) throws Exception {
        if (this.oa != null) {
            Object ret = this.oa[this.i];
            for (int x = this.i + 1; x < this.oa.length; ++x) {
                ret = f.invoke(ret, this.oa[x]);
            }
            return ret;
        }
        Object ret = Reflector.prepRet(Array.get(this.array, this.i));
        for (int x = this.i + 1; x < Array.getLength(this.array); ++x) {
            ret = f.invoke(ret, Reflector.prepRet(Array.get(this.array, x)));
        }
        return ret;
    }

    public Object reduce(IFn f, Object start) throws Exception {
        if (this.oa != null) {
            Object ret = f.invoke(start, this.oa[this.i]);
            for (int x = this.i + 1; x < this.oa.length; ++x) {
                ret = f.invoke(ret, this.oa[x]);
            }
            return ret;
        }
        Object ret = f.invoke(start, Reflector.prepRet(Array.get(this.array, this.i)));
        for (int x = this.i + 1; x < Array.getLength(this.array); ++x) {
            ret = f.invoke(ret, Reflector.prepRet(Array.get(this.array, x)));
        }
        return ret;
    }

    public int indexOf(Object o) {
        if (this.oa != null) {
            for (int j = this.i; j < this.oa.length; ++j) {
                if (!Util.equals(o, this.oa[j])) continue;
                return j - this.i;
            }
        } else {
            int n = Array.getLength(this.array);
            for (int j = this.i; j < n; ++j) {
                if (!Util.equals(o, Reflector.prepRet(Array.get(this.array, j)))) continue;
                return j - this.i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        if (this.oa != null) {
            if (o == null) {
                for (int j = this.oa.length - 1; j >= this.i; --j) {
                    if (this.oa[j] != null) continue;
                    return j - this.i;
                }
            } else {
                for (int j = this.oa.length - 1; j >= this.i; --j) {
                    if (!o.equals(this.oa[j])) continue;
                    return j - this.i;
                }
            }
        } else if (o == null) {
            for (int j = Array.getLength(this.array) - 1; j >= this.i; --j) {
                if (Reflector.prepRet(Array.get(this.array, j)) != null) continue;
                return j - this.i;
            }
        } else {
            for (int j = Array.getLength(this.array) - 1; j >= this.i; --j) {
                if (!o.equals(Reflector.prepRet(Array.get(this.array, j)))) continue;
                return j - this.i;
            }
        }
        return -1;
    }

    public static class ArraySeq_boolean
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final boolean[] array;
        final int i;

        ArraySeq_boolean(IPersistentMap meta2, boolean[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_boolean(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_boolean withMeta(IPersistentMap meta2) {
            return new ArraySeq_boolean(meta2, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Boolean) {
                boolean b = (Boolean)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (b != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Boolean) {
                boolean b = (Boolean)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (b != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_char
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final char[] array;
        final int i;

        ArraySeq_char(IPersistentMap meta2, char[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        public Object first() {
            return Character.valueOf(this.array[this.i]);
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_char(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_char withMeta(IPersistentMap meta2) {
            return new ArraySeq_char(meta2, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = Character.valueOf(this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Character.valueOf(this.array[x]));
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, Character.valueOf(this.array[this.i]));
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Character.valueOf(this.array[x]));
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Character) {
                char c = ((Character)o).charValue();
                for (int j = this.i; j < this.array.length; ++j) {
                    if (c != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(Character.valueOf(this.array[j]))) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Character) {
                char c = ((Character)o).charValue();
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (c != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(Character.valueOf(this.array[j]))) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_byte
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final byte[] array;
        final int i;

        ArraySeq_byte(IPersistentMap meta2, byte[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_byte(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_byte withMeta(IPersistentMap meta2) {
            return new ArraySeq_byte(meta2, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Byte) {
                byte b = (Byte)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (b != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Byte) {
                byte b = (Byte)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (b != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_long
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final long[] array;
        final int i;

        ArraySeq_long(IPersistentMap meta2, long[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_long(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_long withMeta(IPersistentMap meta2) {
            return new ArraySeq_long(meta2, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Long) {
                long l = (Long)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (l != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Long) {
                long l = (Long)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (l != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_double
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final double[] array;
        final int i;

        ArraySeq_double(IPersistentMap meta2, double[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_double(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_double withMeta(IPersistentMap meta2) {
            return new ArraySeq_double(meta2, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Double) {
                double d = (Double)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (d != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Double) {
                double d = (Double)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (d != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_float
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final float[] array;
        final int i;

        ArraySeq_float(IPersistentMap meta2, float[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        public Object first() {
            return Float.valueOf(this.array[this.i]);
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_float(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_float withMeta(IPersistentMap meta2) {
            return new ArraySeq_float(meta2, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = Float.valueOf(this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Float.valueOf(this.array[x]));
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, Float.valueOf(this.array[this.i]));
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Float.valueOf(this.array[x]));
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Float) {
                float f = ((Float)o).floatValue();
                for (int j = this.i; j < this.array.length; ++j) {
                    if (f != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(Float.valueOf(this.array[j]))) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Float) {
                float f = ((Float)o).floatValue();
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (f != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(Float.valueOf(this.array[j]))) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_int
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final int[] array;
        final int i;

        ArraySeq_int(IPersistentMap meta2, int[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_int(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_int withMeta(IPersistentMap meta2) {
            return new ArraySeq_int(meta2, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Integer) {
                int k = (Integer)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (k != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Integer) {
                int k = (Integer)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (k != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }
}

