/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryCursor;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.internal.Db;
import java.io.FileNotFoundException;

public class SecondaryDatabase
extends Database {
    private final Database primaryDatabase;

    SecondaryDatabase(Db db, Database database) throws DatabaseException {
        super(db);
        this.primaryDatabase = database;
    }

    public SecondaryDatabase(String string, String string2, Database database, SecondaryConfig secondaryConfig) throws DatabaseException, FileNotFoundException {
        this(SecondaryConfig.checkNull(secondaryConfig).openSecondaryDatabase(null, null, string, string2, database.db), database);
    }

    public Cursor openCursor(Transaction transaction, CursorConfig cursorConfig) throws DatabaseException {
        return this.openSecondaryCursor(transaction, cursorConfig);
    }

    public SecondaryCursor openSecondaryCursor(Transaction transaction, CursorConfig cursorConfig) throws DatabaseException {
        return new SecondaryCursor(this, CursorConfig.checkNull(cursorConfig).openCursor(this.db, transaction == null ? null : transaction.txn), cursorConfig);
    }

    public Database getPrimaryDatabase() {
        return this.primaryDatabase;
    }

    public DatabaseConfig getConfig() throws DatabaseException {
        return this.getSecondaryConfig();
    }

    public SecondaryConfig getSecondaryConfig() throws DatabaseException {
        return new SecondaryConfig(this.db);
    }

    public OperationStatus get(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.db.pget(transaction == null ? null : transaction.txn, databaseEntry, databaseEntry2, databaseEntry3, LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getSearchBoth(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.db.pget(transaction == null ? null : transaction.txn, databaseEntry, databaseEntry2, databaseEntry3, 8 | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getSearchRecordNumber(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.db.pget(transaction == null ? null : transaction.txn, databaseEntry, databaseEntry2, databaseEntry3, 0x1C | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }
}

