/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.internal.launching.CommandExecutor;
import org.rubypeople.rdt.internal.launching.IllegalCommandException;
import org.rubypeople.rdt.internal.launching.RdtLaunchingMessages;
import org.rubypeople.rdt.internal.launching.RdtLaunchingPlugin;
import org.rubypeople.rdt.internal.launching.StandardCommandExecutor;

public class RubyInterpreter {
    public static final String END_OF_OPTIONS_DELIMITER = "--";
    protected IPath installLocation;
    protected String name;
    private final CommandExecutor commandExecutor;

    public RubyInterpreter(String string, IPath iPath) {
        this(string, iPath, new StandardCommandExecutor());
    }

    public RubyInterpreter(String string, IPath iPath, CommandExecutor commandExecutor) {
        this.name = string;
        this.installLocation = iPath;
        this.commandExecutor = commandExecutor;
    }

    public IPath getInstallLocation() {
        return this.installLocation;
    }

    public void setInstallLocation(IPath iPath) {
        this.installLocation = iPath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getCommand() throws IllegalCommandException {
        if (new File(this.installLocation.toOSString()).isFile()) {
            return this.installLocation.toOSString();
        }
        String string = MessageFormat.format(RdtLaunchingMessages.getString("RdtLaunchingPlugin.interpreterNotFound"), this.getName());
        throw new IllegalCommandException(string);
    }

    public Process exec(List list, File file) throws CoreException {
        try {
            RdtLaunchingPlugin.debug("Launching: " + list);
            RdtLaunchingPlugin.debug("Working Dir: " + file);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getCommand());
            arrayList.addAll(list);
            return this.commandExecutor.exec(arrayList.toArray(new String[0]), file);
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.rubypeople.rdt.launching", 0, "Unable to execute interpreter: " + list + file, (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
        catch (IllegalCommandException illegalCommandException) {
            Status status = new Status(4, "org.rubypeople.rdt.launching", 0, illegalCommandException.getMessage(), (Throwable)illegalCommandException);
            throw new CoreException((IStatus)status);
        }
    }

    public boolean equals(Object object) {
        RubyInterpreter rubyInterpreter;
        if (object instanceof RubyInterpreter && this.name.equals((rubyInterpreter = (RubyInterpreter)object).getName())) {
            return this.installLocation.equals((Object)rubyInterpreter.getInstallLocation());
        }
        return false;
    }
}

