/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class OverlayPreferenceStore
implements IPreferenceStore {
    public static final TypeDescriptor BOOLEAN = new TypeDescriptor();
    public static final TypeDescriptor DOUBLE = new TypeDescriptor();
    public static final TypeDescriptor FLOAT = new TypeDescriptor();
    public static final TypeDescriptor INT = new TypeDescriptor();
    public static final TypeDescriptor LONG = new TypeDescriptor();
    public static final TypeDescriptor STRING = new TypeDescriptor();
    private IPreferenceStore fParent;
    private IPreferenceStore fStore;
    private OverlayKey[] fOverlayKeys;
    private PropertyListener fPropertyListener;
    private boolean fLoaded;

    public OverlayPreferenceStore(IPreferenceStore parent, OverlayKey[] overlayKeys) {
        this.fParent = parent;
        this.fOverlayKeys = overlayKeys;
        this.fStore = new PreferenceStore();
    }

    private OverlayKey findOverlayKey(String key) {
        int i = 0;
        while (i < this.fOverlayKeys.length) {
            if (this.fOverlayKeys[i].fKey.equals(key)) {
                return this.fOverlayKeys[i];
            }
            ++i;
        }
        return null;
    }

    private boolean covers(String key) {
        return this.findOverlayKey(key) != null;
    }

    private void propagateProperty(IPreferenceStore orgin, OverlayKey key, IPreferenceStore target) {
        if (orgin.isDefault(key.fKey)) {
            if (!target.isDefault(key.fKey)) {
                target.setToDefault(key.fKey);
            }
            return;
        }
        TypeDescriptor d = key.fDescriptor;
        if (BOOLEAN == d) {
            boolean originValue = orgin.getBoolean(key.fKey);
            boolean targetValue = target.getBoolean(key.fKey);
            if (targetValue != originValue) {
                target.setValue(key.fKey, originValue);
            }
        } else if (DOUBLE == d) {
            double originValue = orgin.getDouble(key.fKey);
            double targetValue = target.getDouble(key.fKey);
            if (targetValue != originValue) {
                target.setValue(key.fKey, originValue);
            }
        } else if (FLOAT == d) {
            float originValue = orgin.getFloat(key.fKey);
            float targetValue = target.getFloat(key.fKey);
            if (targetValue != originValue) {
                target.setValue(key.fKey, originValue);
            }
        } else if (INT == d) {
            int originValue = orgin.getInt(key.fKey);
            int targetValue = target.getInt(key.fKey);
            if (targetValue != originValue) {
                target.setValue(key.fKey, originValue);
            }
        } else if (LONG == d) {
            long originValue = orgin.getLong(key.fKey);
            long targetValue = target.getLong(key.fKey);
            if (targetValue != originValue) {
                target.setValue(key.fKey, originValue);
            }
        } else if (STRING == d) {
            String originValue = orgin.getString(key.fKey);
            String targetValue = target.getString(key.fKey);
            if (targetValue != null && originValue != null && !targetValue.equals(originValue)) {
                target.setValue(key.fKey, originValue);
            }
        }
    }

    public void propagate() {
        int i = 0;
        while (i < this.fOverlayKeys.length) {
            this.propagateProperty(this.fStore, this.fOverlayKeys[i], this.fParent);
            ++i;
        }
    }

    private void loadProperty(IPreferenceStore orgin, OverlayKey key, IPreferenceStore target, boolean forceInitialization) {
        TypeDescriptor d = key.fDescriptor;
        if (BOOLEAN == d) {
            if (forceInitialization) {
                target.setValue(key.fKey, true);
            }
            target.setValue(key.fKey, orgin.getBoolean(key.fKey));
            target.setDefault(key.fKey, orgin.getDefaultBoolean(key.fKey));
        } else if (DOUBLE == d) {
            if (forceInitialization) {
                target.setValue(key.fKey, 1.0);
            }
            target.setValue(key.fKey, orgin.getDouble(key.fKey));
            target.setDefault(key.fKey, orgin.getDefaultDouble(key.fKey));
        } else if (FLOAT == d) {
            if (forceInitialization) {
                target.setValue(key.fKey, 1.0f);
            }
            target.setValue(key.fKey, orgin.getFloat(key.fKey));
            target.setDefault(key.fKey, orgin.getDefaultFloat(key.fKey));
        } else if (INT == d) {
            if (forceInitialization) {
                target.setValue(key.fKey, 1);
            }
            target.setValue(key.fKey, orgin.getInt(key.fKey));
            target.setDefault(key.fKey, orgin.getDefaultInt(key.fKey));
        } else if (LONG == d) {
            if (forceInitialization) {
                target.setValue(key.fKey, 1L);
            }
            target.setValue(key.fKey, orgin.getLong(key.fKey));
            target.setDefault(key.fKey, orgin.getDefaultLong(key.fKey));
        } else if (STRING == d) {
            if (forceInitialization) {
                target.setValue(key.fKey, "1");
            }
            target.setValue(key.fKey, orgin.getString(key.fKey));
            target.setDefault(key.fKey, orgin.getDefaultString(key.fKey));
        }
    }

    public void load() {
        int i = 0;
        while (i < this.fOverlayKeys.length) {
            this.loadProperty(this.fParent, this.fOverlayKeys[i], this.fStore, true);
            ++i;
        }
        this.fLoaded = true;
    }

    public void loadDefaults() {
        int i = 0;
        while (i < this.fOverlayKeys.length) {
            this.setToDefault(this.fOverlayKeys[i].fKey);
            ++i;
        }
    }

    public void start() {
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new PropertyListener();
            this.fParent.addPropertyChangeListener((IPropertyChangeListener)this.fPropertyListener);
        }
    }

    public void stop() {
        if (this.fPropertyListener != null) {
            this.fParent.removePropertyChangeListener((IPropertyChangeListener)this.fPropertyListener);
            this.fPropertyListener = null;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fStore.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fStore.removePropertyChangeListener(listener);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.fStore.firePropertyChangeEvent(name, oldValue, newValue);
    }

    public boolean contains(String name) {
        return this.fStore.contains(name);
    }

    public boolean getBoolean(String name) {
        return this.fStore.getBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.fStore.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.fStore.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.fStore.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.fStore.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.fStore.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.fStore.getDefaultString(name);
    }

    public double getDouble(String name) {
        return this.fStore.getDouble(name);
    }

    public float getFloat(String name) {
        return this.fStore.getFloat(name);
    }

    public int getInt(String name) {
        return this.fStore.getInt(name);
    }

    public long getLong(String name) {
        return this.fStore.getLong(name);
    }

    public String getString(String name) {
        return this.fStore.getString(name);
    }

    public boolean isDefault(String name) {
        return this.fStore.isDefault(name);
    }

    public boolean needsSaving() {
        return this.fStore.needsSaving();
    }

    public void putValue(String name, String value) {
        if (this.covers(name)) {
            this.fStore.putValue(name, value);
        }
    }

    public void setDefault(String name, double value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    public void setDefault(String name, float value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    public void setDefault(String name, int value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    public void setDefault(String name, long value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    public void setDefault(String name, String value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    public void setDefault(String name, boolean value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    public void setToDefault(String name) {
        this.fStore.setToDefault(name);
    }

    public void setValue(String name, double value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public void setValue(String name, float value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public void setValue(String name, int value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public void setValue(String name, long value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public void setValue(String name, String value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public void setValue(String name, boolean value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public void addKeys(OverlayKey[] keys) {
        Assert.isTrue((!this.fLoaded ? 1 : 0) != 0);
        Assert.isNotNull((Object)keys);
        int overlayKeysLength = this.fOverlayKeys.length;
        OverlayKey[] result = new OverlayKey[keys.length + overlayKeysLength];
        int i = 0;
        int length = overlayKeysLength;
        while (i < length) {
            result[i] = this.fOverlayKeys[i];
            ++i;
        }
        i = 0;
        length = keys.length;
        while (i < length) {
            result[overlayKeysLength + i] = keys[i];
            ++i;
        }
        this.fOverlayKeys = result;
        if (this.fLoaded) {
            this.load();
        }
    }

    public static final class TypeDescriptor {
        private TypeDescriptor() {
        }
    }

    public static class OverlayKey {
        TypeDescriptor fDescriptor;
        String fKey;

        public OverlayKey(TypeDescriptor descriptor, String key) {
            this.fDescriptor = descriptor;
            this.fKey = key;
        }
    }

    private class PropertyListener
    implements IPropertyChangeListener {
        private PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            OverlayKey key = OverlayPreferenceStore.this.findOverlayKey(event.getProperty());
            if (key != null) {
                OverlayPreferenceStore.this.propagateProperty(OverlayPreferenceStore.this.fParent, key, OverlayPreferenceStore.this.fStore);
            }
        }
    }
}

