/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TypeInfoLabelProvider
extends LabelProvider {
    public static final int SHOW_FULLYQUALIFIED = 1;
    public static final int SHOW_PACKAGE_POSTFIX = 2;
    public static final int SHOW_PACKAGE_ONLY = 4;
    public static final int SHOW_ROOT_POSTFIX = 8;
    public static final int SHOW_TYPE_ONLY = 16;
    public static final int SHOW_TYPE_CONTAINER_ONLY = 32;
    public static final int SHOW_POST_QUALIFIED = 64;
    private static final Image CLASS_ICON = JavaPluginImages.get("org.eclipse.jdt.ui.class_obj.gif");
    private static final Image ANNOTATION_ICON = JavaPluginImages.get("org.eclipse.jdt.ui.annotation_obj.gif");
    private static final Image INTERFACE_ICON = JavaPluginImages.get("org.eclipse.jdt.ui.int_obj.gif");
    private static final Image ENUM_ICON = JavaPluginImages.get("org.eclipse.jdt.ui.enum_obj.gif");
    private static final Image PKG_ICON = JavaPluginImages.get("org.eclipse.jdt.ui.package_obj.gif");
    private int fFlags;

    public TypeInfoLabelProvider(int flags) {
        this.fFlags = flags;
    }

    private boolean isSet(int flag) {
        return (this.fFlags & flag) != 0;
    }

    private String getPackageName(String packName) {
        if (packName.length() == 0) {
            return JavaUIMessages.TypeInfoLabelProvider_default_package;
        }
        return packName;
    }

    public String getText(Object element) {
        if (!(element instanceof TypeInfo)) {
            return super.getText(element);
        }
        TypeInfo typeRef = (TypeInfo)element;
        StringBuffer buf = new StringBuffer();
        if (this.isSet(16)) {
            buf.append(typeRef.getTypeName());
        } else if (this.isSet(32)) {
            String containerName = typeRef.getTypeContainerName();
            buf.append(this.getPackageName(containerName));
        } else if (this.isSet(4)) {
            String packName = typeRef.getPackageName();
            buf.append(this.getPackageName(packName));
        } else {
            if (this.isSet(1)) {
                buf.append(typeRef.getFullyQualifiedName());
            } else if (this.isSet(64)) {
                buf.append(typeRef.getTypeName());
                String containerName = typeRef.getTypeContainerName();
                if (containerName != null && containerName.length() > 0) {
                    buf.append(JavaElementLabels.CONCAT_STRING);
                    buf.append(containerName);
                }
            } else {
                buf.append(typeRef.getTypeQualifiedName());
            }
            if (this.isSet(2)) {
                buf.append(JavaElementLabels.CONCAT_STRING);
                String packName = typeRef.getPackageName();
                buf.append(this.getPackageName(packName));
            }
        }
        if (this.isSet(8)) {
            buf.append(JavaElementLabels.CONCAT_STRING);
            buf.append(typeRef.getPackageFragmentRootPath().toString());
        }
        return buf.toString();
    }

    public Image getImage(Object element) {
        if (!(element instanceof TypeInfo)) {
            return super.getImage(element);
        }
        if (this.isSet(32)) {
            TypeInfo typeRef = (TypeInfo)element;
            if (typeRef.getPackageName().equals(typeRef.getTypeContainerName())) {
                return PKG_ICON;
            }
            return CLASS_ICON;
        }
        if (this.isSet(4)) {
            return PKG_ICON;
        }
        int modifiers = ((TypeInfo)element).getModifiers();
        if (Flags.isAnnotation((int)modifiers)) {
            return ANNOTATION_ICON;
        }
        if (Flags.isEnum((int)modifiers)) {
            return ENUM_ICON;
        }
        if (Flags.isInterface((int)modifiers)) {
            return INTERFACE_ICON;
        }
        return CLASS_ICON;
    }
}

