/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.launchConfigurations.DeleteAssociatedLaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.ui.model.AdaptableList;

public class DeleteLaunchConfigurationStatusHandler
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        String pref = DebugUIPlugin.getDefault().getPreferenceStore().getString(IInternalDebugUIConstants.PREF_DELETE_CONFIGS_ON_PROJECT_DELETE);
        if (source instanceof IProject[]) {
            IProject[] projects = (IProject[])source;
            ArrayList configs = new ArrayList();
            ArrayList elements = null;
            HashMap<IProject, ArrayList> map = new HashMap<IProject, ArrayList>();
            int i = 0;
            while (i < projects.length) {
                elements = this.collectAssociatedLaunches(projects[i]);
                if (!elements.isEmpty()) {
                    map.put(projects[i], elements);
                    configs.addAll(elements);
                }
                ++i;
            }
            if (configs.size() > 0) {
                if (pref.equals("prompt")) {
                    DeleteAssociatedLaunchConfigurationsDialog lsd = new DeleteAssociatedLaunchConfigurationsDialog(DebugUIPlugin.getShell(), new AdaptableList(configs), LaunchConfigurationsMessages.DeleteLaunchConfigurations_0, map);
                    lsd.setInitialSelections(configs.toArray());
                    lsd.setTitle(LaunchConfigurationsMessages.DeleteLaunchConfigurations_1);
                    if (lsd.open() == 0) {
                        this.doDelete(lsd.getResult());
                    }
                } else if (pref.equals("always")) {
                    this.doDelete(configs.toArray());
                }
            }
        }
        return null;
    }

    private ArrayList collectAssociatedLaunches(IProject project) {
        ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            IResource[] resources = null;
            int i = 0;
            while (i < configs.length) {
                if (configs[i].isLocal() && (resources = configs[i].getMappedResources()) != null) {
                    int j = 0;
                    while (j < resources.length) {
                        if (resources[j].equals((Object)project)) {
                            list.add(configs[i]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        return list;
    }

    private void doDelete(Object[] launches) {
        try {
            int i = 0;
            while (i < launches.length) {
                ((ILaunchConfiguration)launches[i]).delete();
                ++i;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }
}

