%%------------------------------------------------------------
%%
%% Implementation stub file
%% 
%% Target: CosEventDomainAdmin_EventDomain
%% Source: /net/isildur/ldisk/daily_build/otp_prebuild_r13b04.2010-02-22_20/otp_src_R13B04/lib/cosEventDomain/src/CosEventDomainAdmin.idl
%% IC vsn: 4.2.24
%% 
%% This file is automatically generated. DO NOT EDIT IT.
%%
%%------------------------------------------------------------

-module('CosEventDomainAdmin_EventDomain').
-ic_compiled("4_2_24").


%% Interface functions
-export([add_channel/2, add_channel/3, get_all_channels/1]).
-export([get_all_channels/2, get_channel/2, get_channel/3]).
-export([remove_channel/2, remove_channel/3, add_connection/2]).
-export([add_connection/3, get_all_connections/1, get_all_connections/2]).
-export([get_connection/2, get_connection/3, remove_connection/2]).
-export([remove_connection/3, get_offer_channels/2, get_offer_channels/3]).
-export([get_subscription_channels/2, get_subscription_channels/3, destroy/1]).
-export([destroy/2, get_cycles/1, get_cycles/2]).
-export([get_diamonds/1, get_diamonds/2, set_default_consumer_channel/2]).
-export([set_default_consumer_channel/3, set_default_supplier_channel/2, set_default_supplier_channel/3]).
-export([connect_push_consumer/2, connect_push_consumer/3, connect_pull_consumer/2]).
-export([connect_pull_consumer/3, connect_push_supplier/2, connect_push_supplier/3]).
-export([connect_pull_supplier/2, connect_pull_supplier/3, connect_structured_push_consumer/2]).
-export([connect_structured_push_consumer/3, connect_structured_pull_consumer/2, connect_structured_pull_consumer/3]).
-export([connect_structured_push_supplier/2, connect_structured_push_supplier/3, connect_structured_pull_supplier/2]).
-export([connect_structured_pull_supplier/3, connect_sequence_push_consumer/2, connect_sequence_push_consumer/3]).
-export([connect_sequence_pull_consumer/2, connect_sequence_pull_consumer/3, connect_sequence_push_supplier/2]).
-export([connect_sequence_push_supplier/3, connect_sequence_pull_supplier/2, connect_sequence_pull_supplier/3]).
-export([connect_push_consumer_with_id/3, connect_push_consumer_with_id/4, connect_pull_consumer_with_id/3]).
-export([connect_pull_consumer_with_id/4, connect_push_supplier_with_id/3, connect_push_supplier_with_id/4]).
-export([connect_pull_supplier_with_id/3, connect_pull_supplier_with_id/4, connect_structured_push_consumer_with_id/3]).
-export([connect_structured_push_consumer_with_id/4, connect_structured_pull_consumer_with_id/3, connect_structured_pull_consumer_with_id/4]).
-export([connect_structured_push_supplier_with_id/3, connect_structured_push_supplier_with_id/4, connect_structured_pull_supplier_with_id/3]).
-export([connect_structured_pull_supplier_with_id/4, connect_sequence_push_consumer_with_id/3, connect_sequence_push_consumer_with_id/4]).
-export([connect_sequence_pull_consumer_with_id/3, connect_sequence_pull_consumer_with_id/4, connect_sequence_push_supplier_with_id/3]).
-export([connect_sequence_push_supplier_with_id/4, connect_sequence_pull_supplier_with_id/3, connect_sequence_pull_supplier_with_id/4]).

%% Exports from "CosNotification::QoSAdmin"
-export([get_qos/1, get_qos/2, set_qos/2]).
-export([set_qos/3, validate_qos/2, validate_qos/3]).

%% Exports from "CosNotification::AdminPropertiesAdmin"
-export([get_admin/1, get_admin/2, set_admin/2]).
-export([set_admin/3]).

%% Type identification function
-export([typeID/0]).

%% Used to start server
-export([oe_create/0, oe_create_link/0, oe_create/1]).
-export([oe_create_link/1, oe_create/2, oe_create_link/2]).

%% TypeCode Functions and inheritance
-export([oe_tc/1, oe_is_a/1, oe_get_interface/0]).

%% gen server export stuff
-behaviour(gen_server).
-export([init/1, terminate/2, handle_call/3]).
-export([handle_cast/2, handle_info/2, code_change/3]).

-include_lib("orber/include/corba.hrl").


%%------------------------------------------------------------
%%
%% Object interface functions.
%%
%%------------------------------------------------------------



%%%% Operation: add_channel
%% 
%%   Returns: RetVal
%%
add_channel(OE_THIS, Channel) ->
    corba:call(OE_THIS, add_channel, [Channel], ?MODULE).

add_channel(OE_THIS, OE_Options, Channel) ->
    corba:call(OE_THIS, add_channel, [Channel], ?MODULE, OE_Options).

%%%% Operation: get_all_channels
%% 
%%   Returns: RetVal
%%
get_all_channels(OE_THIS) ->
    corba:call(OE_THIS, get_all_channels, [], ?MODULE).

get_all_channels(OE_THIS, OE_Options) ->
    corba:call(OE_THIS, get_all_channels, [], ?MODULE, OE_Options).

%%%% Operation: get_channel
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
get_channel(OE_THIS, Channel) ->
    corba:call(OE_THIS, get_channel, [Channel], ?MODULE).

get_channel(OE_THIS, OE_Options, Channel) ->
    corba:call(OE_THIS, get_channel, [Channel], ?MODULE, OE_Options).

%%%% Operation: remove_channel
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
remove_channel(OE_THIS, Channel) ->
    corba:call(OE_THIS, remove_channel, [Channel], ?MODULE).

remove_channel(OE_THIS, OE_Options, Channel) ->
    corba:call(OE_THIS, remove_channel, [Channel], ?MODULE, OE_Options).

%%%% Operation: add_connection
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound, CosEventChannelAdmin::TypeError, CosEventDomainAdmin::AlreadyExists, CosEventDomainAdmin::CycleCreationForbidden, CosEventDomainAdmin::DiamondCreationForbidden
%%
add_connection(OE_THIS, Connection) ->
    corba:call(OE_THIS, add_connection, [Connection], ?MODULE).

add_connection(OE_THIS, OE_Options, Connection) ->
    corba:call(OE_THIS, add_connection, [Connection], ?MODULE, OE_Options).

%%%% Operation: get_all_connections
%% 
%%   Returns: RetVal
%%
get_all_connections(OE_THIS) ->
    corba:call(OE_THIS, get_all_connections, [], ?MODULE).

get_all_connections(OE_THIS, OE_Options) ->
    corba:call(OE_THIS, get_all_connections, [], ?MODULE, OE_Options).

%%%% Operation: get_connection
%% 
%%   Returns: RetVal
%%   Raises:  CosEventDomainAdmin::ConnectionNotFound
%%
get_connection(OE_THIS, Connection) ->
    corba:call(OE_THIS, get_connection, [Connection], ?MODULE).

get_connection(OE_THIS, OE_Options, Connection) ->
    corba:call(OE_THIS, get_connection, [Connection], ?MODULE, OE_Options).

%%%% Operation: remove_connection
%% 
%%   Returns: RetVal
%%   Raises:  CosEventDomainAdmin::ConnectionNotFound
%%
remove_connection(OE_THIS, Connection) ->
    corba:call(OE_THIS, remove_connection, [Connection], ?MODULE).

remove_connection(OE_THIS, OE_Options, Connection) ->
    corba:call(OE_THIS, remove_connection, [Connection], ?MODULE, OE_Options).

%%%% Operation: get_offer_channels
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
get_offer_channels(OE_THIS, Channel) ->
    corba:call(OE_THIS, get_offer_channels, [Channel], ?MODULE).

get_offer_channels(OE_THIS, OE_Options, Channel) ->
    corba:call(OE_THIS, get_offer_channels, [Channel], ?MODULE, OE_Options).

%%%% Operation: get_subscription_channels
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
get_subscription_channels(OE_THIS, Channel) ->
    corba:call(OE_THIS, get_subscription_channels, [Channel], ?MODULE).

get_subscription_channels(OE_THIS, OE_Options, Channel) ->
    corba:call(OE_THIS, get_subscription_channels, [Channel], ?MODULE, OE_Options).

%%%% Operation: destroy
%% 
%%   Returns: RetVal
%%
destroy(OE_THIS) ->
    corba:call(OE_THIS, destroy, [], ?MODULE).

destroy(OE_THIS, OE_Options) ->
    corba:call(OE_THIS, destroy, [], ?MODULE, OE_Options).

%%%% Operation: get_cycles
%% 
%%   Returns: RetVal
%%
get_cycles(OE_THIS) ->
    corba:call(OE_THIS, get_cycles, [], ?MODULE).

get_cycles(OE_THIS, OE_Options) ->
    corba:call(OE_THIS, get_cycles, [], ?MODULE, OE_Options).

%%%% Operation: get_diamonds
%% 
%%   Returns: RetVal
%%
get_diamonds(OE_THIS) ->
    corba:call(OE_THIS, get_diamonds, [], ?MODULE).

get_diamonds(OE_THIS, OE_Options) ->
    corba:call(OE_THIS, get_diamonds, [], ?MODULE, OE_Options).

%%%% Operation: set_default_consumer_channel
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
set_default_consumer_channel(OE_THIS, Channel) ->
    corba:call(OE_THIS, set_default_consumer_channel, [Channel], ?MODULE).

set_default_consumer_channel(OE_THIS, OE_Options, Channel) ->
    corba:call(OE_THIS, set_default_consumer_channel, [Channel], ?MODULE, OE_Options).

%%%% Operation: set_default_supplier_channel
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
set_default_supplier_channel(OE_THIS, Channel) ->
    corba:call(OE_THIS, set_default_supplier_channel, [Channel], ?MODULE).

set_default_supplier_channel(OE_THIS, OE_Options, Channel) ->
    corba:call(OE_THIS, set_default_supplier_channel, [Channel], ?MODULE, OE_Options).

%%%% Operation: connect_push_consumer
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_push_consumer(OE_THIS, Client) ->
    corba:call(OE_THIS, connect_push_consumer, [Client], ?MODULE).

connect_push_consumer(OE_THIS, OE_Options, Client) ->
    corba:call(OE_THIS, connect_push_consumer, [Client], ?MODULE, OE_Options).

%%%% Operation: connect_pull_consumer
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_pull_consumer(OE_THIS, Client) ->
    corba:call(OE_THIS, connect_pull_consumer, [Client], ?MODULE).

connect_pull_consumer(OE_THIS, OE_Options, Client) ->
    corba:call(OE_THIS, connect_pull_consumer, [Client], ?MODULE, OE_Options).

%%%% Operation: connect_push_supplier
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_push_supplier(OE_THIS, Client) ->
    corba:call(OE_THIS, connect_push_supplier, [Client], ?MODULE).

connect_push_supplier(OE_THIS, OE_Options, Client) ->
    corba:call(OE_THIS, connect_push_supplier, [Client], ?MODULE, OE_Options).

%%%% Operation: connect_pull_supplier
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_pull_supplier(OE_THIS, Client) ->
    corba:call(OE_THIS, connect_pull_supplier, [Client], ?MODULE).

connect_pull_supplier(OE_THIS, OE_Options, Client) ->
    corba:call(OE_THIS, connect_pull_supplier, [Client], ?MODULE, OE_Options).

%%%% Operation: connect_structured_push_consumer
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_structured_push_consumer(OE_THIS, Client) ->
    corba:call(OE_THIS, connect_structured_push_consumer, [Client], ?MODULE).

connect_structured_push_consumer(OE_THIS, OE_Options, Client) ->
    corba:call(OE_THIS, connect_structured_push_consumer, [Client], ?MODULE, OE_Options).

%%%% Operation: connect_structured_pull_consumer
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_structured_pull_consumer(OE_THIS, Client) ->
    corba:call(OE_THIS, connect_structured_pull_consumer, [Client], ?MODULE).

connect_structured_pull_consumer(OE_THIS, OE_Options, Client) ->
    corba:call(OE_THIS, connect_structured_pull_consumer, [Client], ?MODULE, OE_Options).

%%%% Operation: connect_structured_push_supplier
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_structured_push_supplier(OE_THIS, Client) ->
    corba:call(OE_THIS, connect_structured_push_supplier, [Client], ?MODULE).

connect_structured_push_supplier(OE_THIS, OE_Options, Client) ->
    corba:call(OE_THIS, connect_structured_push_supplier, [Client], ?MODULE, OE_Options).

%%%% Operation: connect_structured_pull_supplier
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_structured_pull_supplier(OE_THIS, Client) ->
    corba:call(OE_THIS, connect_structured_pull_supplier, [Client], ?MODULE).

connect_structured_pull_supplier(OE_THIS, OE_Options, Client) ->
    corba:call(OE_THIS, connect_structured_pull_supplier, [Client], ?MODULE, OE_Options).

%%%% Operation: connect_sequence_push_consumer
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_sequence_push_consumer(OE_THIS, Client) ->
    corba:call(OE_THIS, connect_sequence_push_consumer, [Client], ?MODULE).

connect_sequence_push_consumer(OE_THIS, OE_Options, Client) ->
    corba:call(OE_THIS, connect_sequence_push_consumer, [Client], ?MODULE, OE_Options).

%%%% Operation: connect_sequence_pull_consumer
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_sequence_pull_consumer(OE_THIS, Client) ->
    corba:call(OE_THIS, connect_sequence_pull_consumer, [Client], ?MODULE).

connect_sequence_pull_consumer(OE_THIS, OE_Options, Client) ->
    corba:call(OE_THIS, connect_sequence_pull_consumer, [Client], ?MODULE, OE_Options).

%%%% Operation: connect_sequence_push_supplier
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_sequence_push_supplier(OE_THIS, Client) ->
    corba:call(OE_THIS, connect_sequence_push_supplier, [Client], ?MODULE).

connect_sequence_push_supplier(OE_THIS, OE_Options, Client) ->
    corba:call(OE_THIS, connect_sequence_push_supplier, [Client], ?MODULE, OE_Options).

%%%% Operation: connect_sequence_pull_supplier
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_sequence_pull_supplier(OE_THIS, Client) ->
    corba:call(OE_THIS, connect_sequence_pull_supplier, [Client], ?MODULE).

connect_sequence_pull_supplier(OE_THIS, OE_Options, Client) ->
    corba:call(OE_THIS, connect_sequence_pull_supplier, [Client], ?MODULE, OE_Options).

%%%% Operation: connect_push_consumer_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_push_consumer_with_id(OE_THIS, Client, Channel) ->
    corba:call(OE_THIS, connect_push_consumer_with_id, [Client, Channel], ?MODULE).

connect_push_consumer_with_id(OE_THIS, OE_Options, Client, Channel) ->
    corba:call(OE_THIS, connect_push_consumer_with_id, [Client, Channel], ?MODULE, OE_Options).

%%%% Operation: connect_pull_consumer_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_pull_consumer_with_id(OE_THIS, Client, Channel) ->
    corba:call(OE_THIS, connect_pull_consumer_with_id, [Client, Channel], ?MODULE).

connect_pull_consumer_with_id(OE_THIS, OE_Options, Client, Channel) ->
    corba:call(OE_THIS, connect_pull_consumer_with_id, [Client, Channel], ?MODULE, OE_Options).

%%%% Operation: connect_push_supplier_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_push_supplier_with_id(OE_THIS, Client, Channel) ->
    corba:call(OE_THIS, connect_push_supplier_with_id, [Client, Channel], ?MODULE).

connect_push_supplier_with_id(OE_THIS, OE_Options, Client, Channel) ->
    corba:call(OE_THIS, connect_push_supplier_with_id, [Client, Channel], ?MODULE, OE_Options).

%%%% Operation: connect_pull_supplier_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_pull_supplier_with_id(OE_THIS, Client, Channel) ->
    corba:call(OE_THIS, connect_pull_supplier_with_id, [Client, Channel], ?MODULE).

connect_pull_supplier_with_id(OE_THIS, OE_Options, Client, Channel) ->
    corba:call(OE_THIS, connect_pull_supplier_with_id, [Client, Channel], ?MODULE, OE_Options).

%%%% Operation: connect_structured_push_consumer_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_structured_push_consumer_with_id(OE_THIS, Client, Channel) ->
    corba:call(OE_THIS, connect_structured_push_consumer_with_id, [Client, Channel], ?MODULE).

connect_structured_push_consumer_with_id(OE_THIS, OE_Options, Client, Channel) ->
    corba:call(OE_THIS, connect_structured_push_consumer_with_id, [Client, Channel], ?MODULE, OE_Options).

%%%% Operation: connect_structured_pull_consumer_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_structured_pull_consumer_with_id(OE_THIS, Client, Channel) ->
    corba:call(OE_THIS, connect_structured_pull_consumer_with_id, [Client, Channel], ?MODULE).

connect_structured_pull_consumer_with_id(OE_THIS, OE_Options, Client, Channel) ->
    corba:call(OE_THIS, connect_structured_pull_consumer_with_id, [Client, Channel], ?MODULE, OE_Options).

%%%% Operation: connect_structured_push_supplier_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_structured_push_supplier_with_id(OE_THIS, Client, Channel) ->
    corba:call(OE_THIS, connect_structured_push_supplier_with_id, [Client, Channel], ?MODULE).

connect_structured_push_supplier_with_id(OE_THIS, OE_Options, Client, Channel) ->
    corba:call(OE_THIS, connect_structured_push_supplier_with_id, [Client, Channel], ?MODULE, OE_Options).

%%%% Operation: connect_structured_pull_supplier_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_structured_pull_supplier_with_id(OE_THIS, Client, Channel) ->
    corba:call(OE_THIS, connect_structured_pull_supplier_with_id, [Client, Channel], ?MODULE).

connect_structured_pull_supplier_with_id(OE_THIS, OE_Options, Client, Channel) ->
    corba:call(OE_THIS, connect_structured_pull_supplier_with_id, [Client, Channel], ?MODULE, OE_Options).

%%%% Operation: connect_sequence_push_consumer_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_sequence_push_consumer_with_id(OE_THIS, Client, Channel) ->
    corba:call(OE_THIS, connect_sequence_push_consumer_with_id, [Client, Channel], ?MODULE).

connect_sequence_push_consumer_with_id(OE_THIS, OE_Options, Client, Channel) ->
    corba:call(OE_THIS, connect_sequence_push_consumer_with_id, [Client, Channel], ?MODULE, OE_Options).

%%%% Operation: connect_sequence_pull_consumer_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_sequence_pull_consumer_with_id(OE_THIS, Client, Channel) ->
    corba:call(OE_THIS, connect_sequence_pull_consumer_with_id, [Client, Channel], ?MODULE).

connect_sequence_pull_consumer_with_id(OE_THIS, OE_Options, Client, Channel) ->
    corba:call(OE_THIS, connect_sequence_pull_consumer_with_id, [Client, Channel], ?MODULE, OE_Options).

%%%% Operation: connect_sequence_push_supplier_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_sequence_push_supplier_with_id(OE_THIS, Client, Channel) ->
    corba:call(OE_THIS, connect_sequence_push_supplier_with_id, [Client, Channel], ?MODULE).

connect_sequence_push_supplier_with_id(OE_THIS, OE_Options, Client, Channel) ->
    corba:call(OE_THIS, connect_sequence_push_supplier_with_id, [Client, Channel], ?MODULE, OE_Options).

%%%% Operation: connect_sequence_pull_supplier_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
connect_sequence_pull_supplier_with_id(OE_THIS, Client, Channel) ->
    corba:call(OE_THIS, connect_sequence_pull_supplier_with_id, [Client, Channel], ?MODULE).

connect_sequence_pull_supplier_with_id(OE_THIS, OE_Options, Client, Channel) ->
    corba:call(OE_THIS, connect_sequence_pull_supplier_with_id, [Client, Channel], ?MODULE, OE_Options).

%%%% Operation: get_qos
%% 
%%   Returns: RetVal
%%
get_qos(OE_THIS) ->
    corba:call(OE_THIS, get_qos, [], ?MODULE).

get_qos(OE_THIS, OE_Options) ->
    corba:call(OE_THIS, get_qos, [], ?MODULE, OE_Options).

%%%% Operation: set_qos
%% 
%%   Returns: RetVal
%%   Raises:  CosNotification::UnsupportedQoS
%%
set_qos(OE_THIS, Qos) ->
    corba:call(OE_THIS, set_qos, [Qos], ?MODULE).

set_qos(OE_THIS, OE_Options, Qos) ->
    corba:call(OE_THIS, set_qos, [Qos], ?MODULE, OE_Options).

%%%% Operation: validate_qos
%% 
%%   Returns: RetVal, Available_qos
%%   Raises:  CosNotification::UnsupportedQoS
%%
validate_qos(OE_THIS, Required_qos) ->
    corba:call(OE_THIS, validate_qos, [Required_qos], ?MODULE).

validate_qos(OE_THIS, OE_Options, Required_qos) ->
    corba:call(OE_THIS, validate_qos, [Required_qos], ?MODULE, OE_Options).

%%%% Operation: get_admin
%% 
%%   Returns: RetVal
%%
get_admin(OE_THIS) ->
    corba:call(OE_THIS, get_admin, [], ?MODULE).

get_admin(OE_THIS, OE_Options) ->
    corba:call(OE_THIS, get_admin, [], ?MODULE, OE_Options).

%%%% Operation: set_admin
%% 
%%   Returns: RetVal
%%   Raises:  CosNotification::UnsupportedAdmin
%%
set_admin(OE_THIS, Admin) ->
    corba:call(OE_THIS, set_admin, [Admin], ?MODULE).

set_admin(OE_THIS, OE_Options, Admin) ->
    corba:call(OE_THIS, set_admin, [Admin], ?MODULE, OE_Options).

%%------------------------------------------------------------
%%
%% Inherited Interfaces
%%
%%------------------------------------------------------------
oe_is_a("IDL:omg.org/CosEventDomainAdmin/EventDomain:1.0") -> true;
oe_is_a("IDL:omg.org/CosNotification/QoSAdmin:1.0") -> true;
oe_is_a("IDL:omg.org/CosNotification/AdminPropertiesAdmin:1.0") -> true;
oe_is_a(_) -> false.

%%------------------------------------------------------------
%%
%% Interface TypeCode
%%
%%------------------------------------------------------------
oe_tc(add_channel) -> 
	{tk_long,[{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/EventChannel:1.0",
                             "EventChannel"}],
                 []};
oe_tc(get_all_channels) -> 
	{{tk_sequence,tk_long,0},[],[]};
oe_tc(get_channel) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/EventChannel:1.0",
                    "EventChannel"},
         [tk_long],
         []};
oe_tc(remove_channel) -> 
	{tk_void,[tk_long],[]};
oe_tc(add_connection) -> 
	{tk_long,
            [{tk_struct,"IDL:omg.org/CosEventDomainAdmin/Connection:1.0",
                 "Connection",
                 [{"supplier_id",tk_long},
                  {"consumer_id",tk_long},
                  {"ctype",
                   {tk_enum,
                       "IDL:omg.org/CosNotifyChannelAdmin/ClientType:1.0",
                       "ClientType",
                       ["ANY_EVENT","STRUCTURED_EVENT","SEQUENCE_EVENT"]}},
                  {"notification_style",
                   {tk_enum,
                       "IDL:omg.org/CosEventDomainAdmin/NotificationStyle:1.0",
                       "NotificationStyle",
                       ["Push","Pull"]}}]}],
            []};
oe_tc(get_all_connections) -> 
	{{tk_sequence,tk_long,0},[],[]};
oe_tc(get_connection) -> 
	{{tk_struct,"IDL:omg.org/CosEventDomainAdmin/Connection:1.0",
                    "Connection",
                    [{"supplier_id",tk_long},
                     {"consumer_id",tk_long},
                     {"ctype",
                      {tk_enum,"IDL:omg.org/CosNotifyChannelAdmin/ClientType:1.0",
                               "ClientType",
                               ["ANY_EVENT","STRUCTURED_EVENT",
                                "SEQUENCE_EVENT"]}},
                     {"notification_style",
                      {tk_enum,"IDL:omg.org/CosEventDomainAdmin/NotificationStyle:1.0",
                               "NotificationStyle",
                               ["Push","Pull"]}}]},
         [tk_long],
         []};
oe_tc(remove_connection) -> 
	{tk_void,[tk_long],[]};
oe_tc(get_offer_channels) -> 
	{{tk_sequence,tk_long,0},[tk_long],[]};
oe_tc(get_subscription_channels) -> 
	{{tk_sequence,tk_long,0},[tk_long],[]};
oe_tc(destroy) -> 
	{tk_void,[],[]};
oe_tc(get_cycles) -> 
	{{tk_sequence,{tk_sequence,tk_long,0},0},[],[]};
oe_tc(get_diamonds) -> 
	{{tk_sequence,{tk_sequence,{tk_sequence,tk_long,0},0},0},[],[]};
oe_tc(set_default_consumer_channel) -> 
	{tk_void,[tk_long],[]};
oe_tc(set_default_supplier_channel) -> 
	{tk_void,[tk_long],[]};
oe_tc(connect_push_consumer) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/ProxyPushSupplier:1.0",
                    "ProxyPushSupplier"},
         [{tk_objref,"IDL:omg.org/CosEventComm/PushConsumer:1.0",
                     "PushConsumer"}],
         []};
oe_tc(connect_pull_consumer) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/ProxyPullSupplier:1.0",
                    "ProxyPullSupplier"},
         [{tk_objref,"IDL:omg.org/CosEventComm/PullConsumer:1.0",
                     "PullConsumer"}],
         []};
oe_tc(connect_push_supplier) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/ProxyPushConsumer:1.0",
                    "ProxyPushConsumer"},
         [{tk_objref,"IDL:omg.org/CosEventComm/PushSupplier:1.0",
                     "PushSupplier"}],
         []};
oe_tc(connect_pull_supplier) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/ProxyPullConsumer:1.0",
                    "ProxyPullConsumer"},
         [{tk_objref,"IDL:omg.org/CosEventComm/PullSupplier:1.0",
                     "PullSupplier"}],
         []};
oe_tc(connect_structured_push_consumer) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/StructuredProxyPushSupplier:1.0",
                    "StructuredProxyPushSupplier"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/StructuredPushConsumer:1.0",
                     "StructuredPushConsumer"}],
         []};
oe_tc(connect_structured_pull_consumer) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/StructuredProxyPullSupplier:1.0",
                    "StructuredProxyPullSupplier"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/StructuredPullConsumer:1.0",
                     "StructuredPullConsumer"}],
         []};
oe_tc(connect_structured_push_supplier) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/StructuredProxyPushConsumer:1.0",
                    "StructuredProxyPushConsumer"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/StructuredPushSupplier:1.0",
                     "StructuredPushSupplier"}],
         []};
oe_tc(connect_structured_pull_supplier) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/StructuredProxyPullConsumer:1.0",
                    "StructuredProxyPullConsumer"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/StructuredPullSupplier:1.0",
                     "StructuredPullSupplier"}],
         []};
oe_tc(connect_sequence_push_consumer) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/SequenceProxyPushSupplier:1.0",
                    "SequenceProxyPushSupplier"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/SequencePushConsumer:1.0",
                     "SequencePushConsumer"}],
         []};
oe_tc(connect_sequence_pull_consumer) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/SequenceProxyPullSupplier:1.0",
                    "SequenceProxyPullSupplier"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/SequencePullConsumer:1.0",
                     "SequencePullConsumer"}],
         []};
oe_tc(connect_sequence_push_supplier) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/SequenceProxyPushConsumer:1.0",
                    "SequenceProxyPushConsumer"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/SequencePushSupplier:1.0",
                     "SequencePushSupplier"}],
         []};
oe_tc(connect_sequence_pull_supplier) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/SequenceProxyPullConsumer:1.0",
                    "SequenceProxyPullConsumer"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/SequencePullSupplier:1.0",
                     "SequencePullSupplier"}],
         []};
oe_tc(connect_push_consumer_with_id) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/ProxyPushSupplier:1.0",
                    "ProxyPushSupplier"},
         [{tk_objref,"IDL:omg.org/CosEventComm/PushConsumer:1.0",
                     "PushConsumer"},
          tk_long],
         []};
oe_tc(connect_pull_consumer_with_id) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/ProxyPullSupplier:1.0",
                    "ProxyPullSupplier"},
         [{tk_objref,"IDL:omg.org/CosEventComm/PullConsumer:1.0",
                     "PullConsumer"},
          tk_long],
         []};
oe_tc(connect_push_supplier_with_id) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/ProxyPushConsumer:1.0",
                    "ProxyPushConsumer"},
         [{tk_objref,"IDL:omg.org/CosEventComm/PushSupplier:1.0",
                     "PushSupplier"},
          tk_long],
         []};
oe_tc(connect_pull_supplier_with_id) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/ProxyPullConsumer:1.0",
                    "ProxyPullConsumer"},
         [{tk_objref,"IDL:omg.org/CosEventComm/PullSupplier:1.0",
                     "PullSupplier"},
          tk_long],
         []};
oe_tc(connect_structured_push_consumer_with_id) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/StructuredProxyPushSupplier:1.0",
                    "StructuredProxyPushSupplier"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/StructuredPushConsumer:1.0",
                     "StructuredPushConsumer"},
          tk_long],
         []};
oe_tc(connect_structured_pull_consumer_with_id) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/StructuredProxyPullSupplier:1.0",
                    "StructuredProxyPullSupplier"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/StructuredPullConsumer:1.0",
                     "StructuredPullConsumer"},
          tk_long],
         []};
oe_tc(connect_structured_push_supplier_with_id) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/StructuredProxyPushConsumer:1.0",
                    "StructuredProxyPushConsumer"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/StructuredPushSupplier:1.0",
                     "StructuredPushSupplier"},
          tk_long],
         []};
oe_tc(connect_structured_pull_supplier_with_id) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/StructuredProxyPullConsumer:1.0",
                    "StructuredProxyPullConsumer"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/StructuredPullSupplier:1.0",
                     "StructuredPullSupplier"},
          tk_long],
         []};
oe_tc(connect_sequence_push_consumer_with_id) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/SequenceProxyPushSupplier:1.0",
                    "SequenceProxyPushSupplier"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/SequencePushConsumer:1.0",
                     "SequencePushConsumer"},
          tk_long],
         []};
oe_tc(connect_sequence_pull_consumer_with_id) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/SequenceProxyPullSupplier:1.0",
                    "SequenceProxyPullSupplier"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/SequencePullConsumer:1.0",
                     "SequencePullConsumer"},
          tk_long],
         []};
oe_tc(connect_sequence_push_supplier_with_id) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/SequenceProxyPushConsumer:1.0",
                    "SequenceProxyPushConsumer"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/SequencePushSupplier:1.0",
                     "SequencePushSupplier"},
          tk_long],
         []};
oe_tc(connect_sequence_pull_supplier_with_id) -> 
	{{tk_objref,"IDL:omg.org/CosNotifyChannelAdmin/SequenceProxyPullConsumer:1.0",
                    "SequenceProxyPullConsumer"},
         [{tk_objref,"IDL:omg.org/CosNotifyComm/SequencePullSupplier:1.0",
                     "SequencePullSupplier"},
          tk_long],
         []};
oe_tc(get_qos) -> 'CosNotification_QoSAdmin':oe_tc(get_qos);
oe_tc(set_qos) -> 'CosNotification_QoSAdmin':oe_tc(set_qos);
oe_tc(validate_qos) -> 'CosNotification_QoSAdmin':oe_tc(validate_qos);
oe_tc(get_admin) -> 'CosNotification_AdminPropertiesAdmin':oe_tc(get_admin);
oe_tc(set_admin) -> 'CosNotification_AdminPropertiesAdmin':oe_tc(set_admin);
oe_tc(_) -> undefined.

oe_get_interface() -> 
	[{"set_admin", 'CosNotification_AdminPropertiesAdmin':oe_tc(set_admin)},
	{"get_admin", 'CosNotification_AdminPropertiesAdmin':oe_tc(get_admin)},
	{"validate_qos", 'CosNotification_QoSAdmin':oe_tc(validate_qos)},
	{"set_qos", 'CosNotification_QoSAdmin':oe_tc(set_qos)},
	{"get_qos", 'CosNotification_QoSAdmin':oe_tc(get_qos)},
	{"connect_sequence_pull_supplier_with_id", oe_tc(connect_sequence_pull_supplier_with_id)},
	{"connect_sequence_push_supplier_with_id", oe_tc(connect_sequence_push_supplier_with_id)},
	{"connect_sequence_pull_consumer_with_id", oe_tc(connect_sequence_pull_consumer_with_id)},
	{"connect_sequence_push_consumer_with_id", oe_tc(connect_sequence_push_consumer_with_id)},
	{"connect_structured_pull_supplier_with_id", oe_tc(connect_structured_pull_supplier_with_id)},
	{"connect_structured_push_supplier_with_id", oe_tc(connect_structured_push_supplier_with_id)},
	{"connect_structured_pull_consumer_with_id", oe_tc(connect_structured_pull_consumer_with_id)},
	{"connect_structured_push_consumer_with_id", oe_tc(connect_structured_push_consumer_with_id)},
	{"connect_pull_supplier_with_id", oe_tc(connect_pull_supplier_with_id)},
	{"connect_push_supplier_with_id", oe_tc(connect_push_supplier_with_id)},
	{"connect_pull_consumer_with_id", oe_tc(connect_pull_consumer_with_id)},
	{"connect_push_consumer_with_id", oe_tc(connect_push_consumer_with_id)},
	{"connect_sequence_pull_supplier", oe_tc(connect_sequence_pull_supplier)},
	{"connect_sequence_push_supplier", oe_tc(connect_sequence_push_supplier)},
	{"connect_sequence_pull_consumer", oe_tc(connect_sequence_pull_consumer)},
	{"connect_sequence_push_consumer", oe_tc(connect_sequence_push_consumer)},
	{"connect_structured_pull_supplier", oe_tc(connect_structured_pull_supplier)},
	{"connect_structured_push_supplier", oe_tc(connect_structured_push_supplier)},
	{"connect_structured_pull_consumer", oe_tc(connect_structured_pull_consumer)},
	{"connect_structured_push_consumer", oe_tc(connect_structured_push_consumer)},
	{"connect_pull_supplier", oe_tc(connect_pull_supplier)},
	{"connect_push_supplier", oe_tc(connect_push_supplier)},
	{"connect_pull_consumer", oe_tc(connect_pull_consumer)},
	{"connect_push_consumer", oe_tc(connect_push_consumer)},
	{"set_default_supplier_channel", oe_tc(set_default_supplier_channel)},
	{"set_default_consumer_channel", oe_tc(set_default_consumer_channel)},
	{"get_diamonds", oe_tc(get_diamonds)},
	{"get_cycles", oe_tc(get_cycles)},
	{"destroy", oe_tc(destroy)},
	{"get_subscription_channels", oe_tc(get_subscription_channels)},
	{"get_offer_channels", oe_tc(get_offer_channels)},
	{"remove_connection", oe_tc(remove_connection)},
	{"get_connection", oe_tc(get_connection)},
	{"get_all_connections", oe_tc(get_all_connections)},
	{"add_connection", oe_tc(add_connection)},
	{"remove_channel", oe_tc(remove_channel)},
	{"get_channel", oe_tc(get_channel)},
	{"get_all_channels", oe_tc(get_all_channels)},
	{"add_channel", oe_tc(add_channel)}].




%%------------------------------------------------------------
%%
%% Object server implementation.
%%
%%------------------------------------------------------------


%%------------------------------------------------------------
%%
%% Function for fetching the interface type ID.
%%
%%------------------------------------------------------------

typeID() ->
    "IDL:omg.org/CosEventDomainAdmin/EventDomain:1.0".


%%------------------------------------------------------------
%%
%% Object creation functions.
%%
%%------------------------------------------------------------

oe_create() ->
    corba:create(?MODULE, "IDL:omg.org/CosEventDomainAdmin/EventDomain:1.0").

oe_create_link() ->
    corba:create_link(?MODULE, "IDL:omg.org/CosEventDomainAdmin/EventDomain:1.0").

oe_create(Env) ->
    corba:create(?MODULE, "IDL:omg.org/CosEventDomainAdmin/EventDomain:1.0", Env).

oe_create_link(Env) ->
    corba:create_link(?MODULE, "IDL:omg.org/CosEventDomainAdmin/EventDomain:1.0", Env).

oe_create(Env, RegName) ->
    corba:create(?MODULE, "IDL:omg.org/CosEventDomainAdmin/EventDomain:1.0", Env, RegName).

oe_create_link(Env, RegName) ->
    corba:create_link(?MODULE, "IDL:omg.org/CosEventDomainAdmin/EventDomain:1.0", Env, RegName).

%%------------------------------------------------------------
%%
%% Init & terminate functions.
%%
%%------------------------------------------------------------

init(Env) ->
%% Call to implementation init
    corba:handle_init('CosEventDomainAdmin_EventDomain_impl', Env).

terminate(Reason, State) ->
    corba:handle_terminate('CosEventDomainAdmin_EventDomain_impl', Reason, State).


%%%% Operation: add_channel
%% 
%%   Returns: RetVal
%%
handle_call({OE_THIS, OE_Context, add_channel, [Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', add_channel, [Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: get_all_channels
%% 
%%   Returns: RetVal
%%
handle_call({OE_THIS, OE_Context, get_all_channels, []}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', get_all_channels, [], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: get_channel
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, get_channel, [Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', get_channel, [Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: remove_channel
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, remove_channel, [Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', remove_channel, [Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: add_connection
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound, CosEventChannelAdmin::TypeError, CosEventDomainAdmin::AlreadyExists, CosEventDomainAdmin::CycleCreationForbidden, CosEventDomainAdmin::DiamondCreationForbidden
%%
handle_call({OE_THIS, OE_Context, add_connection, [Connection]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', add_connection, [Connection], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: get_all_connections
%% 
%%   Returns: RetVal
%%
handle_call({OE_THIS, OE_Context, get_all_connections, []}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', get_all_connections, [], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: get_connection
%% 
%%   Returns: RetVal
%%   Raises:  CosEventDomainAdmin::ConnectionNotFound
%%
handle_call({OE_THIS, OE_Context, get_connection, [Connection]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', get_connection, [Connection], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: remove_connection
%% 
%%   Returns: RetVal
%%   Raises:  CosEventDomainAdmin::ConnectionNotFound
%%
handle_call({OE_THIS, OE_Context, remove_connection, [Connection]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', remove_connection, [Connection], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: get_offer_channels
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, get_offer_channels, [Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', get_offer_channels, [Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: get_subscription_channels
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, get_subscription_channels, [Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', get_subscription_channels, [Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: destroy
%% 
%%   Returns: RetVal
%%
handle_call({OE_THIS, OE_Context, destroy, []}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', destroy, [], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: get_cycles
%% 
%%   Returns: RetVal
%%
handle_call({OE_THIS, OE_Context, get_cycles, []}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', get_cycles, [], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: get_diamonds
%% 
%%   Returns: RetVal
%%
handle_call({OE_THIS, OE_Context, get_diamonds, []}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', get_diamonds, [], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: set_default_consumer_channel
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, set_default_consumer_channel, [Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', set_default_consumer_channel, [Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: set_default_supplier_channel
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, set_default_supplier_channel, [Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', set_default_supplier_channel, [Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_push_consumer
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_push_consumer, [Client]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_push_consumer, [Client], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_pull_consumer
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_pull_consumer, [Client]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_pull_consumer, [Client], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_push_supplier
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_push_supplier, [Client]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_push_supplier, [Client], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_pull_supplier
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_pull_supplier, [Client]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_pull_supplier, [Client], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_structured_push_consumer
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_structured_push_consumer, [Client]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_structured_push_consumer, [Client], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_structured_pull_consumer
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_structured_pull_consumer, [Client]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_structured_pull_consumer, [Client], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_structured_push_supplier
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_structured_push_supplier, [Client]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_structured_push_supplier, [Client], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_structured_pull_supplier
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_structured_pull_supplier, [Client]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_structured_pull_supplier, [Client], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_sequence_push_consumer
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_sequence_push_consumer, [Client]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_sequence_push_consumer, [Client], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_sequence_pull_consumer
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_sequence_pull_consumer, [Client]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_sequence_pull_consumer, [Client], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_sequence_push_supplier
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_sequence_push_supplier, [Client]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_sequence_push_supplier, [Client], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_sequence_pull_supplier
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_sequence_pull_supplier, [Client]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_sequence_pull_supplier, [Client], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_push_consumer_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_push_consumer_with_id, [Client, Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_push_consumer_with_id, [Client, Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_pull_consumer_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_pull_consumer_with_id, [Client, Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_pull_consumer_with_id, [Client, Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_push_supplier_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_push_supplier_with_id, [Client, Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_push_supplier_with_id, [Client, Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_pull_supplier_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_pull_supplier_with_id, [Client, Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_pull_supplier_with_id, [Client, Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_structured_push_consumer_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_structured_push_consumer_with_id, [Client, Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_structured_push_consumer_with_id, [Client, Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_structured_pull_consumer_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_structured_pull_consumer_with_id, [Client, Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_structured_pull_consumer_with_id, [Client, Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_structured_push_supplier_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_structured_push_supplier_with_id, [Client, Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_structured_push_supplier_with_id, [Client, Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_structured_pull_supplier_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_structured_pull_supplier_with_id, [Client, Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_structured_pull_supplier_with_id, [Client, Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_sequence_push_consumer_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_sequence_push_consumer_with_id, [Client, Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_sequence_push_consumer_with_id, [Client, Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_sequence_pull_consumer_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_sequence_pull_consumer_with_id, [Client, Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_sequence_pull_consumer_with_id, [Client, Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_sequence_push_supplier_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_sequence_push_supplier_with_id, [Client, Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_sequence_push_supplier_with_id, [Client, Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: connect_sequence_pull_supplier_with_id
%% 
%%   Returns: RetVal
%%   Raises:  CosNotifyChannelAdmin::ChannelNotFound
%%
handle_call({OE_THIS, OE_Context, connect_sequence_pull_supplier_with_id, [Client, Channel]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', connect_sequence_pull_supplier_with_id, [Client, Channel], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: get_qos
%% 
%%   Returns: RetVal
%%
handle_call({OE_THIS, OE_Context, get_qos, []}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', get_qos, [], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: set_qos
%% 
%%   Returns: RetVal
%%   Raises:  CosNotification::UnsupportedQoS
%%
handle_call({OE_THIS, OE_Context, set_qos, [Qos]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', set_qos, [Qos], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: validate_qos
%% 
%%   Returns: RetVal, Available_qos
%%   Raises:  CosNotification::UnsupportedQoS
%%
handle_call({OE_THIS, OE_Context, validate_qos, [Required_qos]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', validate_qos, [Required_qos], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: get_admin
%% 
%%   Returns: RetVal
%%
handle_call({OE_THIS, OE_Context, get_admin, []}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', get_admin, [], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: set_admin
%% 
%%   Returns: RetVal
%%   Raises:  CosNotification::UnsupportedAdmin
%%
handle_call({OE_THIS, OE_Context, set_admin, [Admin]}, _, OE_State) ->
  corba:handle_call('CosEventDomainAdmin_EventDomain_impl', set_admin, [Admin], OE_State, OE_Context, OE_THIS, false);



%%%% Standard gen_server call handle
%%
handle_call(stop, _, State) ->
    {stop, normal, ok, State};

handle_call(_, _, State) ->
    {reply, catch corba:raise(#'BAD_OPERATION'{minor=1163001857, completion_status='COMPLETED_NO'}), State}.


%%%% Standard gen_server cast handle
%%
handle_cast(stop, State) ->
    {stop, normal, State};

handle_cast(_, State) ->
    {noreply, State}.


%%%% Standard gen_server handles
%%
handle_info(Info, State) ->
    corba:handle_info('CosEventDomainAdmin_EventDomain_impl', Info, State).


code_change(OldVsn, State, Extra) ->
    corba:handle_code_change('CosEventDomainAdmin_EventDomain_impl', OldVsn, State, Extra).

