/* ethos-ui-configurable.h
 *
 * Copyright (C) 2009 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#ifndef __ETHOS_UI_CONFIGURABLE_H__
#define __ETHOS_UI_CONFIGURABLE_H__

#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define ETHOS_UI_TYPE_CONFIGURABLE (ethos_ui_configurable_get_type())

#define ETHOS_UI_CONFIGURABLE(obj)		\
	(G_TYPE_CHECK_INSTANCE_CAST((obj),	\
	 ETHOS_UI_TYPE_CONFIGURABLE,		\
	 EthosUIConfigurable))

#define ETHOS_UI_IS_CONFIGURABLE(obj)		\
	(G_TYPE_CHECK_INSTANCE_TYPE((obj),	\
	 ETHOS_UI_TYPE_CONFIGURABLE))

#define ETHOS_UI_CONFIGURABLE_GET_INTERFACE(obj)\
	(G_TYPE_INSTANCE_GET_INTERFACE((obj),	\
	 ETHOS_UI_TYPE_CONFIGURABLE,		\
	 EthosUIConfigurableIface))

typedef struct _EthosUIConfigurable      EthosUIConfigurable;
typedef struct _EthosUIConfigurableIface EthosUIConfigurableIface;

struct _EthosUIConfigurableIface
{
	GObjectClass parent_class;

	void         (*configure)  (EthosUIConfigurable *configurable,
	                            GtkWidget           *parent);

	void         (*reserved1)  (void);
	void         (*reserved2)  (void);
	void         (*reserved3)  (void);
	void         (*reserved4)  (void);
};

GType                 ethos_ui_configurable_get_type  (void) G_GNUC_CONST;
void                  ethos_ui_configurable_configure (EthosUIConfigurable *configurable,
                                                       GtkWidget           *parent);

G_END_DECLS

#endif /* __ETHOS_UI_CONFIGURABLE_H__ */
