/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.security.util.Base64;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.logging.Logger;

class ExportCmd
extends Command {
    private static final Logger log = Logger.getLogger(ExportCmd.class$("gnu.classpath.tools.keytool.ExportCmd").getName());
    protected String _alias;
    protected String _certFileName;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    protected boolean rfc;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setAlias(String string) {
        this._alias = string;
    }

    public void setFile(String string) {
        this._certFileName = string;
    }

    public void setStoretype(String string) {
        this._ksType = string;
    }

    public void setKeystore(String string) {
        this._ksURL = string;
    }

    public void setStorepass(String string) {
        this._ksPassword = string;
    }

    public void setProvider(String string) {
        this._providerClassName = string;
    }

    public void setRfc(String string) {
        this.rfc = Boolean.valueOf(string);
    }

    void setup() throws Exception {
        this.setOutputStreamParam(this._certFileName);
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        if (Configuration.DEBUG) {
            log.fine("-export handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -file=" + this._certFileName);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -rfc=" + this.rfc);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws KeyStoreException, CertificateEncodingException, IOException {
        Object[] objectArray;
        Certificate certificate;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        this.ensureStoreContainsAlias();
        if (this.store.isCertificateEntry(this.alias)) {
            if (Configuration.DEBUG) {
                log.fine("Alias [" + this.alias + "] is a trusted certificate");
            }
            certificate = this.store.getCertificate(this.alias);
        } else {
            if (Configuration.DEBUG) {
                log.fine("Alias [" + this.alias + "] is a key entry");
            }
            objectArray = this.store.getCertificateChain(this.alias);
            certificate = objectArray[0];
        }
        objectArray = certificate.getEncoded();
        if (this.rfc) {
            String string = Base64.encode((byte[])objectArray, (int)0, (int)objectArray.length, (boolean)true);
            PrintWriter printWriter = new PrintWriter(this.outStream, true);
            printWriter.println("-----BEGIN CERTIFICATE-----");
            printWriter.println(string);
            printWriter.println("-----END CERTIFICATE-----");
        } else {
            this.outStream.write((byte[])objectArray);
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser classpathToolParser = new ClasspathToolParser("export", true);
        classpathToolParser.setHeader(Messages.getString("ExportCmd.17"));
        classpathToolParser.setFooter(Messages.getString("ExportCmd.18"));
        OptionGroup optionGroup = new OptionGroup(Messages.getString("ExportCmd.19"));
        optionGroup.add(new Option(this, "alias", Messages.getString("ExportCmd.20"), Messages.getString("ExportCmd.21")){
            private /* synthetic */ ExportCmd this$0;
            {
                this.this$0 = exportCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._alias = string;
            }
        });
        optionGroup.add(new Option(this, "file", Messages.getString("ExportCmd.22"), Messages.getString("ExportCmd.23")){
            private /* synthetic */ ExportCmd this$0;
            {
                this.this$0 = exportCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._certFileName = string;
            }
        });
        optionGroup.add(new Option(this, "storetype", Messages.getString("ExportCmd.24"), Messages.getString("ExportCmd.25")){
            private /* synthetic */ ExportCmd this$0;
            {
                this.this$0 = exportCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksType = string;
            }
        });
        optionGroup.add(new Option(this, "keystore", Messages.getString("ExportCmd.26"), Messages.getString("ExportCmd.27")){
            private /* synthetic */ ExportCmd this$0;
            {
                this.this$0 = exportCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksURL = string;
            }
        });
        optionGroup.add(new Option(this, "storepass", Messages.getString("ExportCmd.28"), Messages.getString("ExportCmd.29")){
            private /* synthetic */ ExportCmd this$0;
            {
                this.this$0 = exportCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksPassword = string;
            }
        });
        optionGroup.add(new Option(this, "provider", Messages.getString("ExportCmd.30"), Messages.getString("ExportCmd.31")){
            private /* synthetic */ ExportCmd this$0;
            {
                this.this$0 = exportCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._providerClassName = string;
            }
        });
        optionGroup.add(new Option(this, "rfc", Messages.getString("ExportCmd.32")){
            private /* synthetic */ ExportCmd this$0;
            {
                this.this$0 = exportCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.rfc = true;
            }
        });
        optionGroup.add(new Option(this, "v", Messages.getString("ExportCmd.33")){
            private /* synthetic */ ExportCmd this$0;
            {
                this.this$0 = exportCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.verbose = true;
            }
        });
        classpathToolParser.add(optionGroup);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", classpathToolParser);
        }
        return classpathToolParser;
    }

    ExportCmd() {
    }
}

