/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import gnu.java.lang.reflect.GenericArrayTypeImpl;
import gnu.java.lang.reflect.ParameterizedTypeImpl;
import gnu.java.lang.reflect.TypeVariableImpl;
import gnu.java.lang.reflect.UnresolvedTypeVariable;
import gnu.java.lang.reflect.WildcardTypeImpl;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;

class GenericSignatureParser {
    private ClassLoader loader;
    private GenericDeclaration container;
    private String signature;
    private int pos;

    GenericSignatureParser(GenericDeclaration genericDeclaration, ClassLoader classLoader, String string) {
        this.container = genericDeclaration;
        this.loader = classLoader;
        this.signature = string;
    }

    TypeVariable[] readFormalTypeParameters() {
        this.consume('<');
        ArrayList arrayList = new ArrayList();
        do {
            arrayList.add(this.readFormalTypeParameter());
        } while (this.peekChar() != '>');
        this.consume('>');
        Object[] objectArray = new TypeVariable[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private TypeVariable readFormalTypeParameter() {
        String string = this.readIdentifier();
        this.consume(':');
        ArrayList arrayList = new ArrayList();
        if (this.peekChar() != ':') {
            arrayList.add(this.readFieldTypeSignature());
        }
        while (this.peekChar() == ':') {
            this.consume(':');
            arrayList.add(this.readFieldTypeSignature());
        }
        Object[] objectArray = new Type[arrayList.size()];
        arrayList.toArray(objectArray);
        return new TypeVariableImpl(this.container, (Type[])objectArray, string);
    }

    Type readFieldTypeSignature() {
        switch (this.peekChar()) {
            case 'L': {
                return this.readClassTypeSignature();
            }
            case '[': {
                return this.readArrayTypeSignature();
            }
            case 'T': {
                return this.readTypeVariableSignature();
            }
        }
        throw new GenericSignatureFormatError();
    }

    Type readClassTypeSignature() {
        Type[] typeArray;
        this.consume('L');
        String string = "";
        while (true) {
            typeArray = this.readIdentifier();
            if (this.peekChar() != '/') break;
            this.consume('/');
            string = string + new StringBuffer().append((String)typeArray).append(".");
        }
        string = string + (String)typeArray;
        typeArray = null;
        if (this.peekChar() == '<') {
            typeArray = this.readTypeArguments();
        }
        ParameterizedTypeImpl parameterizedTypeImpl = new ParameterizedTypeImpl(string, this.loader, null, typeArray);
        while (this.peekChar() == '.') {
            this.consume('.');
            string = string + new StringBuffer("$").append(this.readIdentifier());
            typeArray = null;
            if (this.peekChar() == '<') {
                typeArray = this.readTypeArguments();
            }
            parameterizedTypeImpl = new ParameterizedTypeImpl(string, this.loader, parameterizedTypeImpl, typeArray);
        }
        this.consume(';');
        return parameterizedTypeImpl;
    }

    private Type[] readTypeArguments() {
        this.consume('<');
        ArrayList arrayList = new ArrayList();
        do {
            arrayList.add(this.readTypeArgument());
        } while (this.peekChar() != '>');
        this.consume('>');
        Object[] objectArray = new Type[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private Type readTypeArgument() {
        char c = this.peekChar();
        if (c == '+') {
            this.consume('+');
            return new WildcardTypeImpl(null, this.readFieldTypeSignature());
        }
        if (c == '-') {
            this.consume('-');
            return new WildcardTypeImpl(this.readFieldTypeSignature(), GenericSignatureParser.class$("java.lang.Object"));
        }
        if (c == '*') {
            this.consume('*');
            return new WildcardTypeImpl(null, GenericSignatureParser.class$("java.lang.Object"));
        }
        return this.readFieldTypeSignature();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Type readArrayTypeSignature() {
        this.consume('[');
        switch (this.peekChar()) {
            case 'L': 
            case 'T': 
            case '[': {
                return new GenericArrayTypeImpl(this.readFieldTypeSignature());
            }
            case 'Z': {
                this.consume('Z');
                return GenericSignatureParser.class$("[Z");
            }
            case 'B': {
                this.consume('B');
                return GenericSignatureParser.class$("[B");
            }
            case 'S': {
                this.consume('S');
                return GenericSignatureParser.class$("[S");
            }
            case 'C': {
                this.consume('C');
                return GenericSignatureParser.class$("[C");
            }
            case 'I': {
                this.consume('I');
                return GenericSignatureParser.class$("[I");
            }
            case 'F': {
                this.consume('F');
                return GenericSignatureParser.class$("[F");
            }
            case 'J': {
                this.consume('J');
                return GenericSignatureParser.class$("[J");
            }
            case 'D': {
                this.consume('D');
                return GenericSignatureParser.class$("[D");
            }
        }
        throw new GenericSignatureFormatError();
    }

    Type readTypeVariableSignature() {
        this.consume('T');
        String string = this.readIdentifier();
        this.consume(';');
        return new UnresolvedTypeVariable(this.container, string);
    }

    private String readIdentifier() {
        char c;
        int n = this.pos;
        do {
            this.readChar();
            c = this.peekChar();
        } while (";:./<>-+*".indexOf(c) == -1);
        return this.signature.substring(n, this.pos);
    }

    final char peekChar() {
        if (this.pos == this.signature.length()) {
            return '\u0000';
        }
        return this.signature.charAt(this.pos);
    }

    final char readChar() {
        return this.signature.charAt(this.pos++);
    }

    final void consume(char c) {
        if (this.readChar() != c) {
            throw new GenericSignatureFormatError();
        }
    }

    final void end() {
        if (this.pos != this.signature.length()) {
            throw new GenericSignatureFormatError();
        }
    }
}

