/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.util;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.prng.MDGenerator;
import java.util.HashMap;

public class PRNG {
    private IRandom delegate;

    private PRNG(IRandom iRandom) {
        this.delegate = iRandom;
    }

    public static final PRNG getInstance() {
        MDGenerator mDGenerator = new MDGenerator();
        try {
            HashMap hashMap = new HashMap();
            long l = System.currentTimeMillis();
            byte[] byArray = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
            hashMap.put("gnu.crypto.prng.md.seed", byArray);
            mDGenerator.init(hashMap);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
        return new PRNG(mDGenerator);
    }

    public void nextBytes(byte[] byArray) {
        this.nextBytes(byArray, 0, byArray.length);
    }

    public void nextBytes(byte[] byArray, int n, int n2) {
        try {
            this.delegate.nextBytes(byArray, n, n2);
        }
        catch (LimitReachedException limitReachedException) {
            try {
                HashMap hashMap = new HashMap();
                long l = System.currentTimeMillis();
                byte[] byArray2 = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
                hashMap.put("gnu.crypto.prng.md.seed", byArray2);
                this.delegate.init(hashMap);
                this.delegate.nextBytes(byArray, n, n2);
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }
    }
}

