/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class MeteredInputStream
extends FilterInputStream {
    private int count;
    private final int limit;

    MeteredInputStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n < 0) {
            throw new IllegalArgumentException("limit must be nonnegative");
        }
        this.limit = n;
        this.count = 0;
    }

    public boolean limitReached() {
        return this.count == this.limit;
    }

    public int available() throws IOException {
        return Math.min(this.in.available(), this.limit - this.count);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.limitReached()) {
            return -1;
        }
        int n = this.in.read();
        if (n != -1) {
            ++this.count;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.limitReached()) {
            return -1;
        }
        int n3 = this.in.read(byArray, n, Math.min(n2, this.limit - this.count));
        if (n3 != -1) {
            this.count += n3;
        }
        return n3;
    }

    public void reset() throws IOException {
    }

    public long skip(long l) throws IOException {
        if (this.limitReached()) {
            return 0L;
        }
        l = Math.min(l, (long)(this.limit - this.count));
        l = this.in.skip(l);
        this.count += (int)l;
        return l;
    }
}

