/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.util.Util;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mode.IMode;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OMAC
implements IMac {
    private static final Logger log = Logger.getLogger(OMAC.class$("gnu.javax.crypto.mac.OMAC").getName());
    private static final byte C1 = -121;
    private static final byte C2 = 27;
    private static final byte[] KEY0 = Util.toBytesFromString("2b7e151628aed2a6abf7158809cf4f3c");
    private static final byte[] DIGEST0 = Util.toBytesFromString("bb1d6929e95937287fa37d129b756746");
    private static Boolean valid;
    private final IBlockCipher cipher;
    private final String name;
    private IMode mode;
    private int blockSize;
    private int outputSize;
    private byte[] Lu;
    private byte[] Lu2;
    private byte[] M;
    private byte[] Y;
    private boolean init;
    private int index;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public OMAC(IBlockCipher iBlockCipher) {
        this.cipher = iBlockCipher;
        this.name = "OMAC-" + iBlockCipher.name();
    }

    public Object clone() {
        return new OMAC(this.cipher);
    }

    public String name() {
        return this.name;
    }

    public int macSize() {
        return this.outputSize;
    }

    public void init(Map map) throws InvalidKeyException {
        int n;
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.cipher.key.material", map.get("gnu.crypto.mac.key.material"));
        this.cipher.reset();
        this.cipher.init(hashMap);
        this.blockSize = this.cipher.currentBlockSize();
        Integer n2 = (Integer)map.get("gnu.crypto.mac.truncated.size");
        if (n2 != null) {
            this.outputSize = n2;
            if (this.outputSize < 0 || this.outputSize > this.blockSize) {
                throw new IllegalArgumentException("truncated size out of range");
            }
        } else {
            this.outputSize = this.blockSize;
        }
        byte[] byArray = new byte[this.blockSize];
        this.cipher.encryptBlock(byArray, 0, byArray, 0);
        if (this.Lu != null) {
            Arrays.fill(this.Lu, (byte)0);
            if (this.Lu.length != this.blockSize) {
                this.Lu = new byte[this.blockSize];
            }
        } else {
            this.Lu = new byte[this.blockSize];
        }
        if (this.Lu2 != null) {
            Arrays.fill(this.Lu2, (byte)0);
            if (this.Lu2.length != this.blockSize) {
                this.Lu2 = new byte[this.blockSize];
            }
        } else {
            this.Lu2 = new byte[this.blockSize];
        }
        boolean bl = (byArray[0] & 0x80) != 0;
        for (n = 0; n < this.blockSize; ++n) {
            this.Lu[n] = (byte)(byArray[n] << 1);
            if (n + 1 >= this.blockSize) continue;
            int n3 = n;
            this.Lu[n3] = this.Lu[n3] | (byte)((byArray[n + 1] & 0x80) >> 7);
        }
        if (bl) {
            if (this.blockSize == 16) {
                int n4 = this.Lu.length - 1;
                this.Lu[n4] = this.Lu[n4] ^ 0xFFFFFF87;
            } else if (this.blockSize == 8) {
                int n5 = this.Lu.length - 1;
                this.Lu[n5] = this.Lu[n5] ^ 0x1B;
            } else {
                throw new IllegalArgumentException("unsupported cipher block size: " + this.blockSize);
            }
        }
        bl = (this.Lu[0] & 0x80) != 0;
        for (n = 0; n < this.blockSize; ++n) {
            this.Lu2[n] = (byte)(this.Lu[n] << 1);
            if (n + 1 >= this.blockSize) continue;
            int n6 = n;
            this.Lu2[n6] = this.Lu2[n6] | (byte)((this.Lu[n + 1] & 0x80) >> 7);
        }
        if (bl) {
            if (this.blockSize == 16) {
                int n7 = this.Lu2.length - 1;
                this.Lu2[n7] = this.Lu2[n7] ^ 0xFFFFFF87;
            } else {
                int n8 = this.Lu2.length - 1;
                this.Lu2[n8] = this.Lu2[n8] ^ 0x1B;
            }
        }
        if (this.M != null) {
            Arrays.fill(this.M, (byte)0);
            if (this.M.length != this.blockSize) {
                this.M = new byte[this.blockSize];
            }
        } else {
            this.M = new byte[this.blockSize];
        }
        if (this.Y != null) {
            Arrays.fill(this.Y, (byte)0);
            if (this.Y.length != this.blockSize) {
                this.Y = new byte[this.blockSize];
            }
        } else {
            this.Y = new byte[this.blockSize];
        }
        this.index = 0;
        this.init = true;
    }

    public void update(byte by) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (this.index == this.M.length) {
            this.process();
            this.index = 0;
        }
        this.M[this.index++] = by;
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3;
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("size=" + byArray.length + "; off=" + n + "; len=" + n2);
        }
        for (int i = 0; i < n2; i += n3) {
            if (this.index == this.blockSize) {
                this.process();
                this.index = 0;
            }
            n3 = Math.min(this.blockSize - this.index, n2 - i);
            System.arraycopy(byArray, n + i, this.M, this.index, n3);
            this.index += n3;
        }
    }

    public byte[] digest() {
        byte[] byArray = new byte[this.outputSize];
        this.digest(byArray, 0);
        return byArray;
    }

    public void digest(byte[] byArray, int n) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (n < 0 || n + this.outputSize > byArray.length) {
            throw new IndexOutOfBoundsException("size=" + byArray.length + "; off=" + n + "; len=" + this.outputSize);
        }
        byte[] byArray2 = new byte[this.blockSize];
        byte[] byArray3 = this.Lu;
        if (this.index < this.blockSize) {
            this.M[this.index++] = -128;
            while (this.index < this.blockSize) {
                this.M[this.index++] = 0;
            }
            byArray3 = this.Lu2;
        }
        for (int i = 0; i < this.blockSize; ++i) {
            byArray2[i] = this.M[i] ^ this.Y[i] ^ byArray3[i];
        }
        this.cipher.encryptBlock(byArray2, 0, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray, n, this.outputSize);
        this.reset();
    }

    public void reset() {
        this.index = 0;
        if (this.Y != null) {
            Arrays.fill(this.Y, (byte)0);
        }
        if (this.M != null) {
            Arrays.fill(this.M, (byte)0);
        }
    }

    public boolean selfTest() {
        OMAC oMAC = new OMAC(CipherFactory.getInstance("aes"));
        oMAC.reset();
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.mac.key.material", KEY0);
        byte[] byArray = null;
        try {
            oMAC.init(hashMap);
            byArray = oMAC.digest();
        }
        catch (Exception exception) {
            return false;
        }
        if (byArray == null) {
            return false;
        }
        return Arrays.equals(DIGEST0, byArray);
    }

    private void process() {
        for (int i = 0; i < this.blockSize; ++i) {
            this.M[i] = this.M[i] ^ this.Y[i];
        }
        this.cipher.encryptBlock(this.M, 0, this.Y, 0);
    }
}

