/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html;

import java.awt.Color;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;

public class CharacterAttributeTranslator {
    private static final HashMap colorMap = new HashMap();

    public static Color getColor(String string) {
        string = string.toLowerCase();
        try {
            if (string.startsWith("rgb")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ,()");
                String string2 = stringTokenizer.nextToken();
                if (!string2.equals("rgb")) {
                    return null;
                }
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                return new Color(n, n2, n3);
            }
            String string3 = (String)colorMap.get(string);
            if (string3 == null) {
                string3 = string;
            }
            return Color.decode(string3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean translateTag(MutableAttributeSet mutableAttributeSet, HTML.Tag tag, MutableAttributeSet mutableAttributeSet2) {
        if (tag == HTML.Tag.FONT) {
            Object object = mutableAttributeSet2.getAttribute(HTML.Attribute.COLOR);
            if (object != null) {
                Color color = CharacterAttributeTranslator.getColor(object.toString());
                if (color == null) {
                    return false;
                }
                mutableAttributeSet.addAttribute(StyleConstants.Foreground, color);
                return true;
            }
            if (mutableAttributeSet2.getAttribute(HTML.Attribute.SIZE) != null) {
                return true;
            }
        }
        if (tag == HTML.Tag.B) {
            mutableAttributeSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
            return true;
        }
        if (tag == HTML.Tag.I) {
            mutableAttributeSet.addAttribute(StyleConstants.Italic, Boolean.TRUE);
            return true;
        }
        if (tag == HTML.Tag.U) {
            mutableAttributeSet.addAttribute(StyleConstants.Underline, Boolean.TRUE);
            return true;
        }
        if (tag == HTML.Tag.STRIKE) {
            mutableAttributeSet.addAttribute(StyleConstants.StrikeThrough, Boolean.TRUE);
            return true;
        }
        if (tag == HTML.Tag.SUP) {
            mutableAttributeSet.addAttribute(StyleConstants.Superscript, Boolean.TRUE);
            return true;
        }
        if (tag == HTML.Tag.SUB) {
            mutableAttributeSet.addAttribute(StyleConstants.Subscript, Boolean.TRUE);
            return true;
        }
        return false;
    }

    static {
        colorMap.put("aqua", "#00FFFF");
        colorMap.put("blue", "#0000FF");
        colorMap.put("black", "#000000");
        colorMap.put("fuchsia", "#FF00FF");
        colorMap.put("gray", "#808080");
        colorMap.put("green", "#008000");
        colorMap.put("lime", "#00FF00");
        colorMap.put("maroon", "#800000");
        colorMap.put("navy", "#000080");
        colorMap.put("olive", "#808000");
        colorMap.put("purple", "#800080");
        colorMap.put("red", "#FF0000");
        colorMap.put("silver", "#C0C0C0");
        colorMap.put("teal", "#008080");
        colorMap.put("white", "#FFFFFF");
        colorMap.put("yellow", "#FFFF00");
    }
}

