/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XMLEventWriterImpl
implements XMLEventWriter {
    protected final XMLStreamWriter writer;

    protected XMLEventWriterImpl(XMLStreamWriter xMLStreamWriter) {
        this.writer = xMLStreamWriter;
    }

    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    public void close() throws XMLStreamException {
        this.writer.close();
    }

    public void add(XMLEvent xMLEvent) throws XMLStreamException {
        switch (xMLEvent.getEventType()) {
            case 1: {
                StartElement startElement = xMLEvent.asStartElement();
                QName qName = startElement.getName();
                String string = qName.getNamespaceURI();
                if (string != null && !"".equals(string)) {
                    this.writer.writeStartElement(qName.getPrefix(), qName.getLocalPart(), string);
                    break;
                }
                this.writer.writeStartElement(qName.getLocalPart());
                break;
            }
            case 2: {
                this.writer.writeEndElement();
                break;
            }
            case 10: {
                Attribute attribute = (Attribute)xMLEvent;
                QName qName = attribute.getName();
                String string = qName.getNamespaceURI();
                if (string != null && !"".equals(string)) {
                    this.writer.writeAttribute(qName.getPrefix(), string, qName.getLocalPart(), attribute.getValue());
                    break;
                }
                this.writer.writeAttribute(qName.getLocalPart(), attribute.getValue());
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)xMLEvent;
                String string = namespace.getNamespaceURI();
                this.writer.writeNamespace(namespace.getPrefix(), string);
                break;
            }
            case 3: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)xMLEvent;
                String string = processingInstruction.getData();
                if (string == null) {
                    this.writer.writeProcessingInstruction(processingInstruction.getTarget());
                    break;
                }
                this.writer.writeProcessingInstruction(processingInstruction.getTarget(), string);
                break;
            }
            case 5: {
                Comment comment = (Comment)xMLEvent;
                this.writer.writeComment(comment.getText());
                break;
            }
            case 7: {
                StartDocument startDocument = (StartDocument)xMLEvent;
                this.writer.writeStartDocument(startDocument.getVersion());
                break;
            }
            case 8: {
                this.writer.writeEndDocument();
                break;
            }
            case 11: {
                DTD dTD = (DTD)xMLEvent;
                this.writer.writeDTD(dTD.getDocumentTypeDeclaration());
                break;
            }
            case 4: 
            case 6: {
                Characters characters = xMLEvent.asCharacters();
                this.writer.writeCharacters(characters.getData());
                break;
            }
            case 12: {
                Characters characters = xMLEvent.asCharacters();
                this.writer.writeCData(characters.getData());
            }
        }
    }

    public void add(XMLEventReader xMLEventReader) throws XMLStreamException {
        while (xMLEventReader.hasNext()) {
            this.add(xMLEventReader.nextEvent());
        }
    }

    public String getPrefix(String string) throws XMLStreamException {
        return this.writer.getPrefix(string);
    }

    public void setPrefix(String string, String string2) throws XMLStreamException {
        this.writer.setPrefix(string, string2);
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.writer.setDefaultNamespace(string);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.writer.setNamespaceContext(namespaceContext);
    }

    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }
}

