/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class IntegerType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{11, 12, 4, 6, 5, 7, 8, 10, 9};

    IntegerType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "integer"), TypeLibrary.DECIMAL);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        if (n == 0) {
            throw new DatatypeException(0, "invalid integer value");
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c == '+' && i == 0 || c == '-' && i == 0) continue;
            throw new DatatypeException(i, "invalid integer value");
        }
    }

    public Object createValue(String string, ValidationContext validationContext) {
        try {
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

