/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

public final class TextHitInfo {
    private int charIndex;
    private boolean leadingEdge;

    TextHitInfo(int n, boolean bl) {
        this.charIndex = n;
        this.leadingEdge = bl;
    }

    public int getCharIndex() {
        return this.charIndex;
    }

    public boolean isLeadingEdge() {
        return this.leadingEdge;
    }

    public int getInsertionIndex() {
        if (this.leadingEdge) {
            return this.charIndex;
        }
        return this.charIndex + 1;
    }

    public int hashCode() {
        return this.charIndex;
    }

    public boolean equals(Object object) {
        if (object instanceof TextHitInfo) {
            return this.equals((TextHitInfo)object);
        }
        return false;
    }

    public boolean equals(TextHitInfo textHitInfo) {
        return this.charIndex == textHitInfo.getCharIndex() && this.leadingEdge == textHitInfo.isLeadingEdge();
    }

    public static TextHitInfo leading(int n) {
        return new TextHitInfo(n, true);
    }

    public static TextHitInfo trailing(int n) {
        return new TextHitInfo(n, false);
    }

    public static TextHitInfo beforeOffset(int n) {
        return new TextHitInfo(n, false);
    }

    public static TextHitInfo afterOffset(int n) {
        return new TextHitInfo(n, true);
    }

    public TextHitInfo getOtherHit() {
        if (this.leadingEdge) {
            return TextHitInfo.trailing(this.charIndex - 1);
        }
        return TextHitInfo.leading(this.charIndex + 1);
    }

    public TextHitInfo getOffsetHit(int n) {
        return new TextHitInfo(this.charIndex + n, this.leadingEdge);
    }

    public String toString() {
        return "TextHitInfo[" + this.charIndex + (this.leadingEdge ? "L" : "T") + "]";
    }
}

