/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageFilter;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class BufferedImageFilter
extends ImageFilter
implements Cloneable {
    private BufferedImageOp op;

    public BufferedImageFilter(BufferedImageOp bufferedImageOp) {
        if (bufferedImageOp == null) {
            throw new NullPointerException("BufferedImageFilter null op in constructor");
        }
        this.op = bufferedImageOp;
    }

    public BufferedImageOp getBufferedImageOp() {
        return this.op;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n6 * n4 + n5, n5);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(n6, n4);
        WritableRaster writableRaster = new WritableRaster(sampleModel, dataBufferByte, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        BufferedImage bufferedImage2 = this.op.createCompatibleDestImage(bufferedImage, colorModel);
        this.op.filter(bufferedImage, bufferedImage2);
        DataBuffer dataBuffer = bufferedImage2.getRaster().getDataBuffer();
        super.setPixels(0, 0, n3, n4, colorModel, ((DataBufferByte)dataBuffer).getData(), 0, n6);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, n6 * n4 + n5, n5);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(n6, n4);
        WritableRaster writableRaster = new WritableRaster(sampleModel, dataBufferInt, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        BufferedImage bufferedImage2 = this.op.createCompatibleDestImage(bufferedImage, colorModel);
        this.op.filter(bufferedImage, bufferedImage2);
        DataBuffer dataBuffer = bufferedImage2.getRaster().getDataBuffer();
        super.setPixels(0, 0, n3, n4, colorModel, ((DataBufferInt)dataBuffer).getData(), 0, n6);
    }
}

