/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Short
extends Number
implements Comparable {
    private static final long serialVersionUID = 7515723908773894738L;
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('S');
    public static final int SIZE = 16;
    private static final int MIN_CACHE = -128;
    private static final int MAX_CACHE = 127;
    private static Short[] shortCache = new Short[256];
    private final short value;

    public Short(short s) {
        this.value = s;
    }

    public Short(String string) {
        this.value = Short.parseShort(string, 10);
    }

    public static String toString(short s) {
        return String.valueOf(s);
    }

    public static short parseShort(String string) {
        return Short.parseShort(string, 10);
    }

    public static short parseShort(String string, int n) {
        int n2 = Integer.parseInt(string, n, false);
        if ((short)n2 != n2) {
            throw new NumberFormatException();
        }
        return (short)n2;
    }

    public static Short valueOf(String string, int n) {
        return new Short(Short.parseShort(string, n));
    }

    public static Short valueOf(String string) {
        return new Short(Short.parseShort(string, 10));
    }

    public static Short valueOf(short s) {
        if (s < -128 || s > 127) {
            return new Short(s);
        }
        Short[] shortArray = shortCache;
        synchronized (shortArray) {
            try {
                if (shortCache[s - -128] == null) {
                    Short.shortCache[s - -128] = new Short(s);
                }
                Short s2 = shortCache[s - -128];
                Object var3_3 = null;
                return s2;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public static Short decode(String string) {
        int n = Integer.parseInt(string, 10, true);
        if ((short)n != n) {
            throw new NumberFormatException();
        }
        return new Short((short)n);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Short && this.value == ((Short)object).value;
    }

    public int compareTo(Short s) {
        return this.value - s.value;
    }

    public int compareTo(Object object) {
        return this.compareTo((Short)object);
    }

    public static short reverseBytes(short s) {
        return (short)((short)(s >> 8) & 0xFF | (short)(s << 8) & 0xFFFFFF00);
    }
}

