/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;

public class Mac
implements Cloneable {
    private static final String SERVICE = "Mac";
    private MacSpi macSpi;
    private Provider provider;
    private String algorithm;
    private boolean virgin;

    protected Mac(MacSpi macSpi, Provider provider, String string) {
        this.macSpi = macSpi;
        this.provider = provider;
        this.algorithm = string;
        this.virgin = true;
    }

    public static final Mac getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        String string2 = "";
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return Mac.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                string2 = noSuchAlgorithmException.getMessage();
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string2);
    }

    public static final Mac getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return Mac.getInstance(string, provider);
    }

    public static final Mac getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        try {
            return new Mac((MacSpi)Engine.getInstance(SERVICE, string, provider), provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() == null) {
                throw new NoSuchAlgorithmException(string);
            }
            if (invocationTargetException.getCause() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)invocationTargetException.getCause();
            }
            throw new NoSuchAlgorithmException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        byte[] byArray = this.macSpi.engineDoFinal();
        this.reset();
        return byArray;
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException {
        this.update(byArray);
        byte[] byArray2 = this.macSpi.engineDoFinal();
        this.reset();
        return byArray2;
    }

    public final void doFinal(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        if (byArray.length - n < this.getMacLength()) {
            throw new ShortBufferException();
        }
        byte[] byArray2 = this.macSpi.engineDoFinal();
        System.arraycopy(byArray2, 0, byArray, n, this.getMacLength());
        this.reset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getMacLength() {
        return this.macSpi.engineGetMacLength();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.init(key, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException(this.algorithm + " needs parameters");
        }
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.macSpi.engineInit(key, algorithmParameterSpec);
        this.virgin = false;
    }

    public final void reset() {
        this.macSpi.engineReset();
    }

    public final void update(byte by) throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        this.macSpi.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws IllegalStateException {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        this.macSpi.engineUpdate(byArray, n, n2);
    }

    public final Object clone() throws CloneNotSupportedException {
        Mac mac = new Mac((MacSpi)this.macSpi.clone(), this.provider, this.algorithm);
        mac.virgin = this.virgin;
        return mac;
    }
}

