/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import java.net.InetAddress;
import java.util.Arrays;

public class ChannelBinding {
    private final byte[] appData;
    private final InetAddress initAddr;
    private final InetAddress acceptAddr;

    public ChannelBinding(InetAddress inetAddress, InetAddress inetAddress2, byte[] byArray) {
        this.appData = byArray != null ? (byte[])byArray.clone() : null;
        this.initAddr = inetAddress;
        this.acceptAddr = inetAddress2;
    }

    public ChannelBinding(byte[] byArray) {
        this(null, null, byArray);
    }

    public InetAddress getInitiatorAddress() {
        return this.initAddr;
    }

    public InetAddress getAcceptorAddress() {
        return this.acceptAddr;
    }

    public byte[] getApplicationData() {
        if (this.appData != null) {
            return (byte[])this.appData.clone();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChannelBinding)) {
            return false;
        }
        ChannelBinding channelBinding = (ChannelBinding)object;
        boolean bl = Arrays.equals(this.appData, channelBinding.appData);
        boolean bl2 = this.initAddr == null && channelBinding.initAddr == null || channelBinding.initAddr != null && this.initAddr.equals(channelBinding.initAddr);
        boolean bl3 = this.acceptAddr == null && channelBinding.acceptAddr == null || channelBinding.acceptAddr != null && this.acceptAddr.equals(channelBinding.acceptAddr);
        return bl && bl2 && bl3;
    }

    public int hashCode() {
        int n = 0;
        if (this.appData != null) {
            for (int i = 0; i < this.appData.length; ++i) {
                n ^= this.appData[i] << (8 * i & 0x1F);
            }
        }
        if (this.initAddr != null) {
            n ^= this.initAddr.hashCode();
        }
        if (this.acceptAddr != null) {
            n ^= this.acceptAddr.hashCode();
        }
        return n;
    }
}

