#!/bin/sh
echo 'name: tls
version: 0.3.1
id: tls-0.3.1-5510baade8d3e55f2cb06d4fa620a2e6

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
package-url:
description: native TLS protocol implementation, focusing on purity and more type-checking.
             .
             Currently implement the SSL3.0, TLS1.0 and TLS1.1 protocol.
             Not yet properly secure and missing some features.
             Do not yet use as replacement to more mature implementation.
             .
             only RSA supported as Key exchange for now.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-tls
exposed: True
exposed-modules: Network.TLS.Client Network.TLS.Server
                 Network.TLS.Struct Network.TLS.Cipher Network.TLS.SRandom
                 Network.TLS.MAC
hidden-modules: Network.TLS.Cap Network.TLS.Compression
                Network.TLS.Crypto Network.TLS.Packet Network.TLS.State
                Network.TLS.Sending Network.TLS.Receiving Network.TLS.Util
                Network.TLS.Wire
import-dirs: /usr/local/lib/ghc/tls-0.3.1
library-dirs: /usr/local/lib/ghc/tls-0.3.1
hs-libraries: HStls-0.3.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: AES-0.2.7-3f86e45d83a206ac5d38c3f854f1dc89
         base-4.2.0.2-578c91f7479ca9d00c13da2ed514f7ac
         binary-0.5.0.2-d8a2016532c382364dd8eb78608b883d
         bytestring-0.9.1.7-41dd05a497806d68d10ffae5438a0632
         cereal-0.3.0.0-780d21095ae79ac3df7682af40a002c1
         certificate-0.3.2-642d3bce827ab480ab8acf40a4de0db9
         crypto-api-0.2.1-39e481d004e818aa09631d0fc52d2bbe
         cryptocipher-0.2-c4f5bcc7240a87136f38953d103a81de
         cryptohash-0.6.1-3e359a01d476ce547f0d70fb653cc8f4
         mtl-1.1.0.2-9e35d291e0ab20c6aa18823de23bc2de
         vector-0.7.0.1-9b881f929a9a86a17d651af54f905321
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tls-0.3.1/html/tls.haddock
haddock-html: /usr/local/share/doc/hs-tls-0.3.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
