/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Arrays;
import java.util.List;

public class Queue<T> {
    private final NormalState NORMAL_STATE = new NormalState();
    private final InvertedState INVERTED_STATE = new InvertedState();
    private Object[] myArray;
    private int myFirst = 0;
    private int myLast = 0;
    private QueueState myState = this.NORMAL_STATE;

    public Queue(int initialCapacity) {
        this.myArray = new Object[initialCapacity];
    }

    public void addLast(T object) {
        int currrentSize = this.size();
        if (currrentSize == this.myArray.length) {
            this.myArray = this.myState.normalize(currrentSize * 2);
            this.myFirst = 0;
            this.myLast = currrentSize;
            this.myState = this.NORMAL_STATE;
        }
        this.myState.addLast(object);
    }

    public T pullFirst() {
        return this.myState.pullFirst();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.myState.calculateSize();
    }

    public List<T> toList() {
        return Arrays.asList(this.myState.normalize(this.size()));
    }

    private class InvertedState
    extends QueueState {
        private InvertedState() {
        }

        @Override
        public T[] normalize(int capasity) {
            Object[] result = new Object[capasity];
            int tailLength = this.copyFromTo(Queue.this.myFirst, Queue.this.myArray.length, result, 0);
            this.copyFromTo(0, Queue.this.myLast, result, tailLength);
            return result;
        }

        @Override
        protected QueueState inverted() {
            return Queue.this.NORMAL_STATE;
        }

        @Override
        public int calculateSize() {
            return Queue.this.myArray.length - Queue.this.myFirst + Queue.this.myLast;
        }
    }

    private class NormalState
    extends QueueState {
        private NormalState() {
        }

        @Override
        public T[] normalize(int capacity) {
            Object[] result = new Object[capacity];
            this.copyFromTo(Queue.this.myFirst, Queue.this.myLast, result, 0);
            return result;
        }

        @Override
        protected QueueState inverted() {
            return Queue.this.INVERTED_STATE;
        }

        @Override
        public int calculateSize() {
            return Queue.this.myLast - Queue.this.myFirst;
        }
    }

    private abstract class QueueState {
        private QueueState() {
        }

        public abstract T[] normalize(int var1);

        public T pullFirst() {
            Object result = Queue.this.myArray[Queue.this.myFirst];
            ((Queue)Queue.this).myArray[((Queue)Queue.this).myFirst] = null;
            Queue.this.myFirst++;
            if (Queue.this.myFirst == Queue.this.myArray.length) {
                Queue.this.myFirst = 0;
                Queue.this.myState = this.inverted();
            }
            return result;
        }

        public void addLast(T object) {
            ((Queue)Queue.this).myArray[((Queue)Queue.this).myLast] = object;
            Queue.this.myLast++;
            if (Queue.this.myLast == Queue.this.myArray.length) {
                Queue.this.myState = this.inverted();
                Queue.this.myLast = 0;
            }
        }

        protected abstract QueueState inverted();

        public abstract int calculateSize();

        protected int copyFromTo(int first, int last, T[] result, int destPos) {
            int length = last - first;
            System.arraycopy(Queue.this.myArray, first, result, destPos, length);
            return length;
        }
    }
}

