/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.ui.actions;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationType;

public class CreatePackageTestAction
extends AnAction {
    private PsiPackage pkg;
    private Module module;

    public void update(AnActionEvent event) {
        this.pkg = this.getSelectedPackage(event.getDataContext());
        event.getPresentation().setVisible(this.pkg != null);
        event.getPresentation().setEnabled(this.pkg != null);
        if (this.pkg != null) {
            event.getPresentation().setText("Create \"Tests in '" + this.pkg.getQualifiedName() + "'\"...");
            this.module = (Module)LangDataKeys.MODULE.getData(event.getDataContext());
        } else {
            this.module = null;
        }
    }

    public void actionPerformed(AnActionEvent event) {
        RunManager runManager = RunManager.getInstance((Project)this.pkg.getProject());
        ConfigurationFactory[] factory = ((TestNGConfigurationType)ApplicationManager.getApplication().getComponent(TestNGConfigurationType.class)).getConfigurationFactories();
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration("", factory[0]);
        TestNGConfiguration configuration = (TestNGConfiguration)settings.getConfiguration();
        configuration.setPackageConfiguration(this.module, this.pkg);
        settings.setName(configuration.getName());
    }

    PsiPackage getSelectedPackage(DataContext context) {
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(context);
        if (element == null) {
            return null;
        }
        if (element instanceof PsiDirectory) {
            return JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        }
        return null;
    }
}

