/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.CheckArea;
import com.intellij.spellchecker.inspections.SplitterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WordSplitter
extends BaseSplitter {
    @NonNls
    private static final Pattern SPECIAL = Pattern.compile("&\\p{Alnum}{4};?|#\\p{Alnum}{3,6}|0x\\p{Alnum}?");

    @Override
    public List<CheckArea> split(@Nullable String text, @NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/WordSplitter.split must not be null");
        }
        if (text == null || range.getLength() <= 1) {
            return null;
        }
        ArrayList<CheckArea> results = new ArrayList<CheckArea>();
        Matcher specialMatcher = SPECIAL.matcher(text.substring(range.getStartOffset(), range.getEndOffset()));
        if (specialMatcher.find()) {
            TextRange found = WordSplitter.matcherRange(range, specialMatcher);
            WordSplitter.addWord(text, results, true, found);
        } else {
            List<CheckArea> res = SplitterFactory.getInstance().getIdentifierSplitter().split(text, range);
            if (res != null) {
                results.addAll(res);
            }
        }
        return results;
    }
}

