/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.GuiUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesGroupingStructureViewComponent
extends StructureViewComponent {
    protected PropertiesGroupingStructureViewComponent(Project project, FileEditor editor, PropertiesGroupingStructureViewModel structureViewModel) {
        super(editor, (StructureViewModel)structureViewModel, project);
    }

    protected ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = (DefaultActionGroup)super.createActionGroup();
        actionGroup.add((AnAction)new ChangeGroupSeparatorAction());
        return actionGroup;
    }

    @NonNls
    public String getHelpID() {
        return "editing.propertyFile.bundleEditor";
    }

    private class ChangeGroupSeparatorAction
    extends ComboBoxAction {
        private DefaultActionGroup myActionGroup;
        private final Map<String, String> myPredefindedSeparators = new LinkedHashMap<String, String>();
        private JPanel myPanel;

        public ChangeGroupSeparatorAction() {
            this.myPredefindedSeparators.put(".", ".");
            this.myPredefindedSeparators.put("_", "__");
            this.myPredefindedSeparators.put("/", "/");
            String currentSeparator = this.getCurrentSeparator();
            if (!this.myPredefindedSeparators.containsKey(currentSeparator)) {
                this.myPredefindedSeparators.put(currentSeparator, currentSeparator);
            }
        }

        public final void update(AnActionEvent e) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            boolean isGroupActive = PropertiesGroupingStructureViewComponent.this.isActionActive("GROUP_BY_PREFIXES");
            String separator = this.getCurrentSeparator();
            Presentation presentation = e.getPresentation();
            presentation.setText(separator);
            presentation.setEnabled(isGroupActive);
            if (this.myPanel != null) {
                GuiUtils.enableChildren((Component)this.myPanel, (boolean)isGroupActive, (JComponent[])new JComponent[0]);
            }
        }

        private String getCurrentSeparator() {
            return ((PropertiesGroupingStructureViewModel)PropertiesGroupingStructureViewComponent.this.getTreeModel()).getSeparator();
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            this.myActionGroup = new DefaultActionGroup();
            this.refillActionGroup();
            DefaultActionGroup defaultActionGroup = this.myActionGroup;
            if (defaultActionGroup == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/properties/editor/PropertiesGroupingStructureViewComponent$ChangeGroupSeparatorAction.createPopupActionGroup must not return null");
            }
            return defaultActionGroup;
        }

        private void refillActionGroup() {
            this.myActionGroup.removeAll();
            for (String separator : this.myPredefindedSeparators.keySet()) {
                String presentableText = this.myPredefindedSeparators.get(separator);
                this.myActionGroup.add((AnAction)new SelectSeparatorAction(separator, presentableText));
            }
            this.myActionGroup.add((AnAction)new SelectSeparatorAction(null, null));
        }

        public final JComponent createCustomComponent(Presentation presentation) {
            this.myPanel = new JPanel(new GridBagLayout());
            this.myPanel.add((Component)new JLabel(PropertiesBundle.message("properties.structure.view.group.by.label", new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.myPanel.add((Component)super.createCustomComponent(presentation), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            return this.myPanel;
        }

        private final class SelectSeparatorAction
        extends AnAction {
            private final String myActionSeparator;

            public SelectSeparatorAction(String separator, String presentableText) {
                super(separator == null ? PropertiesBundle.message("select.separator.action.with.empty.separator.name", new Object[0]) : presentableText);
                this.myActionSeparator = separator;
            }

            public final void actionPerformed(AnActionEvent e) {
                String separator;
                if (this.myActionSeparator == null) {
                    String[] strings = ChangeGroupSeparatorAction.this.myPredefindedSeparators.keySet().toArray(new String[ChangeGroupSeparatorAction.this.myPredefindedSeparators.size()]);
                    String current = ChangeGroupSeparatorAction.this.getCurrentSeparator();
                    separator = Messages.showEditableChooseDialog((String)PropertiesBundle.message("select.property.separator.dialog.text", new Object[0]), (String)PropertiesBundle.message("select.property.separator.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])strings, (String)current, null);
                    if (separator == null) {
                        return;
                    }
                    ChangeGroupSeparatorAction.this.myPredefindedSeparators.put(separator, separator);
                    ChangeGroupSeparatorAction.this.refillActionGroup();
                } else {
                    separator = this.myActionSeparator;
                }
                ((PropertiesGroupingStructureViewModel)PropertiesGroupingStructureViewComponent.this.getTreeModel()).setSeparator(separator);
                PropertiesGroupingStructureViewComponent.this.rebuild();
            }
        }
    }
}

