/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.equality;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.equality.ObjectEqualityPredicate;
import com.siyeh.ipp.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class ReplaceEqualityWithEqualsIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ObjectEqualityPredicate objectEqualityPredicate = new ObjectEqualityPredicate();
        if (objectEqualityPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/equality/ReplaceEqualityWithEqualsIntention.getElementPredicate must not return null");
        }
        return objectEqualityPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        PsiExpression lhs = exp.getLOperand();
        PsiExpression rhs = exp.getROperand();
        if (rhs == null) {
            return;
        }
        PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
        if (strippedLhs == null) {
            return;
        }
        PsiExpression strippedRhs = ParenthesesUtils.stripParentheses(rhs);
        if (strippedRhs == null) {
            return;
        }
        PsiJavaToken operationSign = exp.getOperationSign();
        IElementType tokenType = operationSign.getTokenType();
        String expString = tokenType.equals(JavaTokenType.EQEQ) ? (ParenthesesUtils.getPrecedence(strippedLhs) > 1 ? '(' + strippedLhs.getText() + ").equals(" + strippedRhs.getText() + ')' : strippedLhs.getText() + ".equals(" + strippedRhs.getText() + ')') : (ParenthesesUtils.getPrecedence(strippedLhs) > 1 ? "!(" + strippedLhs.getText() + ").equals(" + strippedRhs.getText() + ')' : '!' + strippedLhs.getText() + ".equals(" + strippedRhs.getText() + ')');
        ReplaceEqualityWithEqualsIntention.replaceExpression(expString, (PsiExpression)exp);
    }
}

