/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.switchtoif;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class SwitchPredicate
implements PsiElementPredicate {
    SwitchPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiStatement[] statements;
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        IElementType tokenType = token.getTokenType();
        if (!JavaTokenType.SWITCH_KEYWORD.equals(tokenType)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiSwitchStatement)) {
            return false;
        }
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)parent;
        PsiExpression expression = switchStatement.getExpression();
        if (expression == null) {
            return false;
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return false;
        }
        if (ErrorUtil.containsError((PsiElement)switchStatement)) {
            return false;
        }
        boolean hasLabel = false;
        for (PsiStatement statement : statements = body.getStatements()) {
            if (!(statement instanceof PsiSwitchLabelStatement)) continue;
            hasLabel = true;
            break;
        }
        return hasLabel;
    }
}

