/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvshandlers;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.cvsContext.CvsLightweightFile;
import com.intellij.cvsSupport2.actions.update.UpdateSettings;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvshandlers.AbstractCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CheckoutHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvshandlers.FileSetToBeUpdated;
import com.intellij.cvsSupport2.cvshandlers.IOFilesBasedDirectoryPruner;
import com.intellij.cvsSupport2.cvshandlers.UpdateHandler;
import com.intellij.cvsSupport2.cvsoperations.common.CompositeOperaton;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.common.LoginPerformer;
import com.intellij.cvsSupport2.cvsoperations.common.PostCvsActivity;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.AddFilesOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.AddedFileInfo;
import com.intellij.cvsSupport2.cvsoperations.cvsCheckOut.CheckoutFileByRevisionOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsCheckOut.CheckoutFileOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsCheckOut.CheckoutProjectOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsCommit.CommitFilesOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.EditOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.UneditOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsImport.ImportDetails;
import com.intellij.cvsSupport2.cvsoperations.cvsImport.ImportOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsRemove.RemoveFilesOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.BranchOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsUpdate.UpdateOperation;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDateImpl;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.cvsSupport2.errorHandling.CvsProcessException;
import com.intellij.cvsSupport2.errorHandling.InvalidModuleDescriptionException;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.InvalidEntryFormatException;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;

public class CommandCvsHandler
extends AbstractCvsHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler");
    protected final CvsOperation myCvsOperation;
    private final List<CvsOperation> myPostActivities = new ArrayList<CvsOperation>();
    private final boolean myCanBeCanceled;
    protected boolean myIsCanceled = false;
    private PerformInBackgroundOption myBackgroundOption;

    @Override
    public boolean login(ModalityContext executor) {
        return this.loginAll(executor);
    }

    public CommandCvsHandler(String title, CvsOperation cvsOperation, boolean canBeCanceled) {
        this(title, cvsOperation, FileSetToBeUpdated.EMPTY, canBeCanceled);
    }

    public CommandCvsHandler(String title, CvsOperation cvsOperation, FileSetToBeUpdated files, boolean canBeCanceled) {
        super(title, files);
        this.myCvsOperation = cvsOperation;
        this.myCanBeCanceled = canBeCanceled;
    }

    public CommandCvsHandler(String title, CvsOperation cvsOperation, FileSetToBeUpdated files) {
        this(title, cvsOperation, files, true);
    }

    public CommandCvsHandler(String title, CvsOperation cvsOperation) {
        this(title, cvsOperation, FileSetToBeUpdated.EMPTY);
    }

    public CommandCvsHandler(String title, CvsOperation operation, FileSetToBeUpdated files, PerformInBackgroundOption backgroundOption) {
        this(title, operation, files);
        this.myBackgroundOption = backgroundOption;
    }

    @Override
    public boolean canBeCanceled() {
        return this.myCanBeCanceled;
    }

    @Override
    public PerformInBackgroundOption getBackgroundOption(Project project) {
        return this.myBackgroundOption;
    }

    @Override
    protected boolean runInReadThread() {
        return this.myCvsOperation.runInReadThread();
    }

    public static CvsHandler createCheckoutFileHandler(FilePath[] files, CvsConfiguration configuration) {
        return new CheckoutHandler(files, configuration);
    }

    public static CvsHandler createCheckoutHandler(CvsEnvironment environment, String[] checkoutPath, File target, boolean useAltCheckoutDir, boolean makeNewFilesReadOnly, PerformInBackgroundOption option) {
        CheckoutProjectOperation checkoutOperation = CheckoutProjectOperation.create(environment, checkoutPath, target, useAltCheckoutDir, makeNewFilesReadOnly);
        return new CommandCvsHandler(CvsBundle.message((String)"operation.name.check.out.project", (Object[])new Object[0]), (CvsOperation)checkoutOperation, FileSetToBeUpdated.allFiles(), option == null ? PerformInBackgroundOption.DEAF : option){

            @Override
            public void runComplitingActivities() {
                CvsEntriesManager.getInstance().clearAll();
            }
        };
    }

    public static CvsHandler createImportHandler(ImportDetails details) {
        return new CommandCvsHandler(CvsBundle.message((String)"operation.name.import", (Object[])new Object[0]), (CvsOperation)new ImportOperation(details), FileSetToBeUpdated.EMPTY);
    }

    public static UpdateHandler createUpdateHandler(FilePath[] files, UpdateSettings updateSettings, Project project, @NotNull UpdatedFiles updatedFiles) {
        if (updatedFiles == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/cvsSupport2/cvshandlers/CommandCvsHandler.createUpdateHandler must not be null");
        }
        return new UpdateHandler(files, updateSettings, project, updatedFiles);
    }

    public static CvsHandler createBranchOrTagHandler(FilePath[] selectedFiles, String branchName, boolean switchToThisAction, boolean overrideExisting, boolean isTag, boolean makeNewFilesReadOnly, Project project) {
        CompositeOperaton operation = new CompositeOperaton();
        operation.addOperation(new BranchOperation(selectedFiles, branchName, overrideExisting, isTag));
        if (switchToThisAction) {
            operation.addOperation(new UpdateOperation(selectedFiles, branchName, makeNewFilesReadOnly, project));
        }
        return new CommandCvsHandler(isTag ? CvsBundle.message((String)"operation.name.create.tag", (Object[])new Object[0]) : CvsBundle.message((String)"operation.name.create.branch", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(selectedFiles));
    }

    public static CvsHandler createCommitHandler(FilePath[] selectedFiles, String commitMessage, String title, boolean makeNewFilesReadOnly, Project project, boolean tagFilesAfterCommit, String tagName, final @NotNull List<File> dirsToPrune) {
        if (dirsToPrune == null) {
            throw new IllegalArgumentException("Argument 7 for @NotNull parameter of com/intellij/cvsSupport2/cvshandlers/CommandCvsHandler.createCommitHandler must not be null");
        }
        CommitFilesOperation operation = new CommitFilesOperation(commitMessage, makeNewFilesReadOnly);
        if (selectedFiles != null) {
            for (FilePath selectedFile : selectedFiles) {
                operation.addFile(selectedFile.getIOFile());
            }
        }
        if (!dirsToPrune.isEmpty()) {
            operation.addFinishAction(new Runnable(){

                @Override
                public void run() {
                    IOFilesBasedDirectoryPruner pruner = new IOFilesBasedDirectoryPruner(null);
                    for (File dir : dirsToPrune) {
                        pruner.addFile(dir);
                    }
                    pruner.execute();
                }
            });
        }
        CommandCvsHandler result = new CommandCvsHandler(title, (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(selectedFiles));
        if (tagFilesAfterCommit) {
            result.addOperation(new TagOperation(selectedFiles, tagName, CvsConfiguration.getInstance((Project)project).OVERRIDE_EXISTING_TAG_FOR_PROJECT));
        }
        return result;
    }

    public static CvsHandler createAddFilesHandler(Project project, Collection<AddedFileInfo> addedRoots) {
        AddFilesOperation operation = new AddFilesOperation();
        ArrayList<AddedFileInfo> addedFileInfo = new ArrayList<AddedFileInfo>();
        for (AddedFileInfo info : addedRoots) {
            info.clearAllCvsAdminDirectoriesInIncludedDirectories();
            addedFileInfo.addAll(info.collectAllIncludedFiles());
        }
        ArrayList<VirtualFile> addedFiles = new ArrayList<VirtualFile>();
        for (AddedFileInfo info : addedFileInfo) {
            addedFiles.add(info.getFile());
            operation.addFile(info.getFile(), info.getKeywordSubstitution());
        }
        return new CommandCvsHandler(CvsBundle.message((String)"action.name.add", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(VfsUtil.toVirtualFileArray(addedFiles)), VcsConfiguration.getInstance((Project)project).getAddRemoveOption());
    }

    public static CvsHandler createRemoveFilesHandler(Project project, Collection<File> files) {
        RemoveFilesOperation operation = new RemoveFilesOperation();
        for (File file : files) {
            operation.addFile(file.getPath());
        }
        return new CommandCvsHandler(CvsBundle.message((String)"action.name.remove", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(CommandCvsHandler.getAdminDirectoriesFor(files)), VcsConfiguration.getInstance((Project)project).getAddRemoveOption());
    }

    private static VirtualFile[] getAdminDirectoriesFor(Collection<File> files) {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (File file : files) {
            File parentFile = file.getParentFile();
            VirtualFile cvsAdminDirectory = CvsVfsUtil.findFileByIoFile(new File(parentFile, "CVS"));
            if (cvsAdminDirectory == null) continue;
            result.add(cvsAdminDirectory);
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    public static CvsHandler createRestoreFileHandler(final VirtualFile parent, String name, boolean makeNewFilesReadOnly) {
        final File ioFile = new File(VfsUtil.virtualToIoFile((VirtualFile)parent), name);
        final Entry entry = CvsEntriesManager.getInstance().getEntryFor(parent, name);
        final String revision = CommandCvsHandler.getRevision(entry);
        CheckoutFileByRevisionOperation operation = new CheckoutFileByRevisionOperation(parent, name, revision, makeNewFilesReadOnly);
        final CommandCvsHandler cvsHandler = new CommandCvsHandler(CvsBundle.message((String)"operation.name.restore", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.EMPTY);
        operation.addFinishAction(new Runnable(){

            @Override
            public void run() {
                List<VcsException> errors = cvsHandler.getErrors();
                if (errors != null && !errors.isEmpty()) {
                    return;
                }
                if (entry != null) {
                    entry.setRevision(revision);
                    entry.setConflict(CvsUtil.formatDate(new Date(ioFile.lastModified())));
                    try {
                        CvsUtil.saveEntryForFile(ioFile, entry);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                    CvsEntriesManager.getInstance().clearCachedEntriesFor(parent);
                }
            }
        });
        return cvsHandler;
    }

    public static CvsHandler createEditHandler(VirtualFile[] selectedFiles, boolean isReservedEdit) {
        EditOperation operation = new EditOperation(isReservedEdit);
        operation.addFiles(selectedFiles);
        return new CommandCvsHandler(CvsBundle.message((String)"action.name.edit", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(selectedFiles));
    }

    public static CvsHandler createUneditHandler(VirtualFile[] selectedFiles, boolean makeNewFilesReadOnly) {
        UneditOperation operation = new UneditOperation(makeNewFilesReadOnly);
        operation.addFiles(selectedFiles);
        return new CommandCvsHandler(CvsBundle.message((String)"operation.name.unedit", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(selectedFiles));
    }

    public static CvsHandler createRemoveTagAction(VirtualFile[] selectedFiles, String tagName) {
        return new CommandCvsHandler(CvsBundle.message((String)"action.name.delete.tag", (Object[])new Object[0]), (CvsOperation)new TagOperation(selectedFiles, tagName, true, false), FileSetToBeUpdated.EMPTY);
    }

    @Nullable
    private static String getRevision(Entry entry) {
        if (entry == null) {
            return null;
        }
        String result = entry.getRevision();
        if (result == null) {
            return null;
        }
        if (StringUtil.startsWithChar((CharSequence)result, (char)'-')) {
            return result.substring(1);
        }
        return result;
    }

    @Override
    public boolean isCanceled() {
        return this.myIsCanceled;
    }

    private boolean loginAll(ModalityContext executor) {
        HashSet<CvsRootProvider> allRoots = new HashSet<CvsRootProvider>();
        try {
            this.myCvsOperation.appendSelfCvsRootProvider(allRoots);
            for (CvsOperation postActivity : this.myPostActivities) {
                postActivity.appendSelfCvsRootProvider(allRoots);
            }
        }
        catch (CannotFindCvsRootException e) {
            this.myErrors.add(new VcsException((Throwable)e));
            return false;
        }
        LoginPerformer.MyForRootProvider performer = new LoginPerformer.MyForRootProvider((Collection<CvsRootProvider>)allRoots, new Consumer<VcsException>(){

            public void consume(VcsException e) {
                CommandCvsHandler.this.myErrors.add(e);
            }
        });
        return performer.loginAll(executor);
    }

    @Override
    public void internalRun(ModalityContext executor, boolean runInReadAction) {
        if (!this.login(executor)) {
            return;
        }
        try {
            CvsExecutionEnvironment executionEnvironment = new CvsExecutionEnvironment(this.myCompositeListener, this.getProgressListener(), this.myErrorMessageProcessor, executor, this.getPostActivityHandler());
            this.runOperation(executionEnvironment, runInReadAction, this.myCvsOperation);
            this.onOperationFinished(executor);
            while (!this.myPostActivities.isEmpty()) {
                CvsOperation cvsOperation = this.myPostActivities.get(0);
                this.runOperation(executionEnvironment, runInReadAction, cvsOperation);
                this.myPostActivities.remove(cvsOperation);
            }
        }
        catch (VcsException e) {
            this.myErrors.add(e);
        }
        catch (ProcessCanceledException e) {
            this.myIsCanceled = true;
        }
        catch (InvalidModuleDescriptionException ex) {
            this.myErrors.add(new CvsException(ex, ex.getCvsRoot()));
        }
        catch (InvalidEntryFormatException e) {
            this.myErrors.add(new VcsException(CvsBundle.message((String)"exception.text.entries.file.is.corrupted", (Object[])new Object[]{e.getEntriesFile()})));
        }
        catch (CvsProcessException ex) {
            this.myErrors.add(new CvsException(ex, this.myCvsOperation.getLastProcessedCvsRoot()));
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            this.myErrors.add(new CvsException(ex, this.myCvsOperation.getLastProcessedCvsRoot()));
        }
    }

    private void runOperation(final CvsExecutionEnvironment executionEnvironment, boolean runInReadAction, final CvsOperation cvsOperation) throws VcsException, CommandAbortedException {
        if (runInReadAction) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        cvsOperation.execute(executionEnvironment);
                    }
                    catch (VcsException e) {
                        CommandCvsHandler.this.myErrors.add(e);
                    }
                    catch (InvalidModuleDescriptionException ex) {
                        CommandCvsHandler.this.myErrors.add(new CvsException(ex, ex.getCvsRoot()));
                    }
                    catch (InvalidEntryFormatException e) {
                        CommandCvsHandler.this.myErrors.add(new VcsException(CvsBundle.message((String)"exception.text.entries.file.is.corrupted", (Object[])new Object[]{e.getEntriesFile()})));
                    }
                    catch (CvsProcessException ex) {
                        CommandCvsHandler.this.myErrors.add(new CvsException(ex, cvsOperation.getLastProcessedCvsRoot()));
                    }
                    catch (CommandAbortedException ex) {
                        LOG.error((Throwable)ex);
                        CommandCvsHandler.this.myErrors.add(new CvsException(ex, cvsOperation.getLastProcessedCvsRoot()));
                    }
                    catch (ProcessCanceledException ex) {
                        CommandCvsHandler.this.myIsCanceled = true;
                    }
                }
            });
        } else {
            cvsOperation.execute(executionEnvironment);
        }
    }

    protected void onOperationFinished(ModalityContext modalityContext) {
    }

    protected void addFileToCheckout(VirtualFile file) {
        this.addOperation(new CheckoutFileOperation(file.getParent(), RevisionOrDateImpl.createOn(file), file.getName(), false));
    }

    protected void addOperation(CvsOperation operation) {
        this.myPostActivities.add(operation);
    }

    protected PostCvsActivity getPostActivityHandler() {
        return PostCvsActivity.DEAF;
    }

    @Override
    protected int getFilesToProcessCount() {
        return this.myCvsOperation.getFilesToProcessCount();
    }

    public static CvsHandler createGetFileFromRepositoryHandler(CvsLightweightFile[] cvsLightweightFiles, boolean makeNewFilesReadOnly) {
        CompositeOperaton compositeOperaton = new CompositeOperaton();
        CvsEntriesManager entriesManager = CvsEntriesManager.getInstance();
        for (CvsLightweightFile cvsLightweightFile : cvsLightweightFiles) {
            File root = cvsLightweightFile.getRoot();
            File workingDirectory = root;
            if (workingDirectory == null) continue;
            if (cvsLightweightFile.getLocalFile().getParentFile().equals(workingDirectory)) {
                workingDirectory = workingDirectory.getParentFile();
            }
            String alternativeCheckoutPath = CommandCvsHandler.getAlternativeCheckoutPath(cvsLightweightFile, workingDirectory);
            CheckoutProjectOperation checkoutFileOperation = new CheckoutProjectOperation(new String[]{cvsLightweightFile.getModuleName()}, entriesManager.getCvsConnectionSettingsFor(root), makeNewFilesReadOnly, workingDirectory, alternativeCheckoutPath, true, null);
            compositeOperaton.addOperation(checkoutFileOperation);
        }
        return new CommandCvsHandler(CvsBundle.message((String)"action.name.get.file.from.repository", (Object[])new Object[0]), (CvsOperation)compositeOperaton, FileSetToBeUpdated.allFiles(), true);
    }

    private static String getAlternativeCheckoutPath(CvsLightweightFile cvsLightweightFile, File workingDirectory) {
        File parent = cvsLightweightFile.getLocalFile().getParentFile();
        return parent.getAbsolutePath().substring(workingDirectory.getAbsolutePath().length());
    }
}

