/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.IteratorUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IteratorNextDoesNotThrowNoSuchElementExceptionInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("IteratorNextCanNotThrowNoSuchElementException" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/IteratorNextDoesNotThrowNoSuchElementExceptionInspection.getID must not return null");
        }
        return "IteratorNextCanNotThrowNoSuchElementException";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("iterator.next.does.not.throw.nosuchelementexception.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/IteratorNextDoesNotThrowNoSuchElementExceptionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("iterator.next.does.not.throw.nosuchelementexception.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/IteratorNextDoesNotThrowNoSuchElementExceptionInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IteratorNextDoesNotThrowNoSuchElementExceptionVisitor();
    }

    private static class CalledMethodsVisitor
    extends JavaRecursiveElementVisitor {
        private boolean noSuchElementExceptionThrown = false;

        private CalledMethodsVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.noSuchElementExceptionThrown) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiElement method = methodExpression.resolve();
            if (method == null) {
                return;
            }
            Set<PsiType> exceptions = ExceptionUtils.calculateExceptionsThrown(method);
            for (PsiType exception : exceptions) {
                if (!exception.equalsToText("java.util.NoSuchElementException")) continue;
                this.noSuchElementExceptionThrown = true;
            }
        }

        public boolean isNoSuchElementExceptionThrown() {
            return this.noSuchElementExceptionThrown;
        }
    }

    private static class IteratorNextDoesNotThrowNoSuchElementExceptionVisitor
    extends BaseInspectionVisitor {
        private IteratorNextDoesNotThrowNoSuchElementExceptionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/IteratorNextDoesNotThrowNoSuchElementExceptionInspection$IteratorNextDoesNotThrowNoSuchElementExceptionVisitor.visitMethod must not be null");
            }
            if (!MethodUtils.methodMatches(method, "java.util.Iterator", null, "next", new PsiType[0])) {
                return;
            }
            Set<PsiType> exceptions = ExceptionUtils.calculateExceptionsThrown((PsiElement)method);
            for (PsiType exception : exceptions) {
                if (!exception.equalsToText("java.util.NoSuchElementException")) continue;
                return;
            }
            if (IteratorUtils.containsCallToIteratorNext((PsiElement)method, null, false)) {
                return;
            }
            CalledMethodsVisitor visitor = new CalledMethodsVisitor();
            method.accept((PsiElementVisitor)visitor);
            if (visitor.isNoSuchElementExceptionThrown()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

