/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class TestMethodInProductCodeInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.method.in.product.code.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestMethodInProductCodeInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("JUnitTestMethodInProductSource" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestMethodInProductCodeInspection.getID must not return null");
        }
        return "JUnitTestMethodInProductSource";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("test.method.in.product.code.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestMethodInProductCodeInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestCaseInProductCodeVisitor();
    }

    private static class TestCaseInProductCodeVisitor
    extends BaseInspectionVisitor {
        private TestCaseInProductCodeVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            PsiClass containingClass = method.getContainingClass();
            if (TestUtils.isTest(containingClass) || !TestUtils.isJUnit4TestMethod(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

