/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LoggingConditionDisagreesWithLogStatementInspection
extends BaseInspection {
    private static final Map<String, Log4jPriority> log4jLogMethodNames = new HashMap<String, Log4jPriority>();
    private static final Map<String, UtilLoggingLevel> utilLogMethodNames;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("logging.condition.disagrees.with.log.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/LoggingConditionDisagreesWithLogStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("logging.condition.disagrees.with.log.statement.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/LoggingConditionDisagreesWithLogStatementInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoggingConditionDisagreesWithLogStatementVisitor();
    }

    static {
        log4jLogMethodNames.put("debug", Log4jPriority.DEBUG);
        log4jLogMethodNames.put("error", Log4jPriority.ERROR);
        log4jLogMethodNames.put("fatal", Log4jPriority.FATAL);
        log4jLogMethodNames.put("info", Log4jPriority.INFO);
        log4jLogMethodNames.put("trace", Log4jPriority.TRACE);
        log4jLogMethodNames.put("warn", Log4jPriority.WARN);
        utilLogMethodNames = new HashMap<String, UtilLoggingLevel>();
        utilLogMethodNames.put("severe", UtilLoggingLevel.SEVERE);
        utilLogMethodNames.put("warning", UtilLoggingLevel.WARNING);
        utilLogMethodNames.put("info", UtilLoggingLevel.INFO);
        utilLogMethodNames.put("config", UtilLoggingLevel.CONFIG);
        utilLogMethodNames.put("fine", UtilLoggingLevel.FINE);
        utilLogMethodNames.put("finer", UtilLoggingLevel.FINER);
        utilLogMethodNames.put("finest", UtilLoggingLevel.FINEST);
    }

    private static class LoggingConditionDisagreesWithLogStatementVisitor
    extends BaseInspectionVisitor {
        private LoggingConditionDisagreesWithLogStatementVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiIfStatement ifStatement;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            Log4jPriority priority = (Log4jPriority)((Object)log4jLogMethodNames.get(referenceName));
            UtilLoggingLevel level = (UtilLoggingLevel)((Object)utilLogMethodNames.get(referenceName));
            if (priority == null && level == null) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            String qualifiedName = containingClass.getQualifiedName();
            boolean log4j = false;
            boolean javaUtilLogging = false;
            boolean commonsLogging = false;
            if ("org.apache.log4j.Logger".equals(qualifiedName) || "org.apache.log4j.Category".equals(qualifiedName)) {
                log4j = true;
            } else if ("java.util.logging.Logger".equals(qualifiedName)) {
                javaUtilLogging = true;
            } else if ("org.apache.commons.logging.Log".equals(qualifiedName)) {
                commonsLogging = true;
            } else {
                return;
            }
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiExpressionStatement)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiCodeBlock) {
                PsiElement greatGrandParent = grandParent.getParent();
                if (!(greatGrandParent instanceof PsiBlockStatement)) {
                    return;
                }
                PsiElement greatGreatGrandParent = greatGrandParent.getParent();
                if (!(greatGreatGrandParent instanceof PsiIfStatement)) {
                    return;
                }
                ifStatement = (PsiIfStatement)greatGreatGrandParent;
            } else if (grandParent instanceof PsiIfStatement) {
                ifStatement = (PsiIfStatement)grandParent;
            } else {
                return;
            }
            PsiExpression condition = ifStatement.getCondition();
            if (!(condition instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (target == null) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)condition;
            PsiReferenceExpression conditionMethodExpression = methodCallExpression.getMethodExpression();
            PsiExpression conditionQualifier = conditionMethodExpression.getQualifierExpression();
            if (!(conditionQualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression conditionReferenceExpression = (PsiReferenceExpression)conditionQualifier;
            PsiElement conditionTarget = conditionReferenceExpression.resolve();
            if (!target.equals(conditionTarget)) {
                return;
            }
            if (commonsLogging && !LoggingConditionDisagreesWithLogStatementVisitor.hasCommonsLoggingProblem(priority, methodCallExpression)) {
                return;
            }
            if (log4j && !LoggingConditionDisagreesWithLogStatementVisitor.hasLog4jProblem(priority, methodCallExpression)) {
                return;
            }
            if (javaUtilLogging && !LoggingConditionDisagreesWithLogStatementVisitor.hasUtilLoggingProblem(level, methodCallExpression)) {
                return;
            }
            this.registerMethodCallError(methodCallExpression, referenceName);
        }

        private static boolean hasUtilLoggingProblem(UtilLoggingLevel level, PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"isLoggable".equals(methodName)) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression argument = arguments[0];
            if (!(argument instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression argumentReference = (PsiReferenceExpression)argument;
            PsiType type = argument.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return false;
            }
            String qName = aClass.getQualifiedName();
            if (!"java.util.logging.Level".equals(qName)) {
                return false;
            }
            PsiElement argumentTarget = argumentReference.resolve();
            if (!(argumentTarget instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)argumentTarget;
            String name = field.getName();
            UtilLoggingLevel enabledFor = UtilLoggingLevel.valueOf(name);
            return enabledFor != level;
        }

        private static boolean hasCommonsLoggingProblem(Log4jPriority priority, PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            Log4jPriority enabledFor = null;
            if ("isTraceEnabled".equals(methodName)) {
                enabledFor = Log4jPriority.TRACE;
            } else if ("isDebugEnabled".equals(methodName)) {
                enabledFor = Log4jPriority.DEBUG;
            } else if ("isInfoEnabled".equals(methodName)) {
                enabledFor = Log4jPriority.INFO;
            } else if ("isWarnEnabled".equals(methodName)) {
                enabledFor = Log4jPriority.WARN;
            } else if ("isErrorEnabled".equals(methodName)) {
                enabledFor = Log4jPriority.ERROR;
            } else if ("isFatalEnabled".equals(methodName)) {
                enabledFor = Log4jPriority.FATAL;
            }
            return enabledFor != priority;
        }

        private static boolean hasLog4jProblem(Log4jPriority priority, PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            Log4jPriority enabledFor = null;
            if ("isDebugEnabled".equals(methodName)) {
                enabledFor = Log4jPriority.DEBUG;
            } else if ("isInfoEnabled".equals(methodName)) {
                enabledFor = Log4jPriority.INFO;
            } else if ("isTraceEnabled".equals(methodName)) {
                enabledFor = Log4jPriority.TRACE;
            } else if ("isEnabledFor".equals(methodName)) {
                PsiExpression[] arguments;
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                    PsiElement argumentTarget;
                    String qName;
                    PsiClassType classType;
                    PsiClass aClass;
                    if (!(argument instanceof PsiReferenceExpression)) continue;
                    PsiReferenceExpression argumentReference = (PsiReferenceExpression)argument;
                    PsiType type = argument.getType();
                    if (!(type instanceof PsiClassType) || (aClass = (classType = (PsiClassType)type).resolve()) == null || !"org.apache.log4j.Priority".equals(qName = aClass.getQualifiedName()) || !((argumentTarget = argumentReference.resolve()) instanceof PsiField)) continue;
                    PsiField field = (PsiField)argumentTarget;
                    String name = field.getName();
                    enabledFor = Log4jPriority.valueOf(name);
                }
            }
            return enabledFor != priority;
        }
    }

    static enum UtilLoggingLevel {
        SEVERE,
        WARNING,
        INFO,
        CONFIG,
        FINE,
        FINER,
        FINEST;

    }

    static enum Log4jPriority {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

