/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class DesignForExtensionInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("design.for.extension.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/security/DesignForExtensionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("design.for.extension.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/security/DesignForExtensionInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DesignForExtensionVisitor();
    }

    private static class DesignForExtensionVisitor
    extends BaseInspectionVisitor {
        private DesignForExtensionVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            if (JspPsiUtil.isInJspFile((PsiElement)method)) {
                return;
            }
            super.visitMethod(method);
            if (method.isConstructor()) {
                return;
            }
            if (method.hasModifierProperty("private") || method.hasModifierProperty("final") || method.hasModifierProperty("abstract") || method.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("final")) {
                return;
            }
            if (containingClass.getName() == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

