/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SynchronizationOnLocalVariableOrMethodParameterInspection
extends BaseInspection {
    public boolean reportLocalVariables = true;
    public boolean reportMethodParameters = true;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronization.on.local.variable.or.method.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string;
        Boolean localVariable = (Boolean)infos[0];
        if (localVariable.booleanValue()) {
            string = InspectionGadgetsBundle.message("synchronization.on.local.variable.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("synchronization.on.method.parameter.problem.descriptor", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection.buildErrorString must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizationOnLocalVariableVisitor();
    }

    private class SynchronizationOnLocalVariableVisitor
    extends BaseInspectionVisitor {
        private SynchronizationOnLocalVariableVisitor() {
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
            super.visitSynchronizedStatement(statement);
            if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables && !SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportMethodParameters) {
                return;
            }
            PsiExpression lockExpression = statement.getLockExpression();
            if (!(lockExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lockExpression;
            if (referenceExpression.isQualified()) {
                return;
            }
            boolean localVariable = false;
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiLocalVariable) {
                if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables) {
                    return;
                }
                localVariable = true;
            } else if (target instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)target;
                PsiElement scope = parameter.getDeclarationScope();
                if (scope instanceof PsiMethod) {
                    if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportMethodParameters) {
                        return;
                    }
                } else {
                    if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables) {
                        return;
                    }
                    localVariable = true;
                }
            } else {
                return;
            }
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiClass.class);
            if (!PsiTreeUtil.isAncestor((PsiElement)parentClass, (PsiElement)target, (boolean)true)) {
                return;
            }
            this.registerError((PsiElement)referenceExpression, localVariable);
        }
    }
}

